/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public class TxMultisend
extends Operation {
    public static final Parcelable.Creator<TxMultisend> CREATOR = new Parcelable.Creator<TxMultisend>(){

        public TxMultisend createFromParcel(Parcel in) {
            return new TxMultisend(in);
        }

        public TxMultisend[] newArray(int size) {
            return new TxMultisend[size];
        }
    };
    private List<TxSendCoin> mItems = new ArrayList<TxSendCoin>();

    public TxMultisend(@Nonnull Transaction rawTx) {
        super(rawTx);
    }

    protected TxMultisend(Parcel in) {
        super(in);
        if (in.readByte() == 1) {
            this.mItems = new ArrayList<TxSendCoin>();
            in.readList(this.mItems, TxSendCoin.class.getClassLoader());
        } else {
            this.mItems = Collections.emptyList();
        }
    }

    public List<TxSendCoin> getItems() {
        return this.mItems;
    }

    public TxSendCoin getItem(int index) {
        return this.mItems.size() > index && index > -1 ? this.mItems.get(index) : null;
    }

    public TxMultisend addItem(String coin, MinterAddress recipient, double value) {
        this.mItems.add(new TxSendCoin(this.getTx()).setCoin(coin).setTo(recipient).setValue(value));
        return this;
    }

    public TxMultisend addItem(String coin, MinterAddress recipient, BigDecimal value) {
        this.mItems.add(new TxSendCoin(this.getTx()).setCoin(coin).setTo(recipient).setValue(value));
        return this;
    }

    public TxMultisend addItem(String coin, String recipient, String value) {
        this.mItems.add(new TxSendCoin(this.getTx()).setCoin(coin).setTo(recipient).setValue(value));
        return this;
    }

    public TxMultisend addItem(String coin, String recipient, double value) {
        this.mItems.add(new TxSendCoin(this.getTx()).setCoin(coin).setTo(recipient).setValue(value));
        return this;
    }

    public TxMultisend addItem(TxSendCoin txSendCoin) {
        this.mItems.add(txSendCoin);
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.Multisend;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        if (this.mItems == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.mItems);
        }
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mItems", this.mItems.size() > 0, "You should add at least one send transaction data");
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        Object[] items = (Object[])decoded[0];
        this.mItems = new LinkedList<TxSendCoin>();
        for (int i = 0; i < items.length; ++i) {
            TxSendCoin data = new TxSendCoin(this.getTx());
            data.decodeRaw(this.objArrToByteArrArr((Object[])items[i]));
            this.mItems.add(i, data);
        }
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        Object[][] items = new Object[this.mItems.size()][3];
        for (int i = 0; i < this.mItems.size(); ++i) {
            byte[] to = this.mItems.get(i).getTo().getData();
            to = BytesHelper.lpad((int)20, (byte[])to);
            items[i] = new Object[]{this.mItems.get(i).getCoinRaw(), to, this.mItems.get(i).getValueBigInteger()};
        }
        return RLP.encode((Object)new Object[]{items});
    }
}

