/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PublicKey;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public class TxEditCandidateTransaction
extends Operation {
    public static final Parcelable.Creator<TxEditCandidateTransaction> CREATOR = new Parcelable.Creator<TxEditCandidateTransaction>(){

        public TxEditCandidateTransaction createFromParcel(Parcel in) {
            return new TxEditCandidateTransaction(in);
        }

        public TxEditCandidateTransaction[] newArray(int size) {
            return new TxEditCandidateTransaction[size];
        }
    };
    private PublicKey mPubKey;
    private MinterAddress mRewardAddress;
    private MinterAddress mOwnerAddress;

    public TxEditCandidateTransaction(@Nonnull Transaction rawTx) {
        super(rawTx);
    }

    protected TxEditCandidateTransaction(Parcel in) {
        super(in);
        this.mPubKey = (PublicKey)in.readValue(PublicKey.class.getClassLoader());
        this.mRewardAddress = (MinterAddress)in.readValue(MinterAddress.class.getClassLoader());
        this.mOwnerAddress = (MinterAddress)in.readValue(MinterAddress.class.getClassLoader());
    }

    public TxEditCandidateTransaction setPublicKey(PublicKey key) {
        this.mPubKey = key;
        return this;
    }

    public PublicKey getPubKey() {
        return this.mPubKey;
    }

    public MinterAddress getRewardAddress() {
        return this.mRewardAddress;
    }

    public TxEditCandidateTransaction setRewardAddress(MinterAddress address) {
        this.mRewardAddress = address;
        return this;
    }

    public MinterAddress getOwnerAddress() {
        return this.mOwnerAddress;
    }

    public TxEditCandidateTransaction setOwnerAddress(MinterAddress address) {
        this.mOwnerAddress = address;
        return this;
    }

    @Override
    public int describeContents() {
        return super.describeContents();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mPubKey);
        dest.writeValue((Object)this.mRewardAddress);
        dest.writeValue((Object)this.mOwnerAddress);
    }

    @Override
    public OperationType getType() {
        return OperationType.EditCandidate;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mPubKey", this.mPubKey != null, "Node public key must be set").addResult("mRewardAddress", this.mRewardAddress != null, "Reward address must be set").addResult("mOwnerAddress", this.mOwnerAddress != null, "Owner address must be set");
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mPubKey = new PublicKey(this.fromRawRlp(0, decoded));
        this.mRewardAddress = new MinterAddress(this.fromRawRlp(1, decoded));
        this.mOwnerAddress = new MinterAddress(this.fromRawRlp(2, decoded));
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mPubKey.getData(), this.mRewardAddress.getData(), this.mOwnerAddress.getData()});
    }
}

