/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class SignatureMultiData
extends SignatureData {
    public static final Parcelable.Creator<SignatureMultiData> CREATOR = new Parcelable.Creator<SignatureMultiData>(){

        public SignatureMultiData createFromParcel(Parcel in) {
            return new SignatureMultiData(in);
        }

        public SignatureMultiData[] newArray(int size) {
            return new SignatureMultiData[size];
        }
    };
    private MinterAddress mSignatureAddress;
    private List<SignatureSingleData> mSignatures;

    public SignatureMultiData() {
    }

    protected SignatureMultiData(Parcel in) {
        this.mSignatureAddress = (MinterAddress)in.readValue(MinterAddress.class.getClassLoader());
        if (in.readByte() == 1) {
            this.mSignatures = new ArrayList<SignatureSingleData>();
            in.readList(this.mSignatures, SignatureSingleData.class.getClassLoader());
        } else {
            this.mSignatures = null;
        }
    }

    public MinterAddress getSignatureAddress() {
        return this.mSignatureAddress;
    }

    public List<SignatureSingleData> getSignatures() {
        return this.mSignatures;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.mSignatureAddress);
        if (this.mSignatures == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.mSignatures);
        }
    }

    protected void setSigns(MinterAddress signatureAddress, List<SignatureSingleData> signatures) {
        this.mSignatureAddress = signatureAddress;
        this.mSignatures = signatures;
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mSignatureAddress = new MinterAddress(this.fromRawRlp(0, decoded));
        Object[] signs = (Object[])decoded[1];
        this.mSignatures = new LinkedList<SignatureSingleData>();
        for (int i = 0; i < signs.length; ++i) {
            SignatureSingleData data = new SignatureSingleData();
            data.decodeRaw(this.objArrToByteArrArr((Object[])signs[i]));
            this.mSignatures.add(i, data);
        }
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        Object[][] signatures = new Object[this.mSignatures.size()][];
        for (int i = 0; i < this.mSignatures.size(); ++i) {
            signatures[i] = new Object[]{this.mSignatures.get(i).getV(), this.mSignatures.get(i).getR(), this.mSignatures.get(i).getS()};
        }
        return RLP.encode((Object)new Object[]{this.mSignatureAddress.getData(), signatures});
    }
}

