/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Map;
import network.minter.blockchain.models.operational.Transaction;
import org.parceler.Parcel;

@Parcel
public class Balance {
    public Map<String, CoinBalance> coins;
    @SerializedName(value="transaction_count")
    public BigInteger txCount;

    public CoinBalance get(String coin) {
        return this.coins.get(coin.toUpperCase());
    }

    public BigDecimal getFor(String coin) {
        if (!this.coins.containsKey(coin.toUpperCase())) {
            return new BigDecimal("0");
        }
        return this.coins.get(coin.toUpperCase()).getBalance();
    }

    @Parcel
    public static class CoinBalance {
        public String coin;
        public BigInteger balance;

        public String getCoin() {
            return this.coin;
        }

        public BigDecimal getBalance() {
            return new BigDecimal(this.balance).setScale(18, RoundingMode.UNNECESSARY).divide(Transaction.VALUE_MUL_DEC, 7);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.coin, this.balance});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoinBalance balance1 = (CoinBalance)o;
            return Objects.equal((Object)this.coin, (Object)balance1.coin) && Objects.equal((Object)this.balance, (Object)balance1.balance);
        }
    }
}

