/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.BytesData;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxRedeemCheck
extends Operation {
    public static final Parcelable.Creator<TxRedeemCheck> CREATOR = new Parcelable.Creator<TxRedeemCheck>(){

        public TxRedeemCheck createFromParcel(Parcel in) {
            return new TxRedeemCheck(in);
        }

        public TxRedeemCheck[] newArray(int size) {
            return new TxRedeemCheck[size];
        }
    };
    private static final int PROOF_LENGTH = 65;
    private BytesData mRawCheck;
    private BytesData mProof;

    public TxRedeemCheck(Transaction rawTx) {
        super(rawTx);
    }

    protected TxRedeemCheck(Parcel in) {
        super(in);
        this.mRawCheck = (BytesData)in.readValue(BytesData.class.getClassLoader());
        this.mProof = (BytesData)in.readValue(BytesData.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mRawCheck);
        dest.writeValue((Object)this.mProof);
    }

    public BytesData getRawCheck() {
        return this.mRawCheck;
    }

    public TxRedeemCheck setRawCheck(byte[] data) {
        this.mRawCheck = new BytesData(data);
        return this;
    }

    public TxRedeemCheck setRawCheck(BytesData data) {
        this.mRawCheck = data.clone();
        return this;
    }

    public TxRedeemCheck setRawCheck(String hexString) {
        this.mRawCheck = new BytesData((CharSequence)hexString);
        return this;
    }

    public BytesData getProof() {
        return this.mProof;
    }

    public TxRedeemCheck setProof(byte[] data) {
        Preconditions.checkArgument((data.length == 65 ? 1 : 0) != 0, (Object)String.format(Locale.getDefault(), "Proof must coins exact %d bytes", 65));
        this.mProof = new BytesData(data);
        return this;
    }

    public TxRedeemCheck setProof(BytesData data) {
        Preconditions.checkArgument((data.size() == 65 ? 1 : 0) != 0, (Object)String.format(Locale.getDefault(), "Proof must coins exact %d bytes", 65));
        this.mProof = data.clone();
        return this;
    }

    public TxRedeemCheck setProof(String hexString) {
        Preconditions.checkArgument((hexString.length() == 130 ? 1 : 0) != 0, (Object)String.format(Locale.getDefault(), "Proof must coins exact %d bytes (%d hex string len)", 65, 130));
        this.mProof = new BytesData((CharSequence)hexString);
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.RedeemCheck;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mRawCheck", this.mRawCheck != null, "Check data must be set").addResult("mProof", this.mProof != null && this.mProof.size() == 65, String.format(Locale.getDefault(), "Proof data must be set (%d bytes)", 65));
    }

    @Override
    @Nonnull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mRawCheck, this.mProof});
    }

    @Override
    protected void decodeRLP(@Nonnull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mRawCheck = new BytesData(this.fromRawRlp(0, decoded));
        this.mProof = new BytesData(this.fromRawRlp(1, decoded));
    }
}

