/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import com.edwardstock.secp256k1.NativeSecp256k1;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.SignatureData;
import network.minter.blockchain.models.operational.SignatureMultiData;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.blockchain.models.operational.TxCoinBuy;
import network.minter.blockchain.models.operational.TxCoinSell;
import network.minter.blockchain.models.operational.TxCoinSellAll;
import network.minter.blockchain.models.operational.TxCreateCoin;
import network.minter.blockchain.models.operational.TxDeclareCandidacy;
import network.minter.blockchain.models.operational.TxDelegate;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.blockchain.models.operational.TxSetCandidateOffline;
import network.minter.blockchain.models.operational.TxSetCandidateOnline;
import network.minter.blockchain.models.operational.TxUnbound;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.internal.log.Mint;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public class Transaction
implements Parcelable {
    public static final BigInteger VALUE_MUL = new BigInteger("1000000000000000000", 10);
    public static final BigDecimal VALUE_MUL_DEC = new BigDecimal("1000000000000000000");
    public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

        public Transaction createFromParcel(Parcel in) {
            return new Transaction(in);
        }

        public Transaction[] newArray(int size) {
            return new Transaction[size];
        }
    };
    private BigInteger mNonce;
    private BigInteger mGasPrice = new BigInteger("1");
    private String mGasCoin = "MNT";
    private OperationType mType = OperationType.SendCoin;
    private Operation mOperationData;
    private BytesData mPayload = new BytesData(new byte[0]);
    private BytesData mServiceData = new BytesData(new byte[0]);
    private SignatureType mSignatureType = SignatureType.Single;
    private SignatureData mSignatureData;

    protected Transaction(BigInteger nonce) {
        this.mNonce = nonce;
    }

    protected Transaction() {
    }

    protected Transaction(Parcel in) {
        this.mNonce = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mGasPrice = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mGasCoin = in.readString();
        this.mType = (OperationType)((Object)in.readValue(OperationType.class.getClassLoader()));
        this.mOperationData = (Operation)in.readValue(Operation.class.getClassLoader());
        this.mPayload = (BytesData)in.readValue(BytesData.class.getClassLoader());
        this.mServiceData = (BytesData)in.readValue(BytesData.class.getClassLoader());
        this.mSignatureType = (SignatureType)((Object)in.readValue(SignatureType.class.getClassLoader()));
        this.mSignatureData = (SignatureData)in.readValue(this.mSignatureType.mTypeClass.getClassLoader());
    }

    public static Transaction fromEncoded(@Nonnull String hexEncoded) {
        Preconditions.checkNotNull((Object)hexEncoded, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((hexEncoded.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        BytesData bd = new BytesData((CharSequence)hexEncoded);
        DecodeResult rlp = RLP.decode((byte[])bd.getData(), (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        Transaction transaction = new Transaction();
        transaction.decodeRLP(decoded);
        ReflectiveOperationException t = null;
        try {
            transaction.mOperationData = transaction.mType.getOpClass().getDeclaredConstructor(Transaction.class).newInstance(transaction);
            transaction.mOperationData.decodeRLP(transaction.fromRawRlp(4, decoded));
            transaction.mSignatureData = transaction.mSignatureType.getSignClass().newInstance();
            transaction.mSignatureData.decodeRLP(transaction.fromRawRlp(8, decoded));
        }
        catch (InstantiationException e) {
            t = e;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        catch (NoSuchMethodException e) {
            t = e;
        }
        catch (InvocationTargetException e) {
            t = e;
        }
        if (t != null) {
            Mint.e((Throwable)t, (String)"Unable to decode transaction", (Object[])new Object[0]);
            return null;
        }
        return transaction;
    }

    public void cleanup() {
        this.mNonce = null;
        this.mGasPrice = null;
        this.mGasCoin = null;
        this.mType = null;
        this.mOperationData = null;
        this.mPayload = null;
        this.mServiceData = null;
        this.mSignatureType = null;
        this.mSignatureData = null;
    }

    public SignatureType getSignatureType() {
        return this.mSignatureType;
    }

    public <SignData extends SignatureData> SignData getSignatureData(Class<SignData> cls) {
        return (SignData)((SignatureData)cls.cast(this.mSignatureData));
    }

    public <SignData extends SignatureData> SignData getSignatureData() {
        return (SignData)this.mSignatureData;
    }

    public BigInteger getNonce() {
        return this.mNonce;
    }

    public BigInteger getGasPrice() {
        return this.mGasPrice;
    }

    public OperationType getType() {
        return this.mType;
    }

    @Deprecated
    public TransactionSign sign(@Nonnull PrivateKey privateKey) {
        return this.signSingle(privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionSign signMulti(MinterAddress signatureAddress, @Nonnull List<PrivateKey> privateKeys) {
        this.mSignatureType = SignatureType.Multi;
        Preconditions.checkArgument((privateKeys.size() > 0 ? 1 : 0) != 0, (Object)"Private keys can't be empty");
        BytesData rawTxData = new BytesData(this.encode(true));
        BytesData hash = rawTxData.sha3Data();
        ArrayList<SignatureSingleData> signaturesData = new ArrayList<SignatureSingleData>(privateKeys.size());
        long ctx = NativeSecp256k1.contextCreate();
        try {
            for (PrivateKey pk : privateKeys) {
                NativeSecp256k1.RecoverableSignature signature = NativeSecp256k1.signRecoverableSerialized((long)ctx, (byte[])hash.getData(), (byte[])pk.getData());
                SignatureSingleData signatureData = new SignatureSingleData();
                signatureData.setSign(signature);
                signaturesData.add(signatureData);
            }
        }
        finally {
            NativeSecp256k1.contextCleanup((long)ctx);
        }
        this.mSignatureData = new SignatureMultiData();
        ((SignatureMultiData)this.mSignatureData).setSigns(signatureAddress, signaturesData);
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionSign signSingle(@Nonnull PrivateKey privateKey) {
        NativeSecp256k1.RecoverableSignature signature;
        this.mSignatureType = SignatureType.Single;
        BytesData rawTxData = new BytesData(this.encode(true));
        BytesData hash = rawTxData.sha3Data();
        long ctx = NativeSecp256k1.contextCreate();
        try {
            signature = NativeSecp256k1.signRecoverableSerialized((long)ctx, (byte[])hash.getData(), (byte[])privateKey.getData());
        }
        finally {
            NativeSecp256k1.contextCleanup((long)ctx);
        }
        if (signature == null) {
            return null;
        }
        this.mSignatureData = new SignatureSingleData();
        ((SignatureSingleData)this.mSignatureData).setSign(signature);
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    public <OpType extends Operation> OpType getData(Class<OpType> cls) {
        return (OpType)((Operation)cls.cast(this.mOperationData));
    }

    public <OpType extends Operation> OpType getData() {
        return (OpType)this.mOperationData;
    }

    <Op extends Operation> Transaction setData(Op operationData) {
        this.mOperationData = operationData;
        this.mType = operationData.getType();
        return this;
    }

    public String getGasCoin() {
        return this.mGasCoin.replace("\u0000", "");
    }

    public BytesData getPayload() {
        return this.mPayload;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.mNonce);
        dest.writeValue((Object)this.mGasPrice);
        dest.writeString(this.mGasCoin);
        dest.writeValue((Object)this.mType);
        dest.writeValue((Object)this.mOperationData);
        dest.writeValue((Object)this.mPayload);
        dest.writeValue((Object)this.mServiceData);
        dest.writeValue((Object)this.mSignatureType);
        dest.writeValue((Object)this.mSignatureType);
    }

    byte[] fromRawRlp(int idx, Object[] raw) {
        if (raw[idx] instanceof String) {
            return ((String)raw[idx]).getBytes();
        }
        return (byte[])raw[idx];
    }

    void decodeRLP(Object[] raw) {
        this.mNonce = new BigInteger(this.fromRawRlp(0, raw));
        this.mGasPrice = new BigInteger(this.fromRawRlp(1, raw));
        this.mGasCoin = StringHelper.bytesToString((byte[])this.fromRawRlp(2, raw), (int)10);
        this.mType = OperationType.findByValue(new BigInteger(this.fromRawRlp(3, raw)));
        this.mPayload = new BytesData(this.fromRawRlp(5, raw));
        this.mServiceData = new BytesData(this.fromRawRlp(6, raw));
        this.mSignatureType = SignatureType.findByValue(new BigInteger(this.fromRawRlp(7, raw)));
    }

    byte[] encode(boolean forSignature) {
        byte[] data = this.mOperationData.encodeRLP();
        if (forSignature) {
            return RLP.encode((Object)new Object[]{this.mNonce, this.mGasPrice, this.mGasCoin, this.mOperationData.getType().getValue(), data, this.mPayload.getData(), this.mServiceData.getData(), this.mSignatureType.getValue()});
        }
        byte[] signData = this.mSignatureData.encodeRLP();
        return RLP.encode((Object)new Object[]{this.mNonce, this.mGasPrice, this.mGasCoin, this.mOperationData.getType().getValue(), data, this.mPayload.getData(), this.mServiceData.getData(), this.mSignatureType.getValue(), signData});
    }

    FieldsValidationResult validate() {
        return new FieldsValidationResult("Invalid transaction data").addResult("nonce", this.mNonce != null, "Nonce must be set").addResult("gasPrice", this.mGasCoin != null, "Gas coin must be set").addResult("operationData", this.mOperationData != null, "Operation data does not set! Check your operation model.");
    }

    public static class Builder {
        private final Transaction mTx;

        public Builder(BigInteger nonce) {
            this.mTx = new Transaction(nonce);
        }

        public Builder setGasCoin(String coin) {
            this.mTx.mGasCoin = StringHelper.strrpad((int)10, (String)coin);
            return this;
        }

        public Builder setPayload(byte[] data) {
            return this.setPayload(new BytesData(data, true));
        }

        public Builder setPayload(BytesData data) {
            Preconditions.checkArgument((data.size() <= 1024 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes");
            this.mTx.mPayload = new BytesData(data, true);
            return this;
        }

        public Builder setPayload(@Nonnull String hexString) {
            Preconditions.checkNotNull((Object)hexString, (String)"Hex data string can't be null");
            Preconditions.checkArgument((hexString.length() <= 2048 ? 1 : 0) != 0, (Object)"Payload maximum size: 1024 bytes (2048 in hex string)");
            this.mTx.mPayload = new BytesData((CharSequence)hexString);
            return this;
        }

        public Builder setPayload(ByteBuffer byteBuffer) {
            return this.setPayload(byteBuffer.array());
        }

        public Builder setNonce(BigInteger nonce) {
            this.mTx.mNonce = nonce;
            return this;
        }

        public <Op extends Operation> Op create(Class<Op> operationClass) {
            try {
                return (Op)((Operation)operationClass.getDeclaredConstructor(Transaction.class).newInstance(this.mTx));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public TxCoinBuy buyCoin() {
            return new TxCoinBuy(this.mTx);
        }

        public TxCoinSell sellCoin() {
            return new TxCoinSell(this.mTx);
        }

        public TxCoinSellAll sellAllCoins() {
            return new TxCoinSellAll(this.mTx);
        }

        public TxCreateCoin createCoin() {
            return new TxCreateCoin(this.mTx);
        }

        public TxDeclareCandidacy declareCandidacy() {
            return new TxDeclareCandidacy(this.mTx);
        }

        public TxDelegate delegate() {
            return new TxDelegate(this.mTx);
        }

        public TxRedeemCheck redeemCheck() {
            return new TxRedeemCheck(this.mTx);
        }

        public TxSendCoin sendCoin() {
            return new TxSendCoin(this.mTx);
        }

        public TxSetCandidateOffline setCandidateOffline() {
            return new TxSetCandidateOffline(this.mTx);
        }

        public TxSetCandidateOnline setCandidateOnline() {
            return new TxSetCandidateOnline(this.mTx);
        }

        public TxUnbound unbound() {
            return new TxUnbound(this.mTx);
        }
    }

    public static enum SignatureType {
        Single(1, SignatureSingleData.class),
        Multi(2, SignatureMultiData.class);

        BigInteger mVal;
        Class<? extends SignatureData> mTypeClass;

        private SignatureType(byte val, Class<? extends SignatureData> cls) {
            this.mVal = new BigInteger(String.valueOf(val));
            this.mTypeClass = cls;
        }

        public static SignatureType findByValue(BigInteger val) {
            for (SignatureType t : SignatureType.values()) {
                if (!t.getValue().equals(val)) continue;
                return t;
            }
            return null;
        }

        public BigInteger getValue() {
            return this.mVal;
        }

        public Class<? extends SignatureData> getSignClass() {
            return this.mTypeClass;
        }
    }
}

