/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;

public class BCResult<Result> {
    public ResultCode code = ResultCode.Success;
    public int statusCode = 200;
    @SerializedName(value="result")
    public Result result;
    @SerializedName(value="log")
    public String message;

    public static <T> BCResult<T> copyError(BCResult<?> another) {
        BCResult out = new BCResult();
        out.statusCode = another.statusCode;
        out.code = another.code;
        out.message = another.message;
        return out;
    }

    public boolean isSuccess() {
        return this.statusCode == 200 && this.code == ResultCode.Success;
    }

    public static enum ResultCode {
        Success(0),
        WrongNonce(101),
        CoinNotExists(102),
        CoinReserveNotSufficient(103),
        TxTooLarge(105),
        DecodeError(106),
        InsufficientFunds(107),
        TxPayloadTooLarge(109),
        TxServiceDataTooLarge(110),
        CoinAlreadyExists(201),
        WrongCrr(202),
        InvalidCoinSymbol(203),
        InvalidCoinName(204),
        CrossConvert(301),
        CandidateExists(401),
        WrongCommission(402),
        CandidateNotFound(403),
        StakeNotFound(404),
        InsufficientStake(405),
        IsNotOwnerOfCandidate(406),
        IncorrectPubKey(407),
        StakeShouldBePositive(408),
        CheckInvalidLock(501),
        CheckExpired(502),
        CheckUsed(503),
        TooHighGasPrice(504),
        WrongGasCoin(505);

        final int resVal;

        private ResultCode(int v) {
            this.resVal = v;
        }

        public int getValue() {
            return this.resVal;
        }
    }
}

