/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.utils;

import network.minter.core.crypto.BytesData;
import org.spongycastle.util.encoders.Base64;

public class Base64UrlSafe {
    private static final char PADDING = '=';
    private static final char[] TO_ESCAPE = new char[]{'+', '/'};
    private static final char[] TO_REPLACE = new char[]{'-', '_'};

    public static BytesData encode(BytesData bytesData) {
        return new BytesData(Base64UrlSafe.encodeString(bytesData).getBytes());
    }

    public static BytesData encode(byte[] byArray) {
        return new BytesData(Base64UrlSafe.encodeString(byArray).getBytes());
    }

    public static BytesData encode(char[] cArray) {
        return new BytesData(Base64UrlSafe.encodeString(cArray).getBytes());
    }

    public static String encodeString(String string) {
        return Base64UrlSafe.encodeString(string.getBytes());
    }

    public static String encodeString(BytesData bytesData) {
        return Base64UrlSafe.encodeString(bytesData.getBytes());
    }

    public static String encodeString(byte[] byArray) {
        String string;
        String string2 = string;
        string = new String(Base64.encode((byte[])byArray));
        int n = 0;
        while (true) {
            char[] cArray = TO_ESCAPE;
            if (n >= TO_ESCAPE.length) break;
            string2 = string2.replace(cArray[n], TO_REPLACE[n]);
            ++n;
        }
        return Base64UrlSafe.substrRemove(string2, '=');
    }

    public static String encodeString(char[] cArray) {
        return Base64UrlSafe.encodeString(new BytesData(cArray).getBytes());
    }

    public static BytesData decode(BytesData bytesData) {
        return Base64UrlSafe.decode(bytesData.stringValue());
    }

    public static BytesData decode(byte[] byArray) {
        return Base64UrlSafe.decode(new String(byArray));
    }

    public static BytesData decode(char[] cArray) {
        return Base64UrlSafe.decode(new String(cArray));
    }

    public static BytesData decode(String object) {
        int n = 0;
        while (true) {
            char[] cArray = TO_REPLACE;
            if (n >= TO_REPLACE.length) break;
            object = ((String)object).replace(cArray[n], TO_ESCAPE[n]);
            ++n;
        }
        if (((String)object).length() % 4 != 0) {
            object = (String)object + Base64UrlSafe.strRepeat('=', 4 - ((String)object).length() % 4);
        }
        object = Base64.decode((String)object);
        return new BytesData((byte[])object);
    }

    public static String decodeString(String string) {
        return Base64UrlSafe.decode(string.getBytes()).stringValue();
    }

    private static String strRepeat(char c, int n) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(c);
        }
        return stringBuilder2.toString();
    }

    private static String substrRemove(String string, char c) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            stringBuilder2.append(string.charAt(i));
        }
        return stringBuilder2.toString();
    }
}

