/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLPBoxed;

public final class TxCoinSell
extends Operation {
    public static final Parcelable.Creator<TxCoinSell> CREATOR = new Parcelable.Creator<TxCoinSell>(){

        public TxCoinSell createFromParcel(Parcel parcel) {
            return new TxCoinSell(parcel);
        }

        public TxCoinSell[] newArray(int n) {
            return new TxCoinSell[n];
        }
    };
    private String mCoinToSell;
    private BigInteger mValueToSell;
    private String mCoinToBuy;
    private BigInteger mMinValueToBuy;

    public TxCoinSell() {
    }

    public TxCoinSell(Transaction transaction) {
        super(transaction);
    }

    protected TxCoinSell(Parcel parcel) {
        super(parcel);
        this.mCoinToSell = parcel.readString();
        this.mValueToSell = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
        this.mCoinToBuy = parcel.readString();
        this.mMinValueToBuy = (BigInteger)parcel.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TxCoinSell txCoinSell = this;
        super.writeToParcel(parcel, n);
        parcel.writeString(txCoinSell.mCoinToSell);
        parcel.writeValue((Object)this.mValueToSell);
        parcel.writeString(this.mCoinToBuy);
        parcel.writeValue((Object)this.mMinValueToBuy);
    }

    public String getCoinToSell() {
        return this.mCoinToSell.replace("\u0000", "");
    }

    public TxCoinSell setCoinToSell(String string) {
        this.mCoinToSell = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public String getCoinToBuy() {
        return this.mCoinToBuy.replace("\u0000", "");
    }

    public TxCoinSell setCoinToBuy(String string) {
        this.mCoinToBuy = StringHelper.strrpad((int)10, (String)string.toUpperCase());
        return this;
    }

    public BigDecimal getMinValueToBuy() {
        return Transaction.humanizeValue(this.mMinValueToBuy);
    }

    public BigInteger getValueToSellBigInteger() {
        return this.mValueToSell;
    }

    public TxCoinSell setMinValueToBuy(BigDecimal bigDecimal) {
        return this.setMinValueToBuy(Transaction.normalizeValue(bigDecimal));
    }

    public TxCoinSell setValueToSell(BigInteger bigInteger) {
        this.mValueToSell = bigInteger;
        return this;
    }

    public TxCoinSell setMinValueToBuy(@Nonnull CharSequence charSequence) {
        return this.setMinValueToBuy(new BigDecimal(charSequence.toString()));
    }

    public BigDecimal getValueToSell() {
        return Transaction.humanizeValue(this.mValueToSell);
    }

    public TxCoinSell setValueToSell(@Nonnull CharSequence charSequence) {
        return this.setValueToSell(new BigDecimal(charSequence.toString()));
    }

    public TxCoinSell setMinValueToBuy(BigInteger bigInteger) {
        this.mMinValueToBuy = bigInteger;
        return this;
    }

    public TxCoinSell setValueToSell(BigDecimal bigDecimal) {
        return this.setValueToSell(Transaction.normalizeValue(bigDecimal));
    }

    @Override
    public OperationType getType() {
        return OperationType.SellCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        FieldsValidationResult fieldsValidationResult;
        Object object = fieldsValidationResult;
        fieldsValidationResult = new FieldsValidationResult();
        String string = "mCoinToBuy";
        String string2 = ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToBuy;
        boolean bl = string2 != null && string2.length() > 2 && ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToBuy.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl, "Coin length must be from 3 to 10 chars");
        string = "mCoinToSell";
        String string3 = ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToSell;
        boolean bl2 = string3 != null && string3.length() > 2 && ((TxCoinSell)((Object)fieldsValidationResult2)).mCoinToSell.length() < 11;
        object = ((FieldsValidationResult)object).addResult(string, bl2, "Coin length must be from 3 to 10 chars");
        string = "mValueToSell";
        bl2 = ((TxCoinSell)((Object)fieldsValidationResult2)).mValueToSell != null;
        TxCoinSell txCoinSell = fieldsValidationResult2;
        FieldsValidationResult fieldsValidationResult2 = ((FieldsValidationResult)object).addResult(string, bl2, "Value must be set");
        object = "mMinValueToBuy";
        boolean bl3 = txCoinSell.mMinValueToBuy != null;
        return fieldsValidationResult2.addResult((String)object, bl3, "Minimum value to buy must be set");
    }

    @Override
    @Nonnull
    protected char[] encodeRLP() {
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mCoinToSell;
        objectArray2[1] = this.mValueToSell;
        objectArray2[2] = this.mCoinToBuy;
        objectArray[3] = this.mMinValueToBuy;
        return RLPBoxed.encode((Object)objectArray);
    }

    @Override
    protected void decodeRLP(@Nonnull char[] cArray) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = objectArray3;
        Object[] objectArray3 = (Object[])RLPBoxed.decode((char[])cArray, (int)0).getDecoded();
        objectArray2.mCoinToSell = StringHelper.charsToString((char[])objectArray.fromRawRlp(0, objectArray3));
        objectArray2.mValueToSell = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(1, objectArray3));
        objectArray2.mCoinToBuy = StringHelper.charsToString((char[])objectArray.fromRawRlp(2, objectArray3));
        objectArray2.mMinValueToBuy = BytesHelper.fixBigintSignedByte((char[])objectArray.fromRawRlp(3, objectArray3));
    }
}

