/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.TxCoinBuy;
import network.minter.blockchain.models.operational.TxCoinSell;
import network.minter.blockchain.models.operational.TxCoinSellAll;
import network.minter.blockchain.models.operational.TxCreateCoin;
import network.minter.blockchain.models.operational.TxCreateMultisigAddress;
import network.minter.blockchain.models.operational.TxDeclareCandidacy;
import network.minter.blockchain.models.operational.TxDelegate;
import network.minter.blockchain.models.operational.TxEditCandidate;
import network.minter.blockchain.models.operational.TxMultisend;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.blockchain.models.operational.TxSetCandidateOffline;
import network.minter.blockchain.models.operational.TxSetCandidateOnline;
import network.minter.blockchain.models.operational.TxUnbound;

public final class OperationType
extends Enum<OperationType> {
    @SerializedName(value="1")
    public static final /* enum */ OperationType SendCoin;
    @SerializedName(value="2")
    public static final /* enum */ OperationType SellCoin;
    @SerializedName(value="3")
    public static final /* enum */ OperationType SellAllCoins;
    @SerializedName(value="4")
    public static final /* enum */ OperationType BuyCoin;
    @SerializedName(value="5")
    public static final /* enum */ OperationType CreateCoin;
    @SerializedName(value="6")
    public static final /* enum */ OperationType DeclareCandidacy;
    @SerializedName(value="7")
    public static final /* enum */ OperationType Delegate;
    @SerializedName(value="8")
    public static final /* enum */ OperationType Unbound;
    @SerializedName(value="9")
    public static final /* enum */ OperationType RedeemCheck;
    @SerializedName(value="10")
    public static final /* enum */ OperationType SetCandidateOnline;
    @SerializedName(value="11")
    public static final /* enum */ OperationType SetCandidateOffline;
    @SerializedName(value="12")
    public static final /* enum */ OperationType CreateMultisigAddress;
    @SerializedName(value="13")
    public static final /* enum */ OperationType Multisend;
    @SerializedName(value="14")
    public static final /* enum */ OperationType EditCandidate;
    private static final String FEE_BASE_STRING = "0.001";
    public static final BigDecimal FEE_BASE;
    private static final /* synthetic */ OperationType[] $VALUES;
    final BigInteger mValue;
    Class<? extends Operation> mOpClass;
    BigDecimal mFee;

    public static OperationType[] values() {
        return (OperationType[])$VALUES.clone();
    }

    public static OperationType valueOf(String string) {
        return Enum.valueOf(OperationType.class, string);
    }

    private OperationType(byte by, Class<? extends Operation> clazz, double d) {
        this.mValue = new BigInteger(String.valueOf(by));
        this.mOpClass = clazz;
        this.mFee = this.getFeeBase().multiply(new BigDecimal(String.valueOf(d)));
    }

    @Nullable
    public static OperationType findByValue(BigInteger bigInteger) {
        for (OperationType operationType : OperationType.values()) {
            if (!operationType.mValue.equals(bigInteger)) continue;
            return operationType;
        }
        return null;
    }

    @Nullable
    public static OperationType findByOpClass(Class<? extends Operation> clazz) {
        for (OperationType operationType : OperationType.values()) {
            if (!operationType.getOpClass().equals(clazz)) continue;
            return operationType;
        }
        return null;
    }

    static {
        OperationType operationType;
        SendCoin = new OperationType(1, TxSendCoin.class, 10.0);
        SellCoin = new OperationType(2, TxCoinSell.class, 100.0);
        SellAllCoins = new OperationType(3, TxCoinSellAll.class, 100.0);
        BuyCoin = new OperationType(4, TxCoinBuy.class, 100.0);
        CreateCoin = new OperationType(5, TxCreateCoin.class, 1000.0);
        DeclareCandidacy = new OperationType(6, TxDeclareCandidacy.class, 10000.0);
        Delegate = new OperationType(7, TxDelegate.class, 200.0);
        Unbound = new OperationType(8, TxUnbound.class, 200.0);
        RedeemCheck = new OperationType(9, TxRedeemCheck.class, 30.0);
        SetCandidateOnline = new OperationType(10, TxSetCandidateOnline.class, 100.0);
        SetCandidateOffline = new OperationType(11, TxSetCandidateOffline.class, 100.0);
        CreateMultisigAddress = new OperationType(12, TxCreateMultisigAddress.class, 100.0);
        Multisend = new OperationType(13, TxMultisend.class, 0.0);
        OperationType operationType2 = operationType;
        EditCandidate = new OperationType(14, TxEditCandidate.class, 10000.0);
        $VALUES = new OperationType[]{SendCoin, SellCoin, SellAllCoins, BuyCoin, CreateCoin, DeclareCandidacy, Delegate, Unbound, RedeemCheck, SetCandidateOnline, SetCandidateOffline, CreateMultisigAddress, Multisend, operationType2};
        FEE_BASE = new BigDecimal(FEE_BASE_STRING);
    }

    public BigDecimal getFeeBase() {
        return new BigDecimal(FEE_BASE_STRING);
    }

    public BigDecimal getFee() {
        return this.mFee;
    }

    public Class<? extends Operation> getOpClass() {
        return this.mOpClass;
    }

    public BigInteger getValue() {
        return this.mValue;
    }

    public int getValueInt() {
        return this.mValue.intValue();
    }
}

