/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models;

import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.MinterPublicKey;
import org.parceler.Parcel;

@Parcel
public class HistoryTransaction {
    public BytesData hash;
    @SerializedName(value="raw_tx")
    public BytesData rawTx;
    public Long height;
    public Long index;
    public MinterAddress from;
    public BigInteger nonce;
    public int gas;
    @SerializedName(value="gas_price")
    public int gasPrice;
    @SerializedName(value="gas_coin")
    public String gasCoin;
    public Type type;
    public TxBaseResult data;
    public String payload;
    public Map<String, String> tags;

    @Parcel
    public static class CandidateEditResult {
        @SerializedName(value="reward_address")
        public MinterAddress rewardAddress;
        @SerializedName(value="owner_address")
        public MinterAddress ownerAddress;
        @SerializedName(value="pub_key")
        public MinterPublicKey pubKey;
    }

    @Parcel
    public static class TxEditCandidateResult
    extends TxBaseResult {
        @SerializedName(value="list")
        public List<CandidateEditResult> items;
    }

    @Parcel
    public static class TxMultisendResult
    extends TxBaseResult {
        @SerializedName(value="list")
        public List<TxSendCoinResult> items;
    }

    @Parcel
    public static class TxCreateMultisigResult
    extends TxBaseResult {
        public BigInteger threshold;
        public List<BigInteger> weights;
        public List<MinterAddress> addresses;

        public TxCreateMultisigResult() {
            ArrayList arrayList;
            ArrayList arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList();
            v1.weights = object;
            object = arrayList;
            arrayList = new ArrayList();
            v1.addresses = object;
        }
    }

    @Parcel
    public static class TxRedeemCheckResult
    extends TxBaseResult {
        @SerializedName(value="raw_check")
        public MinterCheck rawCheck;
        public BytesData proof;

        public BytesData getProof() {
            return this.proof;
        }

        public MinterCheck getRawCheck() {
            return this.rawCheck;
        }
    }

    @Parcel
    public static class TxDelegateUnbondResult
    extends TxBaseResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public String coin;
        public String value;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public BigDecimal getValue() {
            String string = this.value;
            if (string == null || string.isEmpty()) {
                this.value = "0";
            }
            return new BigDecimal(this.value);
        }

        @Deprecated
        public BigDecimal getStake() {
            return this.getValue();
        }

        public String getCoin() {
            String string = ((TxDelegateUnbondResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }
    }

    @Parcel
    public static class TxSetCandidateOnlineOfflineResult
    extends TxBaseResult {
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    @Parcel
    public static class TxDeclareCandidacyResult
    extends TxBaseResult {
        public MinterAddress address;
        @SerializedName(value="pub_key")
        public MinterPublicKey publicKey;
        public int commission;
        public String coin;
        public BigInteger stake;

        public MinterAddress getAddress() {
            return this.address;
        }

        public MinterPublicKey getPublicKey() {
            return this.publicKey;
        }

        public int getCommission() {
            return this.commission;
        }

        public String getCoin() {
            String string = ((TxDeclareCandidacyResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getStake() {
            if (this.stake == null) {
                this.stake = BigInteger.ZERO;
            }
            return Transaction.humanizeValue(this.stake);
        }
    }

    @Parcel
    public static class TxConvertCoinResult
    extends TxBaseResult {
        @SerializedName(value="coin_to_sell")
        public String coinToSell;
        @SerializedName(value="coin_to_buy")
        public String coinToBuy;
        @SerializedName(value="value_to_buy")
        public BigInteger valueToBuy;
        @SerializedName(value="value_to_sell")
        public BigInteger valueToSell;
        @SerializedName(value="minimum_value_to_buy")
        public BigInteger minValueToBuy;
        @SerializedName(value="maximum_value_to_sell")
        public BigInteger maxValueToSell;

        public String getCoinToSell() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToSell;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public String getCoinToBuy() {
            String string = ((TxConvertCoinResult)((Object)string)).coinToBuy;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getValueToBuy() {
            if (this.valueToBuy == null) {
                this.valueToBuy = BigInteger.ZERO;
            }
            return Transaction.humanizeValue(this.valueToBuy);
        }

        public BigDecimal getValueToSell() {
            if (this.valueToSell == null) {
                this.valueToSell = BigInteger.ZERO;
            }
            return Transaction.humanizeValue(this.valueToSell);
        }
    }

    @Parcel
    public static class TxCreateResult
    extends TxBaseResult {
        public String name;
        public String symbol;
        @SerializedName(value="initial_amount")
        public BigInteger initialAmount;
        @SerializedName(value="initial_reserve")
        public BigInteger initialReserve;
        @SerializedName(value="constant_reserve_ratio")
        public BigDecimal constantReserveRatio;

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            String string = ((TxCreateResult)((Object)string)).symbol;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getInitialAmount() {
            return Transaction.humanizeValue(this.initialAmount);
        }

        public BigDecimal getInitialReserve() {
            return Transaction.humanizeValue(this.initialReserve);
        }

        public BigDecimal getConstantReserveRatio() {
            return this.constantReserveRatio;
        }
    }

    @Parcel
    public static class TxSendCoinResult
    extends TxBaseResult {
        public MinterAddress to;
        public String coin;
        @SerializedName(value="value")
        public BigInteger amount;

        public MinterAddress getTo() {
            return this.to;
        }

        public String getCoin() {
            String string = ((TxSendCoinResult)((Object)string)).coin;
            if (string == null) {
                return null;
            }
            return string.toUpperCase();
        }

        public BigDecimal getAmount() {
            return Transaction.humanizeValue(this.amount);
        }
    }

    @Parcel
    public static class TxBaseResult {
    }

    public static final class Type
    extends Enum<Type> {
        @SerializedName(value="1")
        public static final /* enum */ Type Send;
        @SerializedName(value="2")
        public static final /* enum */ Type SellCoin;
        @SerializedName(value="3")
        public static final /* enum */ Type SellAllCoins;
        @SerializedName(value="4")
        public static final /* enum */ Type BuyCoin;
        @SerializedName(value="5")
        public static final /* enum */ Type CreateCoin;
        @SerializedName(value="6")
        public static final /* enum */ Type DeclareCandidacy;
        @SerializedName(value="7")
        public static final /* enum */ Type Delegate;
        @SerializedName(value="8")
        public static final /* enum */ Type Unbond;
        @SerializedName(value="9")
        public static final /* enum */ Type RedeemCheck;
        @SerializedName(value="10")
        public static final /* enum */ Type SetCandidateOnline;
        @SerializedName(value="11")
        public static final /* enum */ Type SetCandidateOffline;
        @SerializedName(value="12")
        public static final /* enum */ Type CreateMultisig;
        @SerializedName(value="13")
        public static final /* enum */ Type Multisend;
        @SerializedName(value="14")
        public static final /* enum */ Type EditCandidate;
        private static final /* synthetic */ Type[] $VALUES;
        Class<? extends TxBaseResult> mCls;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        private Type(Class<? extends TxBaseResult> clazz) {
            this.mCls = clazz;
        }

        static {
            Type type;
            Send = new Type(TxSendCoinResult.class);
            SellCoin = new Type(TxConvertCoinResult.class);
            SellAllCoins = new Type(TxConvertCoinResult.class);
            BuyCoin = new Type(TxConvertCoinResult.class);
            CreateCoin = new Type(TxCreateResult.class);
            DeclareCandidacy = new Type(TxDeclareCandidacyResult.class);
            Delegate = new Type(TxDelegateUnbondResult.class);
            Unbond = new Type(TxDelegateUnbondResult.class);
            RedeemCheck = new Type(TxRedeemCheckResult.class);
            SetCandidateOnline = new Type(TxSetCandidateOnlineOfflineResult.class);
            SetCandidateOffline = new Type(TxSetCandidateOnlineOfflineResult.class);
            CreateMultisig = new Type(TxCreateMultisigResult.class);
            Multisend = new Type(TxMultisendResult.class);
            Type type2 = type;
            EditCandidate = new Type(TxEditCandidateResult.class);
            $VALUES = new Type[]{Send, SellCoin, SellAllCoins, BuyCoin, CreateCoin, DeclareCandidacy, Delegate, Unbond, RedeemCheck, SetCandidateOnline, SetCandidateOffline, CreateMultisig, Multisend, type2};
        }

        public Class<? extends TxBaseResult> getOpClass() {
            return this.mCls;
        }
    }
}

