/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.repo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.HashMap;
import javax.annotation.Nonnull;
import network.minter.blockchain.api.BlockChainAccountEndpoint;
import network.minter.blockchain.models.BCResult;
import network.minter.blockchain.models.Balance;
import network.minter.blockchain.models.TransactionSendResult;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.data.DataRepository;
import retrofit2.Call;

public class BlockChainAccountRepository
extends DataRepository<BlockChainAccountEndpoint> {
    public BlockChainAccountRepository(@Nonnull ApiService.Builder builder) {
        super(builder);
    }

    public Call<BCResult<Balance>> getBalance(@Nonnull MinterAddress minterAddress) {
        MinterAddress minterAddress2 = minterAddress;
        Preconditions.checkNotNull((Object)minterAddress2, (String)"Public key required!");
        return this.getBalance(minterAddress2.toString());
    }

    public Call<BCResult<Balance>> getBalance(@Nonnull String string) {
        return ((BlockChainAccountEndpoint)this.getInstantService(object -> {
            CoinBalanceDeserializer coinBalanceDeserializer;
            ApiService.Builder builder = object;
            object = coinBalanceDeserializer;
            coinBalanceDeserializer = new CoinBalanceDeserializer();
            builder.registerTypeAdapter(Balance.class, object);
        })).getBalance((String)Preconditions.checkNotNull((Object)string, (String)"Address required!"));
    }

    public Call<BCResult<TransactionSendResult>> sendTransaction(@Nonnull TransactionSign transactionSign) {
        String string = transactionSign.getTxSign();
        if (!string.startsWith("0x")) {
            string = "0x" + string;
        }
        transactionSign.clear();
        return ((BlockChainAccountEndpoint)this.getInstantService()).sendTransaction(string);
    }

    @Nonnull
    protected Class<BlockChainAccountEndpoint> getServiceClass() {
        return BlockChainAccountEndpoint.class;
    }

    public static class CoinBalanceDeserializer
    implements JsonDeserializer<Balance> {
        public Balance deserialize(JsonElement jsonElement, Type object, JsonDeserializationContext object2) throws JsonParseException {
            HashMap hashMap;
            Balance balance;
            if (jsonElement.isJsonNull()) {
                return null;
            }
            Balance balance2 = balance;
            JsonElement jsonElement2 = jsonElement;
            balance2();
            jsonElement = jsonElement2.getAsJsonObject().get("balance").getAsJsonObject();
            balance.txCount = jsonElement2.getAsJsonObject().get("transaction_count").getAsBigInteger();
            object = hashMap;
            hashMap = new HashMap();
            object2 = jsonElement.keySet().iterator();
            while (object2.hasNext()) {
                String string = ((String)object2.next()).toUpperCase();
                new Balance.CoinBalance().balance = new BigInteger(jsonElement.get(string).getAsString());
                new Balance.CoinBalance().coin = string;
                object.put(string, new Balance.CoinBalance());
            }
            balance2.coins = object;
            return balance2;
        }
    }
}

