/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain;

import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.repo.BlockChainAccountRepository;
import network.minter.blockchain.repo.BlockChainBlockRepository;
import network.minter.blockchain.repo.BlockChainCandidateRepository;
import network.minter.blockchain.repo.BlockChainCoinRepository;
import network.minter.blockchain.repo.BlockChainEventRepository;
import network.minter.blockchain.repo.BlockChainStatusRepository;
import network.minter.blockchain.repo.BlockChainTransactionRepository;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.crypto.MinterPublicKey;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerJsonConverter;
import network.minter.core.internal.api.converters.BytesDataJsonConverter;
import network.minter.core.internal.api.converters.MinterAddressJsonConverter;
import network.minter.core.internal.api.converters.MinterHashJsonConverter;
import network.minter.core.internal.api.converters.MinterPublicKeyJsonConverter;
import network.minter.core.internal.log.Mint;
import network.minter.core.internal.log.TimberLogger;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterBlockChainApi {
    private static final String BASE_NODE_URL = "http://138.197.222.87:8841";
    private static MinterBlockChainApi INSTANCE;
    private final ApiService.Builder mApiService;
    private BlockChainAccountRepository mAccountRepository;
    private BlockChainCoinRepository mCoinRepository;
    private BlockChainTransactionRepository mTransactionRepository;
    private BlockChainBlockRepository mBlockRepository;
    private BlockChainCandidateRepository mBlockChainCandidateRepository;
    private BlockChainStatusRepository mStatusRepository;
    private BlockChainEventRepository mEventRepository;

    private MinterBlockChainApi() {
        this(BASE_NODE_URL);
    }

    private MinterBlockChainApi(@Nonnull String string) {
        MinterBlockChainApi minterBlockChainApi = this;
        minterBlockChainApi.mApiService = new ApiService.Builder(string, this.getGsonBuilder());
        minterBlockChainApi.mApiService.addHeader("Content-Type", "application/json");
        minterBlockChainApi.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid");
        minterBlockChainApi.mApiService.addHeader("X-Minter-Client-Version", "0.11.0");
    }

    public static void initialize() {
        TimberLogger timberLogger;
        TimberLogger timberLogger2 = timberLogger;
        timberLogger = new TimberLogger();
        MinterBlockChainApi.initialize(BASE_NODE_URL, false, (Mint.Leaf)timberLogger2);
    }

    public static MinterBlockChainApi createInstance(String string, boolean bl, Mint.Leaf object) {
        MinterBlockChainApi minterBlockChainApi;
        if (bl) {
            Mint.brew((Mint.Leaf)object);
        }
        object = minterBlockChainApi;
        new MinterBlockChainApi((String)string).mApiService.setDebug(bl);
        if (bl) {
            object.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
        return object;
    }

    public static void initialize(String string, boolean bl, Mint.Leaf leaf) {
        if (INSTANCE != null) {
            return;
        }
        if (bl) {
            Mint.brew((Mint.Leaf)leaf);
        }
        INSTANCE = new MinterBlockChainApi(string);
        MinterBlockChainApi.INSTANCE.mApiService.setDebug(bl);
        if (bl) {
            MinterBlockChainApi.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static void initialize(boolean bl) {
        TimberLogger timberLogger;
        TimberLogger timberLogger2 = timberLogger;
        timberLogger = new TimberLogger();
        MinterBlockChainApi.initialize(BASE_NODE_URL, bl, (Mint.Leaf)timberLogger2);
    }

    public static void initialize(String string) {
        TimberLogger timberLogger;
        String string2 = string;
        string = timberLogger;
        timberLogger = new TimberLogger();
        MinterBlockChainApi.initialize(string2, false, (Mint.Leaf)string);
    }

    public static MinterBlockChainApi getInstance() {
        MinterBlockChainApi minterBlockChainApi = INSTANCE;
        if (minterBlockChainApi != null) {
            return minterBlockChainApi;
        }
        throw new IllegalStateException("You forget to call MinterBlockchainApi.initialize");
    }

    public ApiService.Builder getApiService() {
        return this.mApiService;
    }

    public GsonBuilder getGsonBuilder() {
        MinterPublicKeyJsonConverter minterPublicKeyJsonConverter;
        BytesDataJsonConverter bytesDataJsonConverter;
        BigIntegerJsonConverter bigIntegerJsonConverter;
        MinterHashJsonConverter minterHashJsonConverter;
        MinterAddressJsonConverter minterAddressJsonConverter;
        GsonBuilder gsonBuilder = new GsonBuilder();
        MinterBlockChainApi minterBlockChainApi = minterAddressJsonConverter;
        minterAddressJsonConverter = new MinterAddressJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterAddress.class, (Object)minterBlockChainApi);
        minterBlockChainApi = minterHashJsonConverter;
        minterHashJsonConverter = new MinterHashJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterHash.class, (Object)minterBlockChainApi);
        minterBlockChainApi = bigIntegerJsonConverter;
        bigIntegerJsonConverter = new BigIntegerJsonConverter();
        gsonBuilder.registerTypeAdapter(BigInteger.class, (Object)minterBlockChainApi);
        minterBlockChainApi = bytesDataJsonConverter;
        bytesDataJsonConverter = new BytesDataJsonConverter();
        gsonBuilder.registerTypeAdapter(BytesData.class, (Object)minterBlockChainApi);
        minterBlockChainApi = minterPublicKeyJsonConverter;
        minterPublicKeyJsonConverter = new MinterPublicKeyJsonConverter();
        gsonBuilder.registerTypeAdapter(MinterPublicKey.class, (Object)minterBlockChainApi);
        return gsonBuilder;
    }

    public BlockChainEventRepository event() {
        if (this.mEventRepository == null) {
            this.mEventRepository = new BlockChainEventRepository(this.mApiService);
        }
        return this.mEventRepository;
    }

    public BlockChainStatusRepository status() {
        if (this.mStatusRepository == null) {
            this.mStatusRepository = new BlockChainStatusRepository(this.mApiService);
        }
        return this.mStatusRepository;
    }

    public BlockChainCandidateRepository candidate() {
        if (this.mBlockChainCandidateRepository == null) {
            this.mBlockChainCandidateRepository = new BlockChainCandidateRepository(this.mApiService);
        }
        return this.mBlockChainCandidateRepository;
    }

    public BlockChainBlockRepository block() {
        if (this.mBlockRepository == null) {
            this.mBlockRepository = new BlockChainBlockRepository(this.mApiService);
        }
        return this.mBlockRepository;
    }

    public BlockChainAccountRepository account() {
        if (this.mAccountRepository == null) {
            this.mAccountRepository = new BlockChainAccountRepository(this.mApiService);
        }
        return this.mAccountRepository;
    }

    public BlockChainTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new BlockChainTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public BlockChainCoinRepository coin() {
        if (this.mCoinRepository == null) {
            this.mCoinRepository = new BlockChainCoinRepository(this.mApiService);
        }
        return this.mCoinRepository;
    }
}

