/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import com.edwardstock.secp256k1.NativeSecp256k1;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import network.minter.blockchain.BuildConfig;
import network.minter.blockchain.models.operational.BlockchainID;
import network.minter.blockchain.models.operational.InvalidEncodedTransactionException;
import network.minter.blockchain.models.operational.SignatureSingleData;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.HashUtil;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterCheck;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.crypto.UnsignedBytesData;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.RLP;
import network.minter.core.util.RLPBoxed;

public class CheckTransaction {
    private String mPassphrase;
    private UnsignedBytesData mNonce;
    private BlockchainID mChainId;
    private BigInteger mDueBlock;
    private String mCoin = "MNT";
    private BigInteger mValue;
    private UnsignedBytesData mLock;
    private SignatureSingleData mSignature;

    CheckTransaction(UnsignedBytesData unsignedBytesData, String string) {
        this.mNonce = unsignedBytesData;
        this.mPassphrase = string;
    }

    CheckTransaction() {
    }

    public static UnsignedBytesData makeProof(String string, String string2) {
        return CheckTransaction.makeProof(new MinterAddress((CharSequence)string), string2);
    }

    public static UnsignedBytesData makeProof(MinterAddress minterAddress, String object) {
        NativeSecp256k1.RecoverableSignature recoverableSignature;
        BytesData bytesData;
        BytesData bytesData2 = bytesData;
        bytesData = new BytesData(HashUtil.sha256((byte[])((String)object).getBytes()));
        minterAddress = new BytesData(RLP.encode((Object)new Object[]{minterAddress.getData()})).sha3Mutable();
        long l = NativeSecp256k1.contextCreate();
        try {
            minterAddress = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])minterAddress.getData(), (byte[])bytesData2.getData());
            recoverableSignature = minterAddress;
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l);
        object = recoverableSignature.v;
        int n = 0;
        boolean bl = recoverableSignature.v[0] != 27;
        object[n] = bl;
        byte[][] byArrayArray = new byte[3][];
        object = byArrayArray;
        object[0] = minterAddress.r;
        object[1] = minterAddress.s;
        byArrayArray[2] = minterAddress.v;
        return new UnsignedBytesData((byte[][])byArrayArray);
    }

    public static CheckTransaction fromEncoded(@Nonnull MinterCheck minterCheck) {
        return CheckTransaction.fromEncoded(minterCheck.toString());
    }

    public static CheckTransaction fromEncoded(@Nonnull String objectArray) {
        Preconditions.checkNotNull((Object)objectArray, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((objectArray.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        objectArray = (Object[])RLPBoxed.decode((char[])new UnsignedBytesData((BytesData)new MinterCheck((CharSequence)objectArray)).getData(), (int)0).getDecoded();
        if (objectArray.length == 9) {
            CheckTransaction checkTransaction = new CheckTransaction();
            checkTransaction.decodeRLP(objectArray);
            return checkTransaction;
        }
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = objectArray.length;
        throw new InvalidEncodedTransactionException("Encoded transaction has invalid data length: expected 9, given %d", objectArray3);
    }

    private void decodeRLP(Object[] objectArray) {
        CheckTransaction checkTransaction;
        ((CheckTransaction)object).mNonce = new UnsignedBytesData((char[])objectArray[0]);
        ((CheckTransaction)object).mChainId = BlockchainID.valueOf(BytesHelper.fixBigintSignedByte((char[])((CheckTransaction)object).fromRawRlp(1, objectArray)));
        ((CheckTransaction)object).mDueBlock = BytesHelper.fixBigintSignedByte((Object)objectArray[2]);
        ((CheckTransaction)object).mCoin = StringHelper.charsToStringSafe((char[])((CheckTransaction)object).fromRawRlp(3, objectArray), (int)10);
        ((CheckTransaction)object).mValue = BytesHelper.fixBigintSignedByte((Object)objectArray[4]);
        ((CheckTransaction)object).mLock = new UnsignedBytesData((char[])objectArray[5]);
        ((CheckTransaction)object).mSignature = new SignatureSingleData();
        char[][] cArrayArray = new char[3][];
        Object object = cArrayArray;
        object[0] = (char[])objectArray[6];
        object[1] = (char[])objectArray[7];
        cArrayArray[2] = (char[])objectArray[8];
        checkTransaction.mSignature.decodeRaw((char[][])object);
    }

    private char[] encode(boolean bl) {
        if (bl) {
            Object[] objectArray = new Object[5];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.mNonce;
            objectArray2[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray2[2] = this.mDueBlock;
            objectArray2[3] = this.mCoin;
            objectArray[4] = this.mValue;
            return RLPBoxed.encode((Object)objectArray);
        }
        CheckTransaction checkTransaction = this;
        char[] cArray = checkTransaction.mLock.getData();
        Object[] objectArray = checkTransaction.mSignature;
        if (checkTransaction.mSignature != null && objectArray.getV() != null && this.mSignature.getR() != null && this.mSignature.getS() != null) {
            Object[] objectArray3 = new Object[9];
            objectArray = objectArray3;
            objectArray[0] = this.mNonce;
            objectArray[1] = BigInteger.valueOf(this.mChainId.getId());
            objectArray[2] = this.mDueBlock;
            objectArray[3] = this.mCoin;
            objectArray[4] = this.mValue;
            objectArray[5] = cArray;
            objectArray[6] = this.mSignature.getV().getData();
            objectArray[7] = this.mSignature.getR().getData();
            objectArray3[8] = this.mSignature.getS().getData();
            return RLPBoxed.encode((Object)objectArray3);
        }
        Object[] objectArray4 = new Object[6];
        objectArray = objectArray4;
        objectArray[0] = this.mNonce;
        objectArray[1] = BigInteger.valueOf(this.mChainId.getId());
        objectArray[2] = this.mDueBlock;
        objectArray[3] = this.mCoin;
        objectArray4[4] = this.mValue;
        objectArray4[5] = cArray;
        return RLPBoxed.encode((Object)objectArray4);
    }

    static /* synthetic */ BlockchainID access$002(CheckTransaction checkTransaction, BlockchainID blockchainID) {
        checkTransaction.mChainId = blockchainID;
        return blockchainID;
    }

    static /* synthetic */ String access$102(CheckTransaction checkTransaction, String string) {
        checkTransaction.mCoin = string;
        return string;
    }

    static /* synthetic */ BigInteger access$202(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mValue = bigInteger;
        return bigInteger;
    }

    static /* synthetic */ BigInteger access$302(CheckTransaction checkTransaction, BigInteger bigInteger) {
        checkTransaction.mDueBlock = bigInteger;
        return bigInteger;
    }

    public void cleanup() {
        CheckTransaction checkTransaction = this;
        checkTransaction.mPassphrase = null;
        checkTransaction.mNonce = null;
        checkTransaction.mDueBlock = null;
        checkTransaction.mCoin = null;
        checkTransaction.mValue = null;
        checkTransaction.mLock = null;
        checkTransaction.mSignature = null;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public UnsignedBytesData getNonce() {
        return this.mNonce;
    }

    public BlockchainID getChainId() {
        return this.mChainId;
    }

    public BigInteger getDueBlock() {
        return this.mDueBlock;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public BigDecimal getValue() {
        return new BigDecimal(this.mValue).divide(Transaction.VALUE_MUL_DEC);
    }

    public SignatureSingleData getSignature() {
        return this.mSignature;
    }

    public TransactionSign sign(PrivateKey privateKey) {
        NativeSecp256k1.RecoverableSignature recoverableSignature;
        UnsignedBytesData unsignedBytesData = new UnsignedBytesData(((CheckTransaction)((Object)string)).encode(true)).sha3Data();
        Object object = new UnsignedBytesData(((CheckTransaction)((Object)string)).mPassphrase.getBytes()).sha256Mutable();
        long l = NativeSecp256k1.contextCreate();
        try {
            unsignedBytesData = NativeSecp256k1.signRecoverableSerialized((long)l, (byte[])unsignedBytesData.getBytes(), (byte[])object.getBytes());
            recoverableSignature = unsignedBytesData;
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l);
        object = recoverableSignature.v;
        int n = 0;
        boolean bl = recoverableSignature.v[0] != 27;
        object[n] = (UnsignedBytesData)bl;
        byte[][] byArrayArray = new byte[3][];
        object = byArrayArray;
        object[0] = (UnsignedBytesData)unsignedBytesData.r;
        object[1] = (UnsignedBytesData)unsignedBytesData.s;
        byArrayArray[2] = unsignedBytesData.v;
        ((CheckTransaction)((Object)string)).mLock = new UnsignedBytesData((byte[][])byArrayArray);
        unsignedBytesData = new UnsignedBytesData(((CheckTransaction)((Object)string)).encode(false)).sha3Mutable();
        long l2 = NativeSecp256k1.contextCreate();
        try {
            privateKey = NativeSecp256k1.signRecoverableSerialized((long)l2, (byte[])unsignedBytesData.getBytes(), (byte[])privateKey.getData());
        }
        catch (Throwable throwable) {
            NativeSecp256k1.contextCleanup((long)l2);
            throw throwable;
        }
        NativeSecp256k1.contextCleanup((long)l2);
        ((CheckTransaction)((Object)string)).mSignature = new SignatureSingleData();
        ((CheckTransaction)((Object)string)).mSignature.setSign((NativeSecp256k1.RecoverableSignature)privateKey);
        String string = new BytesData(((CheckTransaction)((Object)string)).encode(false)).toHexString("Mc");
        return new TransactionSign(string);
    }

    public UnsignedBytesData getLock() {
        return this.mLock;
    }

    char[] fromRawRlp(int n, Object[] objectArray) {
        if (objectArray[n] instanceof String) {
            return ((String)objectArray[n]).toCharArray();
        }
        return (char[])objectArray[n];
    }

    public static final class Builder {
        private CheckTransaction mCheck;

        public Builder(BigInteger bigInteger, String string) {
            this(new UnsignedBytesData(bigInteger.toString(10).getBytes()), string);
        }

        public Builder(CharSequence charSequence, String string) {
            this(new UnsignedBytesData(charSequence.toString().getBytes()), string);
        }

        public Builder(UnsignedBytesData unsignedBytesData, String string) {
            Builder builder = this;
            builder.mCheck = new CheckTransaction(unsignedBytesData, string);
            CheckTransaction.access$002(builder.mCheck, BuildConfig.BLOCKCHAIN_ID);
        }

        public Builder setChainId(BlockchainID blockchainID) {
            Builder builder = this;
            CheckTransaction.access$002(builder.mCheck, blockchainID);
            return builder;
        }

        public Builder setCoin(String string) {
            boolean bl = string != null && string.length() >= 3 && string.length() <= 10;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            Preconditions.checkArgument((boolean)bl, (Object)String.format("Invalid coin passed: %s", objectArray2));
            CheckTransaction.access$102(objectArray2.mCheck, StringHelper.strrpad((int)10, (String)string));
            return objectArray2;
        }

        public Builder setValue(BigDecimal bigDecimal) {
            Builder builder = this;
            CheckTransaction.access$202(builder.mCheck, bigDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger());
            return builder;
        }

        public Builder setValue(CharSequence charSequence) {
            return this.setValue(new BigDecimal(charSequence.toString()));
        }

        public Builder setDueBlock(BigInteger bigInteger) {
            Builder builder = this;
            CheckTransaction.access$302(builder.mCheck, bigInteger);
            return builder;
        }

        public CheckTransaction build() {
            Builder builder = this;
            Preconditions.checkNotNull((Object)builder.mCheck.mValue, (String)"Value must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mDueBlock, (String)"Due block must be set");
            Preconditions.checkNotNull((Object)builder.mCheck.mNonce, (String)"Nonce required");
            Preconditions.checkNotNull((Object)builder.mCheck.mPassphrase, (String)"Passphrase required");
            return builder.mCheck;
        }
    }
}

