/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.PublicKey;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxDelegate
extends Operation {
    public static final Parcelable.Creator<TxDelegate> CREATOR = new Parcelable.Creator<TxDelegate>(){

        public TxDelegate createFromParcel(Parcel in) {
            return new TxDelegate(in);
        }

        public TxDelegate[] newArray(int size) {
            return new TxDelegate[size];
        }
    };
    private PublicKey mPubKey;
    private String mCoin;
    private BigInteger mStake;

    public TxDelegate(Transaction rawTx) {
        super(rawTx);
    }

    protected TxDelegate(Parcel in) {
        super(in);
        this.mPubKey = (PublicKey)in.readValue(PublicKey.class.getClassLoader());
        this.mCoin = in.readString();
        this.mStake = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mPubKey);
        dest.writeString(this.mCoin);
        dest.writeValue((Object)this.mStake);
    }

    public PublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxDelegate setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    public TxDelegate setPublicKey(String hexPubKey) {
        this.mPubKey = new PublicKey((CharSequence)hexPubKey);
        return this;
    }

    public TxDelegate setPublicKey(byte[] publicKey) {
        this.mPubKey = new PublicKey(publicKey);
        return this;
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxDelegate setCoin(String coinName) {
        this.mCoin = StringHelper.strrpad((int)10, (String)coinName.toUpperCase());
        return this;
    }

    public BigInteger getStakeBigInteger() {
        return this.mStake;
    }

    public BigDecimal getStake() {
        return new BigDecimal(this.mStake).divide(Transaction.VALUE_MUL_DEC);
    }

    public TxDelegate setStake(BigInteger stakeBigInteger) {
        this.mStake = stakeBigInteger;
        return this;
    }

    public double getStakeDouble() {
        return this.getStake().doubleValue();
    }

    public TxDelegate setStake(double stake) {
        return this.setStake(new BigDecimal(stake));
    }

    public TxDelegate setStake(String stakeBigInteger) {
        this.mStake = new BigInteger(stakeBigInteger);
        return this;
    }

    public TxDelegate setStake(BigDecimal stakeDecimal) {
        this.mStake = stakeDecimal.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.Delegate;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mPubKey", this.mPubKey != null, "Node public key must be set").addResult("mCoin", this.mCoin != null && this.mCoin.length() > 2 && this.mCoin.length() < 11, "Coin symbol length must be from 3 to 10 chars").addResult("mStake", this.mStake != null && this.mStake.compareTo(new BigInteger("0")) > 0, "Stake must be set (more than 0)");
    }

    @Override
    @NonNull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mPubKey.getData(), this.mCoin, this.mStake});
    }

    @Override
    protected void decodeRLP(@NonNull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mPubKey = new PublicKey(this.fromRawRlp(0, decoded));
        this.mCoin = StringHelper.bytesToString((byte[])this.fromRawRlp(1, decoded));
        this.mStake = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(2, decoded));
    }
}

