/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.edwardstock.secp256k1.NativeSecp256k1;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.TransactionSign;
import network.minter.blockchain.models.operational.TxCoinBuy;
import network.minter.blockchain.models.operational.TxCoinSell;
import network.minter.blockchain.models.operational.TxCoinSellAll;
import network.minter.blockchain.models.operational.TxCreateCoin;
import network.minter.blockchain.models.operational.TxDeclareCandidacy;
import network.minter.blockchain.models.operational.TxDelegate;
import network.minter.blockchain.models.operational.TxRedeemCheck;
import network.minter.blockchain.models.operational.TxSendCoin;
import network.minter.blockchain.models.operational.TxSetCandidateOffline;
import network.minter.blockchain.models.operational.TxSetCandidateOnline;
import network.minter.blockchain.models.operational.TxUnbound;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.PrivateKey;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;
import timber.log.Timber;

public class Transaction
implements Parcelable {
    public static final BigInteger VALUE_MUL = new BigInteger("1000000000000000000", 10);
    public static final BigDecimal VALUE_MUL_DEC = new BigDecimal("1000000000000000000");
    public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

        public Transaction createFromParcel(Parcel in) {
            return new Transaction(in);
        }

        public Transaction[] newArray(int size) {
            return new Transaction[size];
        }
    };
    private BigInteger mNonce = new BigInteger("2");
    private BigInteger mGasPrice = new BigInteger("1");
    private String mGasCoin = "MNT";
    private OperationType mType = OperationType.SendCoin;
    private Operation mOperationData;
    private BigInteger mV = new BigInteger("1");
    private BigInteger mR = new BigInteger("0");
    private BigInteger mS = new BigInteger("0");
    private BytesData mPayload = new BytesData(new byte[0]);
    private BytesData mServiceData = new BytesData(new byte[0]);

    protected Transaction(BigInteger nonce) {
        this.mNonce = nonce;
    }

    protected Transaction() {
    }

    protected Transaction(Parcel in) {
        this.mNonce = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mGasPrice = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mGasCoin = in.readString();
        this.mType = (OperationType)((Object)in.readValue(OperationType.class.getClassLoader()));
        this.mOperationData = (Operation)in.readValue(Operation.class.getClassLoader());
        this.mV = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mR = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mS = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
        this.mPayload = (BytesData)in.readValue(BytesData.class.getClassLoader());
        this.mServiceData = (BytesData)in.readValue(BytesData.class.getClassLoader());
    }

    public static <Op extends Operation> Transaction fromEncoded(@NonNull String hexEncoded, @NonNull Class<Op> type) {
        Preconditions.checkNotNull(type, (String)"Class of transaction type must be set");
        Preconditions.checkNotNull((Object)hexEncoded, (String)"hexEncoded data can't be null");
        Preconditions.checkArgument((hexEncoded.length() > 0 ? 1 : 0) != 0, (Object)"Encoded transaction is empty");
        BytesData bd = new BytesData((CharSequence)hexEncoded);
        DecodeResult rlp = RLP.decode((byte[])bd.getData(), (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        Transaction transaction = new Transaction();
        transaction.decodeRLP(decoded);
        Preconditions.checkArgument((boolean)transaction.mType.getOpClass().equals(type), (String)"Passed transaction class does not matches with incoming data transaction type. Given: %s, expected: %s", (Object[])new Object[]{type.getName(), transaction.mType.getOpClass().getName()});
        ReflectiveOperationException t = null;
        try {
            transaction.mOperationData = transaction.mType.getOpClass().getDeclaredConstructor(Transaction.class).newInstance(transaction);
            transaction.mOperationData.decodeRLP(transaction.fromRawRlp(4, decoded));
        }
        catch (InstantiationException e) {
            t = e;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        catch (NoSuchMethodException e) {
            t = e;
        }
        catch (InvocationTargetException e) {
            t = e;
        }
        if (t != null) {
            Timber.e((Throwable)t, (String)"Unable to decode transaction", (Object[])new Object[0]);
            return null;
        }
        return transaction;
    }

    public BigInteger getNonce() {
        return this.mNonce;
    }

    public BigInteger getGasPrice() {
        return this.mGasPrice;
    }

    public OperationType getType() {
        return this.mType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionSign sign(@NonNull PrivateKey privateKey) {
        NativeSecp256k1.RecoverableSignature signature;
        BytesData rawTxData = new BytesData(this.encode(true));
        BytesData hash = rawTxData.sha3Data();
        long ctx = NativeSecp256k1.contextCreate();
        try {
            signature = NativeSecp256k1.signRecoverableSerialized((long)ctx, (byte[])hash.getData(), (byte[])privateKey.getData());
        }
        finally {
            NativeSecp256k1.contextCleanup((long)ctx);
        }
        if (signature == null) {
            return null;
        }
        this.mV = new BigInteger(signature.v);
        this.mR = new BigInteger(signature.r);
        this.mS = new BigInteger(signature.s);
        return new TransactionSign(new BytesData(this.encode(false)).toHexString());
    }

    public <Op extends Operation> Op getData() {
        return (Op)this.mOperationData;
    }

    <Op extends Operation> Transaction setData(Op operationData) {
        this.mOperationData = operationData;
        this.mType = operationData.getType();
        return this;
    }

    public String getGasCoin() {
        return this.mGasCoin.replace("\u0000", "");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.mNonce);
        dest.writeValue((Object)this.mGasPrice);
        dest.writeString(this.mGasCoin);
        dest.writeValue((Object)this.mType);
        dest.writeValue((Object)this.mOperationData);
        dest.writeValue((Object)this.mV);
        dest.writeValue((Object)this.mR);
        dest.writeValue((Object)this.mS);
        dest.writeValue((Object)this.mPayload);
        dest.writeValue((Object)this.mServiceData);
    }

    byte[] fromRawRlp(int idx, Object[] raw) {
        if (raw[idx] instanceof String) {
            return ((String)raw[idx]).getBytes();
        }
        return (byte[])raw[idx];
    }

    void decodeRLP(Object[] raw) {
        this.mNonce = new BigInteger(this.fromRawRlp(0, raw));
        this.mGasPrice = new BigInteger(this.fromRawRlp(1, raw));
        this.mGasCoin = StringHelper.bytesToString((byte[])this.fromRawRlp(2, raw), (int)10);
        this.mType = OperationType.findByValue(new BigInteger(this.fromRawRlp(3, raw)));
        this.mPayload = new BytesData(this.fromRawRlp(5, raw));
        this.mServiceData = new BytesData(this.fromRawRlp(6, raw));
        this.mV = new BigInteger(this.fromRawRlp(7, raw));
        this.mR = new BigInteger(this.fromRawRlp(8, raw));
        this.mS = new BigInteger(this.fromRawRlp(9, raw));
    }

    byte[] encode(boolean forSignature) {
        byte[] data = this.mOperationData.encodeRLP();
        if (forSignature) {
            return RLP.encode((Object)new Object[]{this.mNonce, this.mGasPrice, this.mGasCoin, this.mOperationData.getType().getValue(), data, this.mPayload.getData(), this.mServiceData.getData()});
        }
        return RLP.encode((Object)new Object[]{this.mNonce, this.mGasPrice, this.mGasCoin, this.mOperationData.getType().getValue(), data, this.mPayload.getData(), this.mServiceData.getData(), this.mV, this.mR, this.mS});
    }

    FieldsValidationResult validate() {
        return new FieldsValidationResult("Invalid transaction data").addResult("nonce", this.mNonce != null, "Nonce must be set").addResult("gasPrice", this.mGasCoin != null, "Gas coin must be set").addResult("operationData", this.mOperationData != null, "Operation data does not set! Check your operation model.");
    }

    public static class Builder {
        private final Transaction mTx;

        public Builder(BigInteger nonce) {
            this.mTx = new Transaction(nonce);
        }

        public Builder setGasCoin(String coin) {
            this.mTx.mGasCoin = StringHelper.strrpad((int)10, (String)coin);
            return this;
        }

        public Builder setNonce(BigInteger nonce) {
            this.mTx.mNonce = nonce;
            return this;
        }

        public <Op extends Operation> Op create(Class<Op> operationClass) {
            try {
                return (Op)((Operation)operationClass.getDeclaredConstructor(Transaction.class).newInstance(this.mTx));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public TxCoinBuy buyCoin() {
            return new TxCoinBuy(this.mTx);
        }

        public TxCoinSell sellCoin() {
            return new TxCoinSell(this.mTx);
        }

        public TxCoinSellAll sellAllCoins() {
            return new TxCoinSellAll(this.mTx);
        }

        public TxCreateCoin createCoin() {
            return new TxCreateCoin(this.mTx);
        }

        public TxDeclareCandidacy declareCandidacy() {
            return new TxDeclareCandidacy(this.mTx);
        }

        public TxDelegate delegate() {
            return new TxDelegate(this.mTx);
        }

        public TxRedeemCheck redeemCheck() {
            return new TxRedeemCheck(this.mTx);
        }

        public TxSendCoin sendCoin() {
            return new TxSendCoin(this.mTx);
        }

        public TxSetCandidateOffline setCandidateOffline() {
            return new TxSetCandidateOffline(this.mTx);
        }

        public TxSetCandidateOnline setCandidateOnline() {
            return new TxSetCandidateOnline(this.mTx);
        }

        public TxUnbound unbound() {
            return new TxUnbound(this.mTx);
        }
    }
}

