/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.internal.common.Preconditions;
import network.minter.core.internal.helpers.BytesHelper;
import network.minter.core.internal.helpers.StringHelper;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxSendCoin
extends Operation {
    public static final Parcelable.Creator<TxSendCoin> CREATOR = new Parcelable.Creator<TxSendCoin>(){

        public TxSendCoin createFromParcel(Parcel in) {
            return new TxSendCoin(in);
        }

        public TxSendCoin[] newArray(int size) {
            return new TxSendCoin[size];
        }
    };
    private String mCoin = "MNT";
    private MinterAddress mTo;
    private BigInteger mValue;

    public TxSendCoin(Transaction rawTx) {
        super(rawTx);
    }

    protected TxSendCoin(Parcel in) {
        super(in);
        this.mCoin = in.readString();
        this.mTo = (MinterAddress)in.readValue(MinterAddress.class.getClassLoader());
        this.mValue = (BigInteger)in.readValue(BigInteger.class.getClassLoader());
    }

    public double getValue() {
        return new BigDecimal(this.mValue).divide(Transaction.VALUE_MUL_DEC).doubleValue();
    }

    public TxSendCoin setValue(double value) {
        return this.setValue(new BigDecimal(value));
    }

    public TxSendCoin setValue(@NonNull CharSequence decimalValue) {
        Preconditions.checkNotNull((Object)decimalValue);
        return this.setValue(new BigDecimal(decimalValue.toString()));
    }

    public TxSendCoin setValue(BigDecimal value) {
        this.mValue = value.multiply(Transaction.VALUE_MUL_DEC).toBigInteger();
        return this;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCoin);
        dest.writeValue((Object)this.mTo);
        dest.writeValue((Object)this.mValue);
    }

    public BigInteger getValueBigInteger() {
        return this.mValue;
    }

    public MinterAddress getTo() {
        return new MinterAddress(this.mTo);
    }

    public TxSendCoin setTo(CharSequence address) {
        return this.setTo(address.toString());
    }

    public TxSendCoin setTo(MinterAddress address) {
        this.mTo = address;
        return this;
    }

    public TxSendCoin setTo(String address) {
        return this.setTo(new MinterAddress((CharSequence)address));
    }

    public String getCoin() {
        return this.mCoin.replace("\u0000", "");
    }

    public TxSendCoin setCoin(String coin) {
        this.mCoin = StringHelper.strrpad((int)10, (String)coin.toUpperCase());
        return this;
    }

    public TxSendCoin setRawValue(String rawValue, int radix) {
        return this.setValue(new BigInteger(rawValue, radix));
    }

    @Override
    public OperationType getType() {
        return OperationType.SendCoin;
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mCoin", this.mCoin != null && this.mCoin.length() > 2 && this.mCoin.length() < 11, "Coin symbol length must be from 3 mTo 10 chars").addResult("mTo", this.mTo != null, "Recipient address must be set").addResult("mValue", this.mValue != null, "Value must be set");
    }

    @Override
    @NonNull
    protected byte[] encodeRLP() {
        byte[] to = this.mTo.getData();
        to = BytesHelper.lpad((int)20, (byte[])to);
        return RLP.encode((Object)new Object[]{this.mCoin, to, this.mValue});
    }

    @Override
    protected void decodeRLP(@NonNull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mCoin = StringHelper.bytesToString((byte[])this.fromRawRlp(0, decoded));
        this.mTo = new MinterAddress(this.fromRawRlp(1, decoded));
        this.mValue = BytesHelper.fixBigintSignedByte((byte[])this.fromRawRlp(2, decoded));
    }

    private TxSendCoin setValue(BigInteger value) {
        this.mValue = value.multiply(Transaction.VALUE_MUL);
        return this;
    }
}

