/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain.models.operational;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import network.minter.blockchain.models.operational.FieldsValidationResult;
import network.minter.blockchain.models.operational.Operation;
import network.minter.blockchain.models.operational.OperationType;
import network.minter.blockchain.models.operational.Transaction;
import network.minter.core.crypto.PublicKey;
import network.minter.core.util.DecodeResult;
import network.minter.core.util.RLP;

public final class TxSetCandidateOnline
extends Operation {
    public static final Parcelable.Creator<TxSetCandidateOnline> CREATOR = new Parcelable.Creator<TxSetCandidateOnline>(){

        public TxSetCandidateOnline createFromParcel(Parcel in) {
            return new TxSetCandidateOnline(in);
        }

        public TxSetCandidateOnline[] newArray(int size) {
            return new TxSetCandidateOnline[size];
        }
    };
    private PublicKey mPubKey;

    public TxSetCandidateOnline(Transaction rawTx) {
        super(rawTx);
    }

    protected TxSetCandidateOnline(Parcel in) {
        super(in);
        this.mPubKey = (PublicKey)in.readValue(PublicKey.class.getClassLoader());
    }

    public PublicKey getPublicKey() {
        return this.mPubKey;
    }

    public TxSetCandidateOnline setPublicKey(byte[] publicKey) {
        this.mPubKey = new PublicKey(publicKey);
        return this;
    }

    public TxSetCandidateOnline setPublicKey(PublicKey publicKey) {
        this.mPubKey = publicKey;
        return this;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeValue((Object)this.mPubKey);
    }

    public TxSetCandidateOnline setPublicKey(String hexPubKey) {
        this.mPubKey = new PublicKey((CharSequence)hexPubKey);
        return this;
    }

    @Override
    public OperationType getType() {
        return OperationType.SetCandidateOnline;
    }

    @Override
    @NonNull
    protected byte[] encodeRLP() {
        return RLP.encode((Object)new Object[]{this.mPubKey.getData()});
    }

    @Override
    @Nullable
    protected FieldsValidationResult validate() {
        return new FieldsValidationResult().addResult("mPubKey", this.mPubKey != null, "Node public key must be set");
    }

    @Override
    protected void decodeRLP(@NonNull byte[] rlpEncodedData) {
        DecodeResult rlp = RLP.decode((byte[])rlpEncodedData, (int)0);
        Object[] decoded = (Object[])rlp.getDecoded();
        this.mPubKey = new PublicKey(this.fromRawRlp(0, decoded));
    }
}

