/*
 * Decompiled with CFR 0.152.
 */
package network.minter.blockchain;

import android.support.annotation.NonNull;
import com.google.gson.GsonBuilder;
import java.math.BigInteger;
import network.minter.blockchain.repo.BlockChainAccountRepository;
import network.minter.blockchain.repo.BlockChainCoinRepository;
import network.minter.blockchain.repo.BlockChainTransactionRepository;
import network.minter.core.crypto.BytesData;
import network.minter.core.crypto.MinterAddress;
import network.minter.core.crypto.MinterHash;
import network.minter.core.internal.api.ApiService;
import network.minter.core.internal.api.converters.BigIntegerDeserializer;
import network.minter.core.internal.api.converters.BytesDataDeserializer;
import network.minter.core.internal.api.converters.MinterAddressDeserializer;
import network.minter.core.internal.api.converters.MinterHashDeserializer;
import okhttp3.logging.HttpLoggingInterceptor;

public class MinterBlockChainApi {
    private static final String BASE_NODE_URL = "http://minter-node-1.testnet.minter.network:8841";
    private static MinterBlockChainApi INSTANCE;
    private final ApiService.Builder mApiService;
    private BlockChainAccountRepository mAccountRepository;
    private BlockChainCoinRepository mCoinRepository;
    private BlockChainTransactionRepository mTransactionRepository;

    private MinterBlockChainApi() {
        this(BASE_NODE_URL);
    }

    private MinterBlockChainApi(@NonNull String baseNodeApiUrl) {
        this.mApiService = new ApiService.Builder(baseNodeApiUrl, this.getGsonBuilder());
        this.mApiService.addHeader("Content-Type", "application/json");
        this.mApiService.addHeader("X-Minter-Client-Name", "MinterAndroid");
        this.mApiService.addHeader("X-Minter-Client-Version", "0.1.0");
    }

    public static void initialize() {
        MinterBlockChainApi.initialize(BASE_NODE_URL, false);
    }

    public static void initialize(String baseNodeApiUrl, boolean debug) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new MinterBlockChainApi(baseNodeApiUrl);
        MinterBlockChainApi.INSTANCE.mApiService.setDebug(debug);
        if (debug) {
            MinterBlockChainApi.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static void initialize(boolean debug) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new MinterBlockChainApi();
        MinterBlockChainApi.INSTANCE.mApiService.setDebug(debug);
        if (debug) {
            MinterBlockChainApi.INSTANCE.mApiService.setDebugRequestLevel(HttpLoggingInterceptor.Level.BODY);
        }
    }

    public static MinterBlockChainApi getInstance() {
        return INSTANCE;
    }

    public GsonBuilder getGsonBuilder() {
        GsonBuilder out = new GsonBuilder();
        out.registerTypeAdapter(MinterAddress.class, (Object)new MinterAddressDeserializer());
        out.registerTypeAdapter(MinterHash.class, (Object)new MinterHashDeserializer());
        out.registerTypeAdapter(BigInteger.class, (Object)new BigIntegerDeserializer());
        out.registerTypeAdapter(BytesData.class, (Object)new BytesDataDeserializer());
        return out;
    }

    public BlockChainAccountRepository account() {
        if (this.mAccountRepository == null) {
            this.mAccountRepository = new BlockChainAccountRepository(this.mApiService);
        }
        return this.mAccountRepository;
    }

    public BlockChainTransactionRepository transactions() {
        if (this.mTransactionRepository == null) {
            this.mTransactionRepository = new BlockChainTransactionRepository(this.mApiService);
        }
        return this.mTransactionRepository;
    }

    public BlockChainCoinRepository coin() {
        if (this.mCoinRepository == null) {
            this.mCoinRepository = new BlockChainCoinRepository(this.mApiService);
        }
        return this.mCoinRepository;
    }
}

