/*
 * Decompiled with CFR 0.152.
 */
package net.zetetic.database.sqlcipher;

import androidx.annotation.NonNull;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import net.zetetic.database.sqlcipher.SQLiteDatabaseHook;
import net.zetetic.database.sqlcipher.SupportHelper;

public class SupportOpenHelperFactory
implements SupportSQLiteOpenHelper.Factory {
    private static final int UNCHANGED = -1;
    private final byte[] password;
    private final SQLiteDatabaseHook hook;
    private final boolean enableWriteAheadLogging;
    private final int minimumSupportedVersion;

    public SupportOpenHelperFactory(byte[] password) {
        this(password, null, false);
    }

    public SupportOpenHelperFactory(byte[] password, SQLiteDatabaseHook hook, boolean enableWriteAheadLogging) {
        this(password, hook, enableWriteAheadLogging, -1);
    }

    public SupportOpenHelperFactory(byte[] password, SQLiteDatabaseHook hook, boolean enableWriteAheadLogging, int minimumSupportedVersion) {
        this.password = password;
        this.hook = hook;
        this.enableWriteAheadLogging = enableWriteAheadLogging;
        this.minimumSupportedVersion = minimumSupportedVersion;
    }

    @NonNull
    public SupportSQLiteOpenHelper create(@NonNull SupportSQLiteOpenHelper.Configuration configuration) {
        if (this.minimumSupportedVersion == -1) {
            return new SupportHelper(configuration, this.password, this.hook, this.enableWriteAheadLogging);
        }
        return new SupportHelper(configuration, this.password, this.hook, this.enableWriteAheadLogging, this.minimumSupportedVersion);
    }
}

