/*
 * Decompiled with CFR 0.152.
 */
package net.zetetic.database.sqlcipher;

import androidx.annotation.Nullable;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import net.zetetic.database.sqlcipher.SQLiteDatabase;
import net.zetetic.database.sqlcipher.SQLiteDatabaseHook;
import net.zetetic.database.sqlcipher.SQLiteOpenHelper;

public class SupportHelper
implements SupportSQLiteOpenHelper {
    private SQLiteOpenHelper openHelper;

    public SupportHelper(SupportSQLiteOpenHelper.Configuration configuration, byte[] password, SQLiteDatabaseHook hook, boolean enableWriteAheadLogging) {
        this(configuration, password, hook, enableWriteAheadLogging, 0);
    }

    public SupportHelper(final SupportSQLiteOpenHelper.Configuration configuration, byte[] password, SQLiteDatabaseHook hook, boolean enableWriteAheadLogging, int minimumSupportedVersion) {
        this.openHelper = new SQLiteOpenHelper(configuration.context, configuration.name, password, null, configuration.callback.version, minimumSupportedVersion, null, hook, enableWriteAheadLogging){

            @Override
            public void onCreate(SQLiteDatabase db) {
                configuration.callback.onCreate((SupportSQLiteDatabase)db);
            }

            @Override
            public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                configuration.callback.onUpgrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
            }

            @Override
            public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                configuration.callback.onDowngrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
            }

            @Override
            public void onOpen(SQLiteDatabase db) {
                configuration.callback.onOpen((SupportSQLiteDatabase)db);
            }

            @Override
            public void onConfigure(SQLiteDatabase db) {
                configuration.callback.onConfigure((SupportSQLiteDatabase)db);
            }
        };
    }

    @Nullable
    public String getDatabaseName() {
        return this.openHelper.getDatabaseName();
    }

    public void setWriteAheadLoggingEnabled(boolean enabled) {
        this.openHelper.setWriteAheadLoggingEnabled(enabled);
    }

    public SupportSQLiteDatabase getWritableDatabase() {
        return this.openHelper.getWritableDatabase();
    }

    public SupportSQLiteDatabase getReadableDatabase() {
        return this.openHelper.getReadableDatabase();
    }

    public void close() {
        this.openHelper.close();
    }
}

