/*
 * Decompiled with CFR 0.152.
 */
package net.zetetic.database.sqlcipher;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import net.zetetic.database.DatabaseErrorHandler;
import net.zetetic.database.sqlcipher.SQLiteDatabase;
import net.zetetic.database.sqlcipher.SQLiteDatabaseHook;

public abstract class SQLiteOpenHelper
implements SupportSQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private static final boolean DEBUG_STRICT_READONLY = false;
    private final Context mContext;
    private final String mName;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private final int mMinimumSupportedVersion;
    private SQLiteDatabase mDatabase;
    private byte[] mPassword;
    private boolean mIsInitializing;
    private boolean mEnableWriteAheadLogging;
    private final DatabaseErrorHandler mErrorHandler;
    private final SQLiteDatabaseHook mDatabaseHook;

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        this(context, name, factory, version, null);
    }

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
        this(context, name, factory, version, 0, errorHandler);
    }

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, int minimumSupportedVersion, DatabaseErrorHandler errorHandler) {
        this(context, name, new byte[0], factory, version, minimumSupportedVersion, errorHandler, null, false);
    }

    public SQLiteOpenHelper(Context context, String name, String password, SQLiteDatabase.CursorFactory factory, int version, int minimumSupportedVersion, DatabaseErrorHandler errorHandler, SQLiteDatabaseHook databaseHook, boolean enableWriteAheadLogging) {
        this(context, name, SQLiteOpenHelper.getBytes(password), factory, version, minimumSupportedVersion, errorHandler, databaseHook, enableWriteAheadLogging);
    }

    public SQLiteOpenHelper(Context context, String name, byte[] password, SQLiteDatabase.CursorFactory factory, int version, int minimumSupportedVersion, DatabaseErrorHandler errorHandler, SQLiteDatabaseHook databaseHook, boolean enableWriteAheadLogging) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mContext = context;
        this.mName = name;
        this.mPassword = password;
        this.mFactory = factory;
        this.mNewVersion = version;
        this.mErrorHandler = errorHandler;
        this.mDatabaseHook = databaseHook;
        this.mEnableWriteAheadLogging = enableWriteAheadLogging;
        this.mMinimumSupportedVersion = Math.max(0, minimumSupportedVersion);
    }

    public String getDatabaseName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            if (this.mEnableWriteAheadLogging != enabled) {
                if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
                    if (enabled) {
                        this.mDatabase.enableWriteAheadLogging();
                    } else {
                        this.mDatabase.disableWriteAheadLogging();
                    }
                }
                this.mEnableWriteAheadLogging = enabled;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getWritableDatabase() {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            return this.getDatabaseLocked(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getReadableDatabase() {
        SQLiteOpenHelper sQLiteOpenHelper = this;
        synchronized (sQLiteOpenHelper) {
            return this.getDatabaseLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLiteDatabase getDatabaseLocked(boolean writable) {
        if (this.mDatabase != null) {
            if (!this.mDatabase.isOpen()) {
                this.mDatabase = null;
            } else if (!writable || !this.mDatabase.isReadOnly()) {
                return this.mDatabase;
            }
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getDatabase called recursively");
        }
        SQLiteDatabase db = this.mDatabase;
        try {
            this.mIsInitializing = true;
            if (db != null) {
                if (writable && db.isReadOnly()) {
                    db.reopenReadWrite();
                }
            } else if (this.mName == null) {
                db = SQLiteDatabase.create(null);
            } else {
                try {
                    File filePath;
                    File databasesDirectory;
                    String path = this.mName;
                    if (!path.startsWith("file:")) {
                        path = this.mContext.getDatabasePath(path).getPath();
                    }
                    if (!(databasesDirectory = new File((filePath = new File(path)).getParent())).exists()) {
                        databasesDirectory.mkdirs();
                    }
                    int flags = 0x10000000;
                    if (this.mEnableWriteAheadLogging) {
                        flags |= 0x20000000;
                    }
                    db = SQLiteDatabase.openDatabase(path, this.mPassword, this.mFactory, flags, this.mErrorHandler, this.mDatabaseHook);
                }
                catch (SQLiteException ex) {
                    if (writable) {
                        throw ex;
                    }
                    Log.e((String)TAG, (String)("Couldn't open " + this.mName + " for writing (will try read-only):"), (Throwable)ex);
                    String path = this.mContext.getDatabasePath(this.mName).getPath();
                    db = SQLiteDatabase.openDatabase(path, this.mPassword, this.mFactory, 1, this.mErrorHandler, this.mDatabaseHook);
                }
            }
            this.onConfigure(db);
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                if (db.isReadOnly()) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + this.mName);
                }
                if (version > 0 && version < this.mMinimumSupportedVersion) {
                    File databaseFile = new File(db.getPath());
                    this.onBeforeDelete(db);
                    db.close();
                    if (SQLiteDatabase.deleteDatabase(databaseFile)) {
                        this.mIsInitializing = false;
                        SQLiteDatabase sQLiteDatabase = this.getDatabaseLocked(writable);
                        return sQLiteDatabase;
                    }
                    throw new IllegalStateException("Unable to delete obsolete database " + this.mName + " with version " + version);
                }
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else if (version > this.mNewVersion) {
                        this.onDowngrade(db, version, this.mNewVersion);
                    } else {
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            if (db.isReadOnly()) {
                Log.w((String)TAG, (String)("Opened " + this.mName + " in read-only mode"));
            }
            this.mDatabase = db;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (db != null && db != this.mDatabase) {
                db.close();
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public void onConfigure(SQLiteDatabase db) {
    }

    public void onBeforeDelete(SQLiteDatabase db) {
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
    }

    public void onOpen(SQLiteDatabase db) {
    }

    private static byte[] getBytes(String data) {
        if (data == null || data.length() == 0) {
            return new byte[0];
        }
        CharBuffer charBuffer = CharBuffer.wrap(data);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] result = new byte[byteBuffer.limit()];
        byteBuffer.get(result);
        return result;
    }
}

