/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import net.sqlcipher.Cursor;
import net.sqlcipher.database.SQLiteCursor;
import net.sqlcipher.database.SQLiteCursorDriver;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteQuery;

public class SQLiteDirectCursorDriver
implements SQLiteCursorDriver {
    private String mEditTable;
    private SQLiteDatabase mDatabase;
    private Cursor mCursor;
    private String mSql;
    private SQLiteQuery mQuery;

    public SQLiteDirectCursorDriver(SQLiteDatabase db, String sql, String editTable) {
        this.mDatabase = db;
        this.mEditTable = editTable;
        this.mSql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor query(SQLiteDatabase.CursorFactory factory, Object[] args) {
        SQLiteQuery query = new SQLiteQuery(this.mDatabase, this.mSql, 0, args);
        try {
            query.bindArguments(args);
            this.mCursor = factory == null ? new SQLiteCursor(this.mDatabase, this, this.mEditTable, query) : factory.newCursor(this.mDatabase, this, this.mEditTable, query);
            this.mQuery = query;
            query = null;
            Cursor cursor = this.mCursor;
            return cursor;
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor query(SQLiteDatabase.CursorFactory factory, String[] selectionArgs) {
        SQLiteQuery query = new SQLiteQuery(this.mDatabase, this.mSql, 0, selectionArgs);
        try {
            int numArgs = selectionArgs == null ? 0 : selectionArgs.length;
            for (int i = 0; i < numArgs; ++i) {
                query.bindString(i + 1, selectionArgs[i]);
            }
            this.mCursor = factory == null ? new SQLiteCursor(this.mDatabase, this, this.mEditTable, query) : factory.newCursor(this.mDatabase, this, this.mEditTable, query);
            this.mQuery = query;
            query = null;
            Cursor cursor = this.mCursor;
            return cursor;
        }
        finally {
            if (query != null) {
                query.close();
            }
        }
    }

    public void cursorClosed() {
        this.mCursor = null;
    }

    public void setBindArguments(String[] bindArgs) {
        int numArgs = bindArgs.length;
        for (int i = 0; i < numArgs; ++i) {
            this.mQuery.bindString(i + 1, bindArgs[i]);
        }
    }

    public void cursorDeactivated() {
    }

    public void cursorRequeried(android.database.Cursor cursor) {
    }

    public String toString() {
        return "SQLiteDirectCursorDriver: " + this.mSql;
    }
}

