/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher;

import android.database.CharArrayBuffer;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;

public class CursorWindow
extends android.database.CursorWindow
implements Parcelable {
    private long nWindow;
    private int mStartPos;
    public static final Parcelable.Creator<CursorWindow> CREATOR = new Parcelable.Creator<CursorWindow>(){

        public CursorWindow createFromParcel(Parcel source) {
            return new CursorWindow(source, 0);
        }

        public CursorWindow[] newArray(int size) {
            return new CursorWindow[size];
        }
    };

    public CursorWindow(boolean localWindow) {
        super(localWindow);
        this.mStartPos = 0;
        this.native_init(localWindow);
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        this.acquireReference();
        try {
            int n = this.getNumRows_native();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    private native int getNumRows_native();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNumColumns(int columnNum) {
        this.acquireReference();
        try {
            boolean bl = this.setNumColumns_native(columnNum);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean setNumColumns_native(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allocRow() {
        this.acquireReference();
        try {
            boolean bl = this.allocRow_native();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean allocRow_native();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeLastRow() {
        this.acquireReference();
        try {
            this.freeLastRow_native();
        }
        finally {
            this.releaseReference();
        }
    }

    private native void freeLastRow_native();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putBlob(byte[] value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putBlob_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean putBlob_native(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putString(String value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putString_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean putString_native(String var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putLong(long value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putLong_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean putLong_native(long var1, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putDouble(double value, int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putDouble_native(value, row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean putDouble_native(double var1, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putNull(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.putNull_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean putNull_native(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isNull_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean isNull_native(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(int row, int col) {
        this.acquireReference();
        try {
            byte[] byArray = this.getBlob_native(row - this.mStartPos, col);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    private native byte[] getBlob_native(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(int row, int col) {
        this.acquireReference();
        try {
            int n = this.getType_native(row - this.mStartPos, col);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlob(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isBlob_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLong(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isInteger_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFloat(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isFloat_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isString(int row, int col) {
        this.acquireReference();
        try {
            boolean bl = this.isString_native(row - this.mStartPos, col);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private native boolean isBlob_native(int var1, int var2);

    private native boolean isString_native(int var1, int var2);

    private native boolean isInteger_native(int var1, int var2);

    private native boolean isFloat_native(int var1, int var2);

    private native int getType_native(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int row, int col) {
        this.acquireReference();
        try {
            String string = this.getString_native(row - this.mStartPos, col);
            return string;
        }
        finally {
            this.releaseReference();
        }
    }

    private native String getString_native(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStringToBuffer(int row, int col, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        if (buffer.data == null) {
            buffer.data = new char[64];
        }
        this.acquireReference();
        try {
            char[] newbuf = this.copyStringToBuffer_native(row - this.mStartPos, col, buffer.data.length, buffer);
            if (newbuf != null) {
                buffer.data = newbuf;
            }
        }
        finally {
            this.releaseReference();
        }
    }

    private native char[] copyStringToBuffer_native(int var1, int var2, int var3, CharArrayBuffer var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int row, int col) {
        this.acquireReference();
        try {
            long l = this.getLong_native(row - this.mStartPos, col);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    private native long getLong_native(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int row, int col) {
        this.acquireReference();
        try {
            double d = this.getDouble_native(row - this.mStartPos, col);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    private native double getDouble_native(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int row, int col) {
        this.acquireReference();
        try {
            short s = (short)this.getLong_native(row - this.mStartPos, col);
            return s;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int row, int col) {
        this.acquireReference();
        try {
            int n = (int)this.getLong_native(row - this.mStartPos, col);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int row, int col) {
        this.acquireReference();
        try {
            float f = (float)this.getDouble_native(row - this.mStartPos, col);
            return f;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            this.native_clear();
        }
        finally {
            this.releaseReference();
        }
    }

    private native void native_clear();

    public void close() {
        this.releaseReference();
    }

    private native void close_native();

    protected void finalize() {
        if (this.nWindow == 0L) {
            return;
        }
        this.close_native();
    }

    public static CursorWindow newFromParcel(Parcel p) {
        return (CursorWindow)((Object)CREATOR.createFromParcel(p));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.native_getBinder());
        dest.writeInt(this.mStartPos);
    }

    public CursorWindow(Parcel source, int foo) {
        super(true);
        IBinder nativeBinder = source.readStrongBinder();
        this.mStartPos = source.readInt();
        this.native_init(nativeBinder);
    }

    private native IBinder native_getBinder();

    private native void native_init(boolean var1);

    private native void native_init(IBinder var1);

    protected void onAllReferencesReleased() {
        this.close_native();
        super.onAllReferencesReleased();
    }
}

