/*
 * Decompiled with CFR 0.152.
 */
package net.wiringbits.webapp.utils.api;

import java.io.Serializable;
import net.wiringbits.webapp.utils.api.AdminDataExplorerApiClient$;
import net.wiringbits.webapp.utils.api.AdminDataExplorerApiClient$Config$;
import net.wiringbits.webapp.utils.api.models.AdminCreateTable;
import net.wiringbits.webapp.utils.api.models.AdminCreateTable$;
import net.wiringbits.webapp.utils.api.models.AdminDeleteTable;
import net.wiringbits.webapp.utils.api.models.AdminDeleteTable$;
import net.wiringbits.webapp.utils.api.models.AdminGetTables;
import net.wiringbits.webapp.utils.api.models.AdminGetTables$;
import net.wiringbits.webapp.utils.api.models.AdminUpdateTable;
import net.wiringbits.webapp.utils.api.models.AdminUpdateTable$;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import sttp.client3.RequestT;
import sttp.client3.SttpBackend;
import sttp.client3.package$;
import sttp.model.MediaType$;
import sttp.model.Uri;
import sttp.model.Uri$;

public interface AdminDataExplorerApiClient {
    public Future<AdminGetTables.Response> getTables();

    public Future<List<Map<String, String>>> getTableMetadata(String var1, List<String> var2, List<Object> var3, String var4);

    public Future<Map<String, String>> viewItem(String var1, String var2);

    public Future<List<Map<String, String>>> viewItems(String var1, List<String> var2);

    public Future<AdminCreateTable.Response> createItem(String var1, AdminCreateTable.Request var2);

    public Future<AdminUpdateTable.Response> updateItem(String var1, String var2, Map<String, String> var3);

    public Future<AdminDeleteTable.Response> deleteItem(String var1, String var2);

    public static class Config
    implements Product,
    Serializable {
        private final String serverUrl;

        public static Config apply(String string) {
            return AdminDataExplorerApiClient$Config$.MODULE$.apply(string);
        }

        public static Config fromProduct(Product product) {
            return AdminDataExplorerApiClient$Config$.MODULE$.fromProduct(product);
        }

        public static Config unapply(Config config) {
            return AdminDataExplorerApiClient$Config$.MODULE$.unapply(config);
        }

        public Config(String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Config)) return false;
            Config config = (Config)object;
            String string = this.serverUrl();
            String string2 = config.serverUrl();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!config.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Config;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Config";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "serverUrl";
        }

        public String serverUrl() {
            return this.serverUrl;
        }

        public Config copy(String serverUrl) {
            return new Config(serverUrl);
        }

        public String copy$default$1() {
            return this.serverUrl();
        }

        public String _1() {
            return this.serverUrl();
        }
    }

    public static class DefaultImpl
    implements AdminDataExplorerApiClient {
        private final SttpBackend<Future, ?> backend;
        private final ExecutionContext ec;
        private final Uri ServerAPI;

        public DefaultImpl(Config config, SttpBackend<Future, ?> backend, ExecutionContext ec) {
            this.backend = backend;
            this.ec = ec;
            this.ServerAPI = (Uri)Uri$.MODULE$.parse(config.serverUrl()).getOrElse(this::$init$$$anonfun$1);
        }

        private <R> RequestT<None$, Try<R>, Object> prepareRequest(Reads<R> evidence$2) {
            return package$.MODULE$.basicRequest().contentType(MediaType$.MODULE$.ApplicationJson()).response(AdminDataExplorerApiClient$.MODULE$.net$wiringbits$webapp$utils$api$AdminDataExplorerApiClient$$$asJson(evidence$2));
        }

        @Override
        public Future<AdminGetTables.Response> getTables() {
            scala.collection.immutable.Seq path = (scala.collection.immutable.Seq)((SeqOps)this.ServerAPI.path().$colon$plus((Object)"admin")).$colon$plus((Object)"tables");
            Uri uri = this.ServerAPI.withPath((Seq)path);
            return ((Future)this.prepareRequest((Reads)AdminGetTables$.MODULE$.adminGetTablesResponseFormat()).get(uri).send(this.backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$2 -> (Try)_$2.body(), this.ec).flatMap((Function1 & Serializable)result -> Future$.MODULE$.fromTry(result), this.ec);
        }

        @Override
        public Future<List<Map<String, String>>> getTableMetadata(String tableName, List<String> sort, List<Object> range, String filter) {
            scala.collection.immutable.Seq path = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)this.ServerAPI.path().$colon$plus((Object)"admin")).$colon$plus((Object)"tables")).$colon$plus((Object)tableName);
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"sort");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)sort.mkString("[", ",", "]"));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"range");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)range.mkString("[", ",", "]"));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"filter");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)filter);
            Map parameters = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            Uri uri = this.ServerAPI.withPath((Seq)path).addParams(parameters);
            return ((Future)this.prepareRequest(Reads$.MODULE$.traversableReads(List$.MODULE$.iterableFactory(), Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads()))).get(uri).send(this.backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$3 -> (Try)_$3.body(), this.ec).flatMap((Function1 & Serializable)result -> Future$.MODULE$.fromTry(result), this.ec);
        }

        @Override
        public Future<Map<String, String>> viewItem(String tableName, String id) {
            scala.collection.immutable.Seq path = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)((SeqOps)this.ServerAPI.path().$colon$plus((Object)"admin")).$colon$plus((Object)"tables")).$colon$plus((Object)tableName)).$colon$plus((Object)id);
            Uri uri = this.ServerAPI.withPath((Seq)path);
            return ((Future)this.prepareRequest(Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads())).get(uri).send(this.backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$4 -> (Try)_$4.body(), this.ec).flatMap((Function1 & Serializable)result -> Future$.MODULE$.fromTry(result), this.ec);
        }

        @Override
        public Future<List<Map<String, String>>> viewItems(String tableName, List<String> id) {
            scala.collection.immutable.Seq path = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)this.ServerAPI.path().$colon$plus((Object)"admin")).$colon$plus((Object)"tables")).$colon$plus((Object)tableName);
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, id);
            String primaryKeyParam = Json$.MODULE$.toJson(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Writes)Writes$.MODULE$.genericMapWrites(Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites()))).toString();
            Object[] objectArray2 = new Tuple2[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"filter");
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)primaryKeyParam);
            Uri uri = this.ServerAPI.withPath((Seq)path).withParams((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
            return ((Future)this.prepareRequest(Reads$.MODULE$.traversableReads(List$.MODULE$.iterableFactory(), Reads$.MODULE$.mapReads((Reads)Reads$.MODULE$.StringReads()))).get(uri).send(this.backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$5 -> (Try)_$5.body(), this.ec).flatMap((Function1 & Serializable)result -> Future$.MODULE$.fromTry(result), this.ec);
        }

        @Override
        public Future<AdminCreateTable.Response> createItem(String tableName, AdminCreateTable.Request request) {
            scala.collection.immutable.Seq path = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)this.ServerAPI.path().$colon$plus((Object)"admin")).$colon$plus((Object)"tables")).$colon$plus((Object)tableName);
            Uri uri = this.ServerAPI.withPath((Seq)path);
            return ((Future)this.prepareRequest((Reads)AdminCreateTable$.MODULE$.adminCreateTableResponseFormat()).post(uri).body(Json$.MODULE$.toJson((Object)request, AdminCreateTable$.MODULE$.adminCreateTableRequestFormat()).toString()).send(this.backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$6 -> (Try)_$6.body(), this.ec).flatMap((Function1 & Serializable)result -> Future$.MODULE$.fromTry(result), this.ec);
        }

        @Override
        public Future<AdminUpdateTable.Response> updateItem(String tableName, String id, Map<String, String> request) {
            scala.collection.immutable.Seq path = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)((SeqOps)this.ServerAPI.path().$colon$plus((Object)"admin")).$colon$plus((Object)"tables")).$colon$plus((Object)tableName)).$colon$plus((Object)id);
            Uri uri = this.ServerAPI.withPath((Seq)path);
            return ((Future)this.prepareRequest((Reads)AdminUpdateTable$.MODULE$.adminUpdateTableResponseFormat()).put(uri).body(Json$.MODULE$.toJson(request, (Writes)Writes$.MODULE$.genericMapWrites((Writes)Writes$.MODULE$.StringWrites())).toString()).send(this.backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$7 -> (Try)_$7.body(), this.ec).flatMap((Function1 & Serializable)result -> Future$.MODULE$.fromTry(result), this.ec);
        }

        @Override
        public Future<AdminDeleteTable.Response> deleteItem(String tableName, String id) {
            scala.collection.immutable.Seq path = (scala.collection.immutable.Seq)((SeqOps)((SeqOps)((SeqOps)this.ServerAPI.path().$colon$plus((Object)"admin")).$colon$plus((Object)"tables")).$colon$plus((Object)tableName)).$colon$plus((Object)id);
            Uri uri = this.ServerAPI.withPath((Seq)path);
            return ((Future)this.prepareRequest((Reads)AdminDeleteTable$.MODULE$.adminDeleteTableResponseFormat()).delete(uri).send(this.backend, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl())).map((Function1 & Serializable)_$8 -> (Try)_$8.body(), this.ec).flatMap((Function1 & Serializable)result -> Future$.MODULE$.fromTry(result), this.ec);
        }

        private final Uri $init$$$anonfun$1() {
            throw new RuntimeException("Invalid server url");
        }
    }
}

