/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.time4j.Duration;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeSpan;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.IntervalFactory;
import net.time4j.range.TimestampInterval;

final class TimestampIntervalFactory
implements IntervalFactory<PlainTimestamp, TimestampInterval> {
    private static final Set<ChronoElement<?>> CSET;
    private static final Set<ChronoElement<?>> OSET;
    private static final Set<ChronoElement<?>> WSET;
    static final TimestampIntervalFactory INSTANCE;

    private TimestampIntervalFactory() {
    }

    @Override
    public TimestampInterval between(Boundary<PlainTimestamp> boundary, Boundary<PlainTimestamp> boundary2) {
        return new TimestampInterval(boundary, boundary2);
    }

    @Override
    public PlainTimestamp plusPeriod(PlainTimestamp plainTimestamp, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        try {
            return (PlainTimestamp)plainTimestamp.plus((TimeSpan)Duration.parsePeriod((String)string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public PlainTimestamp minusPeriod(PlainTimestamp plainTimestamp, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        try {
            return (PlainTimestamp)plainTimestamp.minus((TimeSpan)Duration.parsePeriod((String)string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Set<ChronoElement<?>> stdElements(ChronoEntity<?> chronoEntity) {
        if (chronoEntity.contains((ChronoElement)PlainDate.DAY_OF_MONTH)) {
            return CSET;
        }
        if (chronoEntity.contains((ChronoElement)PlainDate.DAY_OF_YEAR)) {
            return OSET;
        }
        if (chronoEntity.contains((ChronoElement)PlainDate.DAY_OF_WEEK)) {
            return WSET;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isCalendrical() {
        return false;
    }

    static {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(PlainDate.YEAR);
        hashSet.add(PlainDate.MONTH_AS_NUMBER);
        hashSet.add(PlainDate.DAY_OF_MONTH);
        CSET = Collections.unmodifiableSet(hashSet);
        HashSet<Object> hashSet2 = new HashSet<Object>();
        hashSet2.add(PlainDate.YEAR);
        hashSet2.add(PlainDate.DAY_OF_YEAR);
        OSET = Collections.unmodifiableSet(hashSet2);
        HashSet<Object> hashSet3 = new HashSet<Object>();
        hashSet3.add(PlainDate.YEAR_OF_WEEKDATE);
        hashSet3.add(Weekmodel.ISO.weekOfYear());
        hashSet3.add(PlainDate.DAY_OF_WEEK);
        WSET = Collections.unmodifiableSet(hashSet3);
        INSTANCE = new TimestampIntervalFactory();
    }
}

