/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockInterval;
import net.time4j.range.DayPartitionRule;
import net.time4j.range.IntervalCollection;
import net.time4j.range.SpanOfWeekdays;

public class DayPartitionBuilder {
    private final Predicate<PlainDate> activeFilter;
    private final Map<Weekday, List<ChronoInterval<PlainTime>>> weekdayRules;
    private final Map<PlainDate, List<ChronoInterval<PlainTime>>> exceptionRules;
    private final Set<PlainDate> exclusions;

    public DayPartitionBuilder() {
        this.activeFilter = plainDate -> true;
        this.weekdayRules = new EnumMap<Weekday, List<ChronoInterval<PlainTime>>>(Weekday.class);
        this.exceptionRules = new HashMap<PlainDate, List<ChronoInterval<PlainTime>>>();
        this.exclusions = new HashSet<PlainDate>();
    }

    public DayPartitionBuilder(Predicate<PlainDate> predicate) {
        if (predicate == null) {
            throw new NullPointerException("Missing active filter.");
        }
        this.activeFilter = predicate;
        this.weekdayRules = new EnumMap<Weekday, List<ChronoInterval<PlainTime>>>(Weekday.class);
        this.exceptionRules = new HashMap<PlainDate, List<ChronoInterval<PlainTime>>>();
        this.exclusions = new HashSet<PlainDate>();
    }

    public DayPartitionBuilder addDailyRule(ClockInterval clockInterval) {
        for (Weekday weekday : Weekday.values()) {
            this.addWeekdayRule(weekday, clockInterval);
        }
        return this;
    }

    public DayPartitionBuilder addWeekdayRule(Weekday weekday, ClockInterval clockInterval) {
        if (weekday == null) {
            throw new NullPointerException("Missing day of week.");
        }
        try {
            ClockInterval clockInterval2 = (ClockInterval)clockInterval.toCanonical();
            if (!clockInterval2.isEmpty()) {
                List<ChronoInterval<PlainTime>> list = this.weekdayRules.get(weekday);
                if (list == null) {
                    list = new ArrayList<ChronoInterval<PlainTime>>(5);
                    list.add(clockInterval2);
                } else {
                    list = IntervalCollection.onClockAxis().plus(list).plus(clockInterval2).withBlocks().getIntervals();
                }
                this.weekdayRules.put(weekday, list);
            }
            return this;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public DayPartitionBuilder addWeekdayRule(Weekday weekday, Weekday weekday2, ClockInterval clockInterval) {
        if (weekday2.equals((Object)weekday)) {
            return this.addWeekdayRule(weekday, clockInterval);
        }
        Weekday weekday3 = weekday;
        do {
            this.addWeekdayRule(weekday3, clockInterval);
        } while (!(weekday3 = weekday3.next()).equals((Object)weekday2));
        return this.addWeekdayRule(weekday2, clockInterval);
    }

    public DayPartitionBuilder addWeekdayRule(SpanOfWeekdays spanOfWeekdays, ClockInterval clockInterval) {
        return this.addWeekdayRule(spanOfWeekdays.getStart(), spanOfWeekdays.getEnd(), clockInterval);
    }

    public DayPartitionBuilder addSpecialRule(PlainDate plainDate, ClockInterval clockInterval) {
        if (plainDate == null) {
            throw new NullPointerException("Missing special calendar date.");
        }
        try {
            ClockInterval clockInterval2 = (ClockInterval)clockInterval.toCanonical();
            if (!clockInterval2.isEmpty()) {
                List<ChronoInterval<PlainTime>> list = this.exceptionRules.get(plainDate);
                if (list == null) {
                    list = new ArrayList<ChronoInterval<PlainTime>>(5);
                    list.add(clockInterval2);
                } else {
                    list = IntervalCollection.onClockAxis().plus(list).plus(clockInterval2).withBlocks().getIntervals();
                }
                this.exceptionRules.put(plainDate, list);
            }
            return this;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public DayPartitionBuilder addExclusion(PlainDate plainDate) {
        if (plainDate == null) {
            throw new NullPointerException("Missing exclusion date.");
        }
        this.exclusions.add(plainDate);
        return this;
    }

    public DayPartitionBuilder addExclusion(Collection<PlainDate> collection) {
        collection.stream().forEach(this::addExclusion);
        return this;
    }

    public DayPartitionRule build() {
        final EnumMap<Weekday, List<ChronoInterval<PlainTime>>> enumMap = new EnumMap<Weekday, List<ChronoInterval<PlainTime>>>(this.weekdayRules);
        final HashMap<PlainDate, List<ChronoInterval<PlainTime>>> hashMap = new HashMap<PlainDate, List<ChronoInterval<PlainTime>>>(this.exceptionRules);
        final HashSet<PlainDate> hashSet = new HashSet<PlainDate>(this.exclusions);
        return new DayPartitionRule(){

            @Override
            public List<ChronoInterval<PlainTime>> getPartition(PlainDate plainDate) {
                if (!this.isExcluded(plainDate) && DayPartitionBuilder.this.activeFilter.test(plainDate)) {
                    List list = (List)hashMap.get(plainDate);
                    if (list == null) {
                        list = (List)enumMap.get(plainDate.getDayOfWeek());
                    }
                    if (list != null) {
                        return Collections.unmodifiableList(list);
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public boolean isExcluded(PlainDate plainDate) {
                return hashSet.contains(plainDate);
            }
        };
    }
}

