/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import net.time4j.engine.Temporal;
import net.time4j.range.ClockInterval;
import net.time4j.range.DateInterval;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentInterval;
import net.time4j.range.TimestampInterval;

public enum IntervalRelation {
    PRECEDES,
    MEETS,
    OVERLAPS,
    FINISHES,
    STARTS,
    ENCLOSES,
    EQUIVALENT,
    ENCLOSED_BY,
    STARTED_BY,
    FINISHED_BY,
    OVERLAPPED_BY,
    MET_BY,
    PRECEDED_BY;

    private static final IntervalRelation[] VALUES;
    private static final IntervalRelation[] A_AFTER_B;
    private static final IntervalRelation[] EQUAL_START;
    private static final IntervalRelation[] A_BEFORE_B;

    public IntervalRelation inverse() {
        return VALUES[12 - this.ordinal()];
    }

    public boolean matches(DateInterval dateInterval, DateInterval dateInterval2) {
        return this.matches0(dateInterval, dateInterval2);
    }

    public boolean matches(ClockInterval clockInterval, ClockInterval clockInterval2) {
        return this.matches0(clockInterval, clockInterval2);
    }

    public boolean matches(TimestampInterval timestampInterval, TimestampInterval timestampInterval2) {
        return this.matches0(timestampInterval, timestampInterval2);
    }

    public boolean matches(MomentInterval momentInterval, MomentInterval momentInterval2) {
        return this.matches0(momentInterval, momentInterval2);
    }

    public static IntervalRelation between(DateInterval dateInterval, DateInterval dateInterval2) {
        return IntervalRelation.between0(dateInterval, dateInterval2);
    }

    public static IntervalRelation between(ClockInterval clockInterval, ClockInterval clockInterval2) {
        return IntervalRelation.between0(clockInterval, clockInterval2);
    }

    public static IntervalRelation between(TimestampInterval timestampInterval, TimestampInterval timestampInterval2) {
        return IntervalRelation.between0(timestampInterval, timestampInterval2);
    }

    public static IntervalRelation between(MomentInterval momentInterval, MomentInterval momentInterval2) {
        return IntervalRelation.between0(momentInterval, momentInterval2);
    }

    private <T extends Temporal<? super T>, I extends IsoInterval<T, I>> boolean matches0(I i, I i2) {
        switch (this) {
            case PRECEDES: {
                return i.precedes(i2);
            }
            case MEETS: {
                return i.meets(i2);
            }
            case OVERLAPS: {
                return i.overlaps(i2);
            }
            case FINISHES: {
                return i.finishes(i2);
            }
            case STARTS: {
                return i.starts(i2);
            }
            case ENCLOSES: {
                return i.encloses(i2);
            }
            case EQUIVALENT: {
                return i.equivalentTo(i2);
            }
            case ENCLOSED_BY: {
                return i.enclosedBy(i2);
            }
            case STARTED_BY: {
                return i.startedBy(i2);
            }
            case FINISHED_BY: {
                return i.finishedBy(i2);
            }
            case OVERLAPPED_BY: {
                return i.overlappedBy(i2);
            }
            case MET_BY: {
                return i.metBy(i2);
            }
            case PRECEDED_BY: {
                return i.precededBy(i2);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    private static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalRelation between0(I i, I i2) {
        Temporal temporal = (Temporal)i.getStart().getTemporal();
        Temporal temporal2 = (Temporal)i2.getStart().getTemporal();
        IntervalRelation[] intervalRelationArray = temporal != null && temporal2 != null ? (temporal.isAfter((Object)temporal2) ? A_AFTER_B : (temporal.isSimultaneous((Object)temporal2) ? EQUAL_START : A_BEFORE_B)) : (temporal == null && temporal2 == null ? EQUAL_START : (temporal == null && temporal2 != null ? A_BEFORE_B : A_AFTER_B));
        for (IntervalRelation intervalRelation : intervalRelationArray) {
            if (!intervalRelation.matches0(i, i2)) continue;
            return intervalRelation;
        }
        throw new IllegalStateException("Cannot determine relation between: " + i + " and " + i2);
    }

    static {
        VALUES = IntervalRelation.values();
        A_AFTER_B = new IntervalRelation[]{ENCLOSED_BY, FINISHES, OVERLAPPED_BY, MET_BY, PRECEDED_BY};
        EQUAL_START = new IntervalRelation[]{STARTS, EQUIVALENT, STARTED_BY};
        A_BEFORE_B = new IntervalRelation[]{PRECEDES, MEETS, OVERLAPS, FINISHED_BY, ENCLOSES};
    }
}

