/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import net.time4j.engine.TimeLine;
import net.time4j.format.expert.ChronoPrinter;

public enum InfinityStyle {
    ABORT,
    SYMBOL{

        @Override
        <T> String displayPast(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
            return "-\u221e";
        }

        @Override
        <T> String displayFuture(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
            return "+\u221e";
        }
    }
    ,
    HYPHEN{

        @Override
        <T> String displayPast(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
            return "-";
        }

        @Override
        <T> String displayFuture(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
            return "-";
        }
    }
    ,
    MIN_MAX{

        @Override
        <T> String displayPast(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
            return chronoPrinter.format(timeLine.getMinimum());
        }

        @Override
        <T> String displayFuture(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
            return chronoPrinter.format(timeLine.getMaximum());
        }
    };


    <T> String displayPast(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
        throw new IllegalStateException("Infinite intervals are not supported.");
    }

    <T> String displayFuture(ChronoPrinter<T> chronoPrinter, TimeLine<T> timeLine) {
        throw new IllegalStateException("Infinite intervals are not supported.");
    }
}

