/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockInterval;
import net.time4j.range.DayPartitionRule;
import net.time4j.range.IntervalCollection;

public class DayPartitionBuilder {
    private final Map<Weekday, List<ChronoInterval<PlainTime>>> weekdayRules = new EnumMap<Weekday, List<ChronoInterval<PlainTime>>>(Weekday.class);
    private final Map<PlainDate, List<ChronoInterval<PlainTime>>> exceptionRules = new HashMap<PlainDate, List<ChronoInterval<PlainTime>>>();
    private final Set<PlainDate> exclusions = new HashSet<PlainDate>();

    public DayPartitionBuilder addWeekdayRule(Weekday weekday, ClockInterval clockInterval) {
        if (weekday == null) {
            throw new NullPointerException("Missing day of week.");
        }
        try {
            ClockInterval clockInterval2 = (ClockInterval)clockInterval.toCanonical();
            if (!clockInterval2.isEmpty()) {
                List<ChronoInterval<PlainTime>> list = this.weekdayRules.get(weekday);
                if (list == null) {
                    list = new ArrayList<ChronoInterval<PlainTime>>(5);
                    list.add(clockInterval2);
                } else {
                    list = IntervalCollection.onClockAxis().plus(list).plus(clockInterval2).withBlocks().getIntervals();
                }
                this.weekdayRules.put(weekday, list);
            }
            return this;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public DayPartitionBuilder addSpecialRule(PlainDate plainDate, ClockInterval clockInterval) {
        if (plainDate == null) {
            throw new NullPointerException("Missing special calendar date.");
        }
        try {
            ClockInterval clockInterval2 = (ClockInterval)clockInterval.toCanonical();
            if (!clockInterval2.isEmpty()) {
                List<ChronoInterval<PlainTime>> list = this.exceptionRules.get(plainDate);
                if (list == null) {
                    list = new ArrayList<ChronoInterval<PlainTime>>(5);
                    list.add(clockInterval2);
                } else {
                    list = IntervalCollection.onClockAxis().plus(list).plus(clockInterval2).withBlocks().getIntervals();
                }
                this.exceptionRules.put(plainDate, list);
            }
            return this;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public DayPartitionBuilder addExclusion(PlainDate plainDate) {
        if (plainDate == null) {
            throw new NullPointerException("Missing exclusion date.");
        }
        this.exclusions.add(plainDate);
        return this;
    }

    public DayPartitionBuilder addExclusion(Collection<PlainDate> collection) {
        collection.stream().forEach(this::addExclusion);
        return this;
    }

    public DayPartitionRule build() {
        final EnumMap<Weekday, List<ChronoInterval<PlainTime>>> enumMap = new EnumMap<Weekday, List<ChronoInterval<PlainTime>>>(this.weekdayRules);
        final HashMap<PlainDate, List<ChronoInterval<PlainTime>>> hashMap = new HashMap<PlainDate, List<ChronoInterval<PlainTime>>>(this.exceptionRules);
        final HashSet<PlainDate> hashSet = new HashSet<PlainDate>(this.exclusions);
        return new DayPartitionRule(){

            @Override
            public List<ChronoInterval<PlainTime>> getPartition(PlainDate plainDate) {
                if (!this.isExcluded(plainDate)) {
                    List list = (List)hashMap.get(plainDate);
                    if (list == null) {
                        list = (List)enumMap.get(plainDate.getDayOfWeek());
                    }
                    if (list != null) {
                        return Collections.unmodifiableList(list);
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public boolean isExcluded(PlainDate plainDate) {
                return hashSet.contains(plainDate);
            }
        };
    }
}

