/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.time4j.AdjustableElement;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.format.DisplayMode;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.FixedNumParser;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MachineTime;
import net.time4j.range.MomentIntervalFactory;
import net.time4j.range.NoopPrinter;
import net.time4j.range.SPX;
import net.time4j.range.TimestampInterval;
import net.time4j.range.YearParser;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class MomentInterval
extends IsoInterval<Moment, MomentInterval>
implements Serializable {
    private static final long serialVersionUID = -5403584519478162113L;
    private static final ChronoFormatter<Moment> EXT_C = MomentInterval.calendarFormat(true);
    private static final ChronoFormatter<Moment> EXT_O = MomentInterval.ordinalFormat(true);
    private static final ChronoFormatter<Moment> EXT_W = MomentInterval.weekdateFormat(true);
    private static final ChronoFormatter<Moment> BAS_C = MomentInterval.calendarFormat(false);
    private static final ChronoFormatter<Moment> BAS_O = MomentInterval.ordinalFormat(false);
    private static final ChronoFormatter<Moment> BAS_W = MomentInterval.weekdateFormat(false);
    private static final Comparator<ChronoInterval<Moment>> COMPARATOR = new IntervalComparator<Moment>(false, (TimeLine<Moment>)Moment.axis());

    MomentInterval(Boundary<Moment> boundary, Boundary<Moment> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<Moment>> comparator() {
        return COMPARATOR;
    }

    public static MomentInterval between(Moment moment, Moment moment2) {
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), Boundary.of(IntervalEdge.OPEN, moment2));
    }

    public static MomentInterval between(Instant instant, Instant instant2) {
        return MomentInterval.between(Moment.from((Instant)instant), Moment.from((Instant)instant2));
    }

    public static MomentInterval since(Moment moment) {
        Boundary<Moment> boundary = Boundary.infiniteFuture();
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), boundary);
    }

    public static MomentInterval since(Instant instant) {
        return MomentInterval.since(Moment.from((Instant)instant));
    }

    public static MomentInterval until(Moment moment) {
        Boundary<Moment> boundary = Boundary.infinitePast();
        return new MomentInterval(boundary, Boundary.of(IntervalEdge.OPEN, moment));
    }

    public static MomentInterval until(Instant instant) {
        return MomentInterval.until(Moment.from((Instant)instant));
    }

    public Moment getStartAsMoment() {
        return (Moment)this.getStart().getTemporal();
    }

    public Instant getStartAsInstant() {
        Moment moment = this.getStartAsMoment();
        return moment == null ? null : moment.toTemporalAccessor();
    }

    public Moment getEndAsMoment() {
        return (Moment)this.getEnd().getTemporal();
    }

    public Instant getEndAsInstant() {
        Moment moment = this.getEndAsMoment();
        return moment == null ? null : moment.toTemporalAccessor();
    }

    public TimestampInterval toLocalInterval() {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toLocalTimestamp();
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toLocalTimestamp();
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(TZID tZID) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(tZID);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(tZID);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(String string) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(string);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(string);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public Duration<IsoUnit> getNominalDuration(Timezone timezone, IsoUnit ... isoUnitArray) {
        return this.toZonalInterval(timezone.getID()).getDuration(timezone, isoUnitArray);
    }

    public MachineTime<TimeUnit> getSimpleDuration() {
        boolean bl;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = moment == null;
        if (bl) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime machineTime = (MachineTime)MachineTime.ON_POSIX_SCALE.between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)moment);
        if (bl) {
            return machineTime.plus(1L, TimeUnit.NANOSECONDS);
        }
        return machineTime;
    }

    public MachineTime<SI> getRealDuration() {
        boolean bl;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = moment == null;
        if (bl) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime machineTime = (MachineTime)MachineTime.ON_UTC_SCALE.between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)moment);
        if (bl) {
            return machineTime.plus(1L, SI.NANOSECONDS);
        }
        return machineTime;
    }

    public MomentInterval move(long l, TimeUnit timeUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), (Temporal)((Moment)this.getStart().getTemporal()).plus(l, (Object)timeUnit));
        Boundary<Object> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), (Temporal)((Moment)this.getEnd().getTemporal()).plus(l, (Object)timeUnit));
        return new MomentInterval((Boundary<Moment>)boundary, (Boundary<Moment>)boundary2);
    }

    public MomentInterval move(long l, SI sI) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((Moment)this.getStart().getTemporal()).plus(l, sI));
        Boundary<Moment> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((Moment)this.getEnd().getTemporal()).plus(l, sI));
        return new MomentInterval((Boundary<Moment>)boundary, boundary2);
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser) throws ParseException {
        return MomentInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser, String string2) throws ParseException {
        ParseLog parseLog = new ParseLog();
        MomentInterval momentInterval = IntervalParser.parseCustom(string, MomentIntervalFactory.INSTANCE, chronoParser, string2, parseLog);
        if (parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (momentInterval == null) {
            throw new ParseException("Parsing of interval failed: " + string, parseLog.getPosition());
        }
        return momentInterval;
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, char c, ChronoParser<Moment> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c, null).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static MomentInterval parseISO(String string) throws ParseException {
        char c;
        int n;
        int n2;
        int n3;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = Math.min(string.length(), 83);
        boolean bl2 = true;
        int n7 = 0;
        block0: for (n3 = 1; n3 < n6; ++n3) {
            if (string.charAt(n3) != '/') continue;
            if (string.charAt(0) == 'P') {
                n5 = n3 + 1;
                n7 = n6 - n3 - 1;
                bl = true;
                break;
            }
            if (n3 + 1 < n6 && string.charAt(n3 + 1) == 'P') {
                n7 = n3;
                bl = true;
                break;
            }
            bl2 = 2 * n3 + 1 == n6 && MomentInterval.hasSameOffsets(string, n3, n6);
            n7 = n3;
            n4 = n6 - n3 - 1;
            for (n2 = n3 + 1; n2 < n6; ++n2) {
                if (string.charAt(n2) != 'T') continue;
                n4 = n6 - n2;
                bl = true;
                break block0;
            }
            break;
        }
        n3 = 0;
        n2 = 0;
        boolean bl3 = false;
        int n8 = 0;
        for (n = n5; n < n6 && (c = string.charAt(n)) != '/'; ++n) {
            if (c == 'T' || n8 > 0) {
                ++n8;
                continue;
            }
            if (c == '-') {
                ++n3;
                continue;
            }
            if (c != 'W') continue;
            bl3 = true;
        }
        int n9 = n = n3 > 0 ? 1 : 0;
        if (!bl3) {
            int n10 = n2 = n3 == 1 || n3 == 0 && n7 - n8 == 7 ? 1 : 0;
        }
        ChronoFormatter<Moment> chronoFormatter = n2 != 0 ? (n != 0 ? EXT_O : BAS_O) : (bl3 ? (n != 0 ? EXT_W : BAS_W) : (n != 0 ? EXT_C : BAS_C));
        ChronoFormatter<Moment> chronoFormatter2 = bl2 ? chronoFormatter : MomentInterval.abbreviatedFormat(n != 0, bl3, n2 != 0, n4, bl);
        return IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoFormatter, chronoFormatter2, BracketPolicy.SHOW_NEVER, '/', Moment.axis()).parse(string);
    }

    @Override
    TimeLine<Moment> getTimeLine() {
        return Moment.axis();
    }

    @Override
    IntervalFactory<Moment, MomentInterval> getFactory() {
        return MomentIntervalFactory.INSTANCE;
    }

    @Override
    MomentInterval getContext() {
        return this;
    }

    private static boolean hasSameOffsets(String string, int n, int n2) {
        if (string.charAt(n - 1) == 'Z') {
            return string.charAt(n2 - 1) == 'Z';
        }
        for (int i = n - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c != '+' && c != '-') continue;
            int n3 = i + n2 - n;
            if (n3 < 0) break;
            char c2 = string.charAt(n3);
            return c2 == '+' || c2 == '-';
        }
        return false;
    }

    private static ChronoFormatter<Moment> calendarFormat(boolean bl) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.class, (Locale)Locale.ROOT);
        builder.addInteger((ChronoElement)PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2);
        builder.addLiteral('T');
        MomentInterval.addWallTime(builder, bl);
        MomentInterval.addOffset(builder, bl);
        return builder.build();
    }

    private static ChronoFormatter<Moment> ordinalFormat(boolean bl) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.class, (Locale)Locale.ROOT);
        builder.addInteger((ChronoElement)PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3).build();
        builder.addLiteral('T');
        MomentInterval.addWallTime(builder, bl);
        MomentInterval.addOffset(builder, bl);
        return builder.build();
    }

    private static ChronoFormatter<Moment> weekdateFormat(boolean bl) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.class, (Locale)Locale.ROOT);
        builder.addInteger((ChronoElement)PlainDate.YEAR_OF_WEEKDATE, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addLiteral('W');
        builder.addFixedInteger((ChronoElement)Weekmodel.ISO.weekOfYear(), 2);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1).build();
        builder.addLiteral('T');
        MomentInterval.addWallTime(builder, bl);
        MomentInterval.addOffset(builder, bl);
        return builder.build();
    }

    private static ChronoFormatter<Moment> abbreviatedFormat(boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        AdjustableElement adjustableElement;
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.class, (Locale)Locale.ROOT);
        AdjustableElement adjustableElement2 = adjustableElement = bl2 ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
        if (bl) {
            int n2 = (bl3 ? 3 : 5) + n;
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n2);
            builder.addCustomized((ChronoElement)adjustableElement, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(bl2 ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR));
        } else {
            int n3 = (bl3 ? 3 : 4) + n;
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n3);
            builder.addInteger((ChronoElement)adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        }
        builder.endSection();
        if (bl2) {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, 1 + n);
            builder.addCustomized((ChronoElement)Weekmodel.ISO.weekOfYear(), (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(bl ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR));
            builder.endSection();
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1);
            builder.endSection();
        } else if (bl3) {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3);
            builder.endSection();
        } else {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, 2 + n);
            if (bl) {
                builder.addCustomized((ChronoElement)PlainDate.MONTH_AS_NUMBER, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)FixedNumParser.CALENDAR_MONTH);
            } else {
                builder.addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2);
            }
            builder.endSection();
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2);
            builder.endSection();
        }
        if (bl4) {
            builder.addLiteral('T');
        }
        MomentInterval.addWallTime(builder, bl);
        builder.startOptionalSection();
        MomentInterval.addOffset(builder, bl);
        builder.endSection();
        return builder.build();
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean bl) {
        builder.addCustomized((ChronoElement)PlainTime.COMPONENT, bl ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
    }

    private static <T extends ChronoEntity<T>> void addOffset(ChronoFormatter.Builder<T> builder, boolean bl) {
        builder.addTimezoneOffset(DisplayMode.SHORT, bl, Collections.singletonList("Z"));
    }

    private Object writeReplace() {
        return new SPX(this, 35);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

