/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Locale;
import net.time4j.AdjustableElement;
import net.time4j.CalendarUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.DateIntervalFactory;
import net.time4j.range.FixedNumParser;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.NoopPrinter;
import net.time4j.range.SPX;
import net.time4j.range.TimestampInterval;
import net.time4j.range.YearParser;

public final class DateInterval
extends IsoInterval<PlainDate, DateInterval>
implements Serializable {
    private static final long serialVersionUID = 8074261825266036014L;
    private static final Comparator<ChronoInterval<PlainDate>> COMPARATOR = new IntervalComparator<PlainDate>(true, (TimeLine<PlainDate>)PlainDate.axis());

    DateInterval(Boundary<PlainDate> boundary, Boundary<PlainDate> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<PlainDate>> comparator() {
        return COMPARATOR;
    }

    public static DateInterval between(PlainDate plainDate, PlainDate plainDate2) {
        return new DateInterval(Boundary.of(IntervalEdge.CLOSED, plainDate), Boundary.of(IntervalEdge.CLOSED, plainDate2));
    }

    public static DateInterval since(PlainDate plainDate) {
        Boundary<PlainDate> boundary = Boundary.infiniteFuture();
        return new DateInterval(Boundary.of(IntervalEdge.CLOSED, plainDate), boundary);
    }

    public static DateInterval until(PlainDate plainDate) {
        Boundary<PlainDate> boundary = Boundary.infinitePast();
        return new DateInterval(boundary, Boundary.of(IntervalEdge.CLOSED, plainDate));
    }

    public static DateInterval atomic(PlainDate plainDate) {
        return DateInterval.between(plainDate, plainDate);
    }

    public TimestampInterval toFullDays() {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        PlainDate plainDate;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainDate = (PlainDate)this.getStart().getTemporal();
            plainTimestamp = this.getStart().isOpen() ? plainDate.at(PlainTime.midnightAtEndOfDay()) : plainDate.atStartOfDay();
            boundary2 = Boundary.of(IntervalEdge.CLOSED, plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainDate = (PlainDate)this.getEnd().getTemporal();
            plainTimestamp = this.getEnd().isOpen() ? plainDate.atStartOfDay() : plainDate.at(PlainTime.midnightAtEndOfDay());
            boundary = Boundary.of(IntervalEdge.OPEN, plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public long getLengthInDays() {
        if (this.isFinite()) {
            long l = CalendarUnit.DAYS.between((TimePoint)this.getStart().getTemporal(), (TimePoint)this.getEnd().getTemporal());
            if (this.getStart().isOpen()) {
                --l;
            }
            if (this.getEnd().isClosed()) {
                ++l;
            }
            return l;
        }
        throw new UnsupportedOperationException("An infinite interval has no finite duration.");
    }

    public Duration<CalendarUnit> getDurationInYearsMonthsDays() {
        boolean bl;
        PlainDate plainDate = (PlainDate)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainDate == null;
        if (bl) {
            plainDate = (PlainDate)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.inYearsMonthsDays().between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)plainDate);
        if (bl) {
            return duration.plus(1L, (IsoUnit)CalendarUnit.DAYS);
        }
        return duration;
    }

    public Duration<CalendarUnit> getDuration(CalendarUnit ... calendarUnitArray) {
        boolean bl;
        PlainDate plainDate = (PlainDate)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainDate == null;
        if (bl) {
            plainDate = (PlainDate)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.in((IsoUnit[])calendarUnitArray).between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)plainDate);
        if (bl) {
            return duration.plus(1L, (IsoUnit)CalendarUnit.DAYS);
        }
        return duration;
    }

    public DateInterval move(long l, CalendarUnit calendarUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), (Temporal)((PlainDate)this.getStart().getTemporal()).plus(l, (Object)calendarUnit));
        Boundary<Object> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), (Temporal)((PlainDate)this.getEnd().getTemporal()).plus(l, (Object)calendarUnit));
        return new DateInterval((Boundary<PlainDate>)boundary, (Boundary<PlainDate>)boundary2);
    }

    public static DateInterval parse(String string, ChronoParser<PlainDate> chronoParser) throws ParseException {
        return IntervalParser.of(DateIntervalFactory.INSTANCE, chronoParser, BracketPolicy.SHOW_WHEN_NON_STANDARD).parse(string);
    }

    public static DateInterval parse(CharSequence charSequence, ChronoParser<PlainDate> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (DateInterval)IntervalParser.of(DateIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static DateInterval parseISO(String string) throws ParseException {
        int n;
        int n2;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n3 = 0;
        int n4 = Math.min(string.length(), 33);
        boolean bl = true;
        int n5 = 0;
        for (n2 = 1; n2 < n4; ++n2) {
            if (string.charAt(n2) != '/') continue;
            if (string.charAt(0) == 'P') {
                n3 = n2 + 1;
                n5 = n4 - n2 - 1;
                break;
            }
            if (n2 + 1 < n4 && string.charAt(n2 + 1) == 'P') {
                n5 = n2;
                break;
            }
            bl = 2 * n2 + 1 == n4;
            n5 = n2;
            break;
        }
        n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = n3; n < n4; ++n) {
            char c = string.charAt(n);
            if (c == '-') {
                ++n2;
                continue;
            }
            if (c == 'W') {
                bl3 = true;
                break;
            }
            if (c == '/') break;
        }
        int n6 = n = n2 > 0 ? 1 : 0;
        if (!bl3) {
            boolean bl4 = bl2 = n2 == 1 || n2 == 0 && n5 == 7;
        }
        ChronoFormatter chronoFormatter = n != 0 ? (bl2 ? Iso8601Format.EXTENDED_ORDINAL_DATE : (bl3 ? Iso8601Format.EXTENDED_WEEK_DATE : Iso8601Format.EXTENDED_CALENDAR_DATE)) : (bl2 ? Iso8601Format.BASIC_ORDINAL_DATE : (bl3 ? Iso8601Format.BASIC_WEEK_DATE : Iso8601Format.BASIC_CALENDAR_DATE));
        ChronoFormatter chronoFormatter2 = bl ? chronoFormatter : DateInterval.abbreviatedFormat(n != 0, bl3, bl2);
        return IntervalParser.of(DateIntervalFactory.INSTANCE, chronoFormatter, chronoFormatter2, BracketPolicy.SHOW_NEVER, PlainDate.axis()).parse(string);
    }

    @Override
    TimeLine<PlainDate> getTimeLine() {
        return PlainDate.axis();
    }

    @Override
    IntervalFactory<PlainDate, DateInterval> getFactory() {
        return DateIntervalFactory.INSTANCE;
    }

    @Override
    DateInterval getContext() {
        return this;
    }

    private static ChronoFormatter<PlainDate> abbreviatedFormat(boolean bl, boolean bl2, boolean bl3) {
        AdjustableElement adjustableElement;
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(PlainDate.class, (Locale)Locale.ROOT);
        AdjustableElement adjustableElement2 = adjustableElement = bl2 ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
        if (bl) {
            int n = bl3 ? 3 : 5;
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addCustomized((ChronoElement)adjustableElement, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(bl2 ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR));
        } else {
            int n = bl3 ? 3 : 4;
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addInteger((ChronoElement)adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        }
        builder.endSection();
        if (bl2) {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, 1);
            builder.addCustomized((ChronoElement)Weekmodel.ISO.weekOfYear(), (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(bl ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR));
            builder.endSection();
            builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1);
        } else if (bl3) {
            builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3);
        } else {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, 2);
            if (bl) {
                builder.addCustomized((ChronoElement)PlainDate.MONTH_AS_NUMBER, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)FixedNumParser.CALENDAR_MONTH);
            } else {
                builder.addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2);
            }
            builder.endSection();
            builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2);
        }
        return builder.build();
    }

    private Object writeReplace() {
        return new SPX(this, 32);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

