/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.util.Locale;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.ValueInterval;

public abstract class IsoInterval<T extends Temporal<? super T>, I extends IsoInterval<T, I>>
implements ChronoInterval<T> {
    private static final ChronoFunction<ChronoDisplay, Void> NO_RESULT = new ChronoFunction<ChronoDisplay, Void>(){

        public Void apply(ChronoDisplay chronoDisplay) {
            return null;
        }
    };
    private final Boundary<T> start;
    private final Boundary<T> end;

    IsoInterval(Boundary<T> boundary, Boundary<T> boundary2) {
        if (Boundary.isAfter(boundary, boundary2)) {
            throw new IllegalArgumentException("Start after end: " + boundary + "/" + boundary2);
        }
        if (boundary2.isOpen() && boundary.isOpen() && Boundary.isSimultaneous(boundary, boundary2)) {
            if (boundary.isInfinite()) {
                throw new IllegalArgumentException("Infinite boundaries must not be equal.");
            }
            throw new IllegalArgumentException("Open start equal to open end: " + boundary + "/" + boundary2);
        }
        this.start = boundary;
        this.end = boundary2;
    }

    @Override
    public final Boundary<T> getStart() {
        return this.start;
    }

    @Override
    public final Boundary<T> getEnd() {
        return this.end;
    }

    public I withStart(T t) {
        IntervalEdge intervalEdge = this.start.getEdge();
        Boundary<T> boundary = Boundary.of(intervalEdge, t);
        return (I)((IsoInterval)this.getFactory().between(boundary, this.end));
    }

    public I withEnd(T t) {
        IntervalEdge intervalEdge = this.end.getEdge();
        Boundary<T> boundary = Boundary.of(intervalEdge, t);
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    public I withStart(ChronoOperator<T> chronoOperator) {
        if (this.start.isInfinite()) {
            throw new IllegalStateException("Operator cannot be applied on an infinite interval boundary.");
        }
        IntervalEdge intervalEdge = this.start.getEdge();
        Boundary<Object> boundary = Boundary.of(intervalEdge, chronoOperator.apply(this.start.getTemporal()));
        return (I)((IsoInterval)this.getFactory().between(boundary, this.end));
    }

    public I withEnd(ChronoOperator<T> chronoOperator) {
        if (this.end.isInfinite()) {
            throw new IllegalStateException("Operator cannot be applied on an infinite interval boundary.");
        }
        IntervalEdge intervalEdge = this.end.getEdge();
        Boundary<Object> boundary = Boundary.of(intervalEdge, chronoOperator.apply(this.end.getTemporal()));
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    public I withOpenEnd() {
        Boundary boundary = this.end.isInfinite() ? Boundary.infiniteFuture() : Boundary.of(IntervalEdge.OPEN, this.end.getTemporal());
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    public I withClosedEnd() {
        if (this.getEnd().isInfinite()) {
            throw new IllegalStateException("Infinite future cannot be included.");
        }
        Boundary<T> boundary = Boundary.of(IntervalEdge.CLOSED, this.getEnd().getTemporal());
        return (I)((IsoInterval)this.getFactory().between(this.start, boundary));
    }

    @Override
    public boolean isFinite() {
        return !this.start.isInfinite() && !this.end.isInfinite();
    }

    @Override
    public boolean isEmpty() {
        if (!this.isFinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.start.getTemporal();
        Temporal temporal2 = (Temporal)this.end.getTemporal();
        if (this.start.isOpen()) {
            if (this.end.isClosed()) {
                return temporal.isSimultaneous((Object)temporal2);
            }
            temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal);
            if (temporal == null) {
                return false;
            }
        }
        return this.end.isOpen() && temporal.isSimultaneous((Object)temporal2);
    }

    @Override
    public boolean isBefore(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (this.end.isOpen()) {
            return !temporal.isAfter(t);
        }
        return temporal.isBefore(t);
    }

    @Override
    public boolean isBefore(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        T t = IsoInterval.getClosedFiniteStart(chronoInterval.getStart(), this.getTimeLine());
        if (t == null) {
            return true;
        }
        if (this.end.isOpen()) {
            return !temporal.isAfter(t);
        }
        return temporal.isBefore(t);
    }

    @Override
    public boolean isAfter(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            return false;
        }
        return this.getClosedFiniteStart().isAfter(t);
    }

    @Override
    public boolean isAfter(ChronoInterval<T> chronoInterval) {
        return chronoInterval.isBefore(this);
    }

    @Override
    public boolean contains(T t) {
        boolean bl;
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            bl = true;
        } else if (this.start.isOpen()) {
            bl = ((Temporal)this.start.getTemporal()).isBefore(t);
        } else {
            boolean bl2 = bl = !((Temporal)this.start.getTemporal()).isAfter(t);
        }
        if (!bl) {
            return false;
        }
        boolean bl3 = this.end.isInfinite() ? true : (this.end.isOpen() ? ((Temporal)this.end.getTemporal()).isAfter(t) : !((Temporal)this.end.getTemporal()).isBefore(t));
        return bl3;
    }

    @Override
    public boolean contains(ChronoInterval<T> chronoInterval) {
        if (!chronoInterval.isFinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = IsoInterval.getClosedFiniteStart(chronoInterval.getStart(), this.getTimeLine());
        if (t2 == null || t != null && t.isAfter(t2)) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)chronoInterval.getEnd().getTemporal();
        if (temporal == null) {
            return true;
        }
        if (chronoInterval.getEnd().isOpen() && t2.isSimultaneous((Object)temporal2)) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (temporal == null || t2.isAfter((Object)temporal)) {
                return false;
            }
        } else if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (chronoInterval.getEnd().isOpen()) {
                temporal2 = (Temporal)this.getTimeLine().stepBackwards((Object)temporal2);
            }
            if (temporal == null || temporal2 == null || temporal.isBefore((Object)temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed() && (temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal)) == null) {
                return true;
            }
            if (chronoInterval.getEnd().isClosed() && (temporal2 = (Temporal)this.getTimeLine().stepForward((Object)temporal2)) == null) {
                return false;
            }
            return !temporal.isBefore((Object)temporal2);
        }
        return true;
    }

    public I collapse() {
        if (this.start.isInfinite()) {
            throw new IllegalStateException("An interval with infinite past cannot be collapsed.");
        }
        T t = this.getClosedFiniteStart();
        Boundary<T> boundary = Boundary.ofClosed(t);
        Boundary<T> boundary2 = Boundary.ofOpen(t);
        return (I)((IsoInterval)this.getFactory().between(boundary, boundary2));
    }

    public I toCanonical() {
        Temporal temporal;
        boolean bl = false;
        Boundary<Object> boundary = this.start;
        Boundary<Object> boundary2 = this.end;
        if (!this.start.isInfinite() && this.start.isOpen()) {
            temporal = (Temporal)this.getTimeLine().stepForward(this.start.getTemporal());
            if (temporal == null) {
                throw new IllegalStateException("Cannot canonicalize this interval: " + this);
            }
            boundary = Boundary.ofClosed(temporal);
            bl = true;
        }
        if (!this.end.isInfinite()) {
            if (this.getFactory().isCalendrical()) {
                if (this.end.isOpen()) {
                    temporal = (Temporal)this.getTimeLine().stepBackwards(this.end.getTemporal());
                    if (temporal == null) {
                        throw new IllegalStateException("Cannot canonicalize this interval: " + this);
                    }
                    boundary2 = Boundary.ofClosed(temporal);
                    bl = true;
                }
            } else if (this.end.isClosed()) {
                temporal = (Temporal)this.getTimeLine().stepForward(this.end.getTemporal());
                if (temporal == null) {
                    throw new IllegalStateException("Cannot canonicalize this interval: " + this);
                }
                boundary2 = Boundary.ofOpen(temporal);
                bl = true;
            }
        }
        return (I)(bl ? (IsoInterval)this.getFactory().between(boundary, boundary2) : this.getContext());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IsoInterval) {
            IsoInterval isoInterval = (IsoInterval)IsoInterval.class.cast(object);
            return this.start.equals(isoInterval.start) && this.end.equals(isoInterval.end) && this.getTimeLine().equals(isoInterval.getTimeLine());
        }
        return false;
    }

    public final int hashCode() {
        return 17 * this.start.hashCode() + 37 * this.end.hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.start.isOpen() ? (char)'(' : '[');
        stringBuilder.append((Object)(this.start.isInfinite() ? "-\u221e" : this.start.getTemporal()));
        stringBuilder.append('/');
        stringBuilder.append((Object)(this.end.isInfinite() ? "+\u221e" : this.end.getTemporal()));
        stringBuilder.append(this.end.isOpen() ? (char)')' : ']');
        return stringBuilder.toString();
    }

    public String print(ChronoPrinter<T> chronoPrinter) {
        return this.print(chronoPrinter, IsoInterval.getIntervalPattern(chronoPrinter));
    }

    public String print(ChronoPrinter<T> chronoPrinter, String string) {
        I i = this.toCanonical();
        AttributeQuery attributeQuery = IsoInterval.extractDefaultAttributes(chronoPrinter);
        StringBuilder stringBuilder = new StringBuilder(32);
        int n = 0;
        int n2 = string.length();
        try {
            while (n < n2) {
                char c = string.charAt(n);
                if (c == '{' && n + 2 < n2 && string.charAt(n + 2) == '}') {
                    char c2 = string.charAt(n + 1);
                    if (c2 == '0') {
                        if (((IsoInterval)i).getStart().isInfinite()) {
                            stringBuilder.append("-\u221e");
                        } else {
                            chronoPrinter.print(((IsoInterval)i).getStart().getTemporal(), (Appendable)stringBuilder, attributeQuery, NO_RESULT);
                        }
                        n += 3;
                        continue;
                    }
                    if (c2 == '1') {
                        if (((IsoInterval)i).getEnd().isInfinite()) {
                            stringBuilder.append("+\u221e");
                        } else {
                            chronoPrinter.print(((IsoInterval)i).getEnd().getTemporal(), (Appendable)stringBuilder, attributeQuery, NO_RESULT);
                        }
                        n += 3;
                        continue;
                    }
                }
                stringBuilder.append(c);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    public String print(ChronoPrinter<T> chronoPrinter, BracketPolicy bracketPolicy) {
        try {
            StringBuilder stringBuilder = new StringBuilder(64);
            this.print(chronoPrinter, '/', chronoPrinter, bracketPolicy, stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public void print(ChronoPrinter<T> chronoPrinter, char c, ChronoPrinter<T> chronoPrinter2, BracketPolicy bracketPolicy, Appendable appendable) throws IOException {
        I i = this.getContext();
        if (bracketPolicy == BracketPolicy.SHOW_NEVER) {
            i = this.toCanonical();
        }
        AttributeQuery attributeQuery = IsoInterval.extractDefaultAttributes(chronoPrinter);
        boolean bl = bracketPolicy.display(this);
        if (bl) {
            appendable.append(((IsoInterval)i).getStart().isOpen() ? (char)'(' : '[');
        }
        if (((IsoInterval)i).getStart().isInfinite()) {
            appendable.append("-\u221e");
        } else {
            chronoPrinter.print(((IsoInterval)i).getStart().getTemporal(), appendable, attributeQuery, NO_RESULT);
        }
        appendable.append(c);
        if (((IsoInterval)i).getEnd().isInfinite()) {
            appendable.append("+\u221e");
        } else {
            chronoPrinter2.print(((IsoInterval)i).getEnd().getTemporal(), appendable, attributeQuery, NO_RESULT);
        }
        if (bl) {
            appendable.append(((IsoInterval)i).getEnd().isOpen() ? (char)')' : ']');
        }
    }

    public boolean equivalentTo(I i) {
        if (this.getContext() == i) {
            return true;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t == null) {
            if (t2 != null) {
                return false;
            }
        } else {
            if (t2 == null) {
                return false;
            }
            if (!t.isSimultaneous(t2)) {
                return false;
            }
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (temporal == null) {
            return temporal2 == null;
        }
        if (temporal2 == null) {
            return false;
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = (Temporal)this.getTimeLine().stepBackwards((Object)temporal2);
            }
        } else {
            if (this.end.isClosed()) {
                temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal);
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = (Temporal)this.getTimeLine().stepForward((Object)temporal2);
            }
        }
        if (temporal == null) {
            return temporal2 == null;
        }
        if (temporal2 == null) {
            return false;
        }
        return temporal.isSimultaneous((Object)temporal2);
    }

    public boolean precedes(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (this.end.isClosed() && (temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal)) == null) {
            return false;
        }
        return temporal.isBefore(((IsoInterval)i).getClosedFiniteStart());
    }

    public boolean precededBy(I i) {
        return ((IsoInterval)i).precedes(this.getContext());
    }

    public boolean meets(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (this.end.isClosed() && (temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal)) == null) {
            return false;
        }
        if (temporal.isSimultaneous(((IsoInterval)i).getClosedFiniteStart())) {
            T t = this.getClosedFiniteStart();
            Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
            if (t == null || temporal2 == null) {
                return true;
            }
            return t.isBefore((Object)temporal2);
        }
        return false;
    }

    public boolean metBy(I i) {
        return ((IsoInterval)i).meets(this.getContext());
    }

    public boolean overlaps(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t != null && !t.isBefore(t2)) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (temporal == null || temporal.isBefore(t2)) {
                return false;
            }
            if (temporal2 == null) {
                return true;
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = (Temporal)this.getTimeLine().stepBackwards((Object)temporal2);
            }
        } else {
            if (this.end.isClosed() && (temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal)) == null) {
                return temporal2 == null;
            }
            if (!temporal.isAfter(t2)) {
                return false;
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = (Temporal)this.getTimeLine().stepForward((Object)temporal2);
            }
        }
        return temporal2 == null || temporal.isBefore((Object)temporal2);
    }

    public boolean overlappedBy(I i) {
        return ((IsoInterval)i).overlaps(this.getContext());
    }

    public boolean finishes(I i) {
        boolean bl;
        if (this.start.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        boolean bl2 = bl = this.end.isOpen() && temporal != null && t.isSimultaneous((Object)temporal);
        if (bl || t2 != null && !t2.isBefore(t)) {
            return false;
        }
        if (temporal2 == null) {
            return temporal == null;
        }
        if (temporal == null) {
            return temporal2 == null;
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = (Temporal)this.getTimeLine().stepBackwards((Object)temporal2);
            }
            if (temporal == null || temporal2 == null || t.isAfter((Object)temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed()) {
                temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal);
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = (Temporal)this.getTimeLine().stepForward((Object)temporal2);
            }
            if (temporal2 != null && !t.isBefore((Object)temporal2)) {
                return false;
            }
            if (temporal == null) {
                return temporal2 == null;
            }
            if (temporal2 == null) {
                return false;
            }
        }
        return temporal.isSimultaneous((Object)temporal2);
    }

    public boolean finishedBy(I i) {
        return ((IsoInterval)i).finishes(this.getContext());
    }

    public boolean starts(I i) {
        if (this.end.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t2 == null ? t != null : (t == null ? t2 != null : !t.isSimultaneous(t2))) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (this.end.isOpen() && t != null && t.isSimultaneous((Object)temporal)) {
            return true;
        }
        if (temporal2 == null) {
            if (this.end.isClosed()) {
                return true;
            }
            if (t2 == null) {
                return this.getTimeLine().stepBackwards((Object)temporal) != null;
            }
            return temporal.isAfter(t2);
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = (Temporal)this.getTimeLine().stepBackwards((Object)temporal2);
            }
            if (temporal == null || temporal2 == null || !temporal.isBefore((Object)temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed() && (temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal)) == null) {
                return false;
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                temporal2 = (Temporal)this.getTimeLine().stepForward((Object)temporal2);
            }
            if (temporal2 != null && !temporal.isBefore((Object)temporal2)) {
                return false;
            }
        }
        if (this.end.isClosed()) {
            return true;
        }
        if (t2 == null) {
            return this.getTimeLine().stepBackwards((Object)temporal) != null;
        }
        return temporal.isAfter(t2);
    }

    public boolean startedBy(I i) {
        return ((IsoInterval)i).starts(this.getContext());
    }

    public boolean encloses(I i) {
        if (!((IsoInterval)i).isFinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t != null && !t.isBefore(t2)) {
            return false;
        }
        Temporal temporal = (Temporal)this.end.getTemporal();
        Temporal temporal2 = (Temporal)((IsoInterval)i).getEnd().getTemporal();
        if (temporal == null) {
            return true;
        }
        if (((IsoInterval)i).getEnd().isOpen() && t2.isSimultaneous((Object)temporal2)) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (temporal == null || t2.isAfter((Object)temporal)) {
                return false;
            }
        } else if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                temporal = (Temporal)this.getTimeLine().stepBackwards((Object)temporal);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                temporal2 = (Temporal)this.getTimeLine().stepBackwards((Object)temporal2);
            }
            if (temporal == null || temporal2 == null || !temporal.isAfter((Object)temporal2)) {
                return false;
            }
        } else {
            if (this.end.isClosed()) {
                temporal = (Temporal)this.getTimeLine().stepForward((Object)temporal);
            }
            if (((IsoInterval)i).getEnd().isClosed() && (temporal2 = (Temporal)this.getTimeLine().stepForward((Object)temporal2)) == null) {
                return false;
            }
            if (temporal != null && !temporal.isAfter((Object)temporal2)) {
                return false;
            }
        }
        return true;
    }

    public boolean enclosedBy(I i) {
        return ((IsoInterval)i).encloses(this.getContext());
    }

    @Override
    public boolean intersects(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        return !this.isBefore(chronoInterval) && !this.isAfter(chronoInterval);
    }

    @Override
    public boolean abuts(ChronoInterval<T> chronoInterval) {
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = IsoInterval.getClosedFiniteStart(chronoInterval.getStart(), this.getTimeLine());
        T t3 = this.getOpenFiniteEnd();
        T t4 = IsoInterval.getOpenFiniteEnd(chronoInterval.getEnd(), this.getTimeLine());
        if (t3 == null || t2 == null) {
            return t != null && t4 != null && t.isSimultaneous(t4);
        }
        if (t == null || t4 == null) {
            return t3.isSimultaneous(t2);
        }
        return t3.isSimultaneous(t2) ^ t.isSimultaneous(t4);
    }

    public <V> ValueInterval<T, I, V> withValue(V v) {
        return new ValueInterval(this.getContext(), v);
    }

    abstract IntervalFactory<T, I> getFactory();

    T getTemporalOfClosedStart() {
        Temporal temporal = (Temporal)this.start.getTemporal();
        if (temporal == null) {
            throw new UnsupportedOperationException("An infinite interval has no finite duration.");
        }
        if (this.start.isOpen()) {
            return (T)((Temporal)this.getTimeLine().stepForward((Object)temporal));
        }
        return (T)temporal;
    }

    T getTemporalOfOpenEnd() {
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (temporal == null) {
            throw new UnsupportedOperationException("An infinite interval has no finite duration.");
        }
        if (this.end.isClosed()) {
            return (T)((Temporal)this.getTimeLine().stepForward((Object)temporal));
        }
        return (T)temporal;
    }

    T getClosedFiniteStart() {
        Temporal temporal = (Temporal)this.start.getTemporal();
        if (temporal != null && this.start.isOpen()) {
            return (T)((Temporal)this.getTimeLine().stepForward((Object)temporal));
        }
        return (T)temporal;
    }

    T getClosedFiniteEnd() {
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (temporal != null && this.end.isOpen()) {
            return (T)((Temporal)this.getTimeLine().stepBackwards((Object)temporal));
        }
        return (T)temporal;
    }

    T getOpenFiniteEnd() {
        Temporal temporal = (Temporal)this.end.getTemporal();
        if (temporal != null && this.end.isClosed()) {
            return (T)((Temporal)this.getTimeLine().stepForward((Object)temporal));
        }
        return (T)temporal;
    }

    static AttributeQuery extractDefaultAttributes(Object object) {
        if (object instanceof ChronoFormatter) {
            ChronoFormatter chronoFormatter = (ChronoFormatter)ChronoFormatter.class.cast(object);
            return chronoFormatter.getAttributes();
        }
        return Attributes.empty();
    }

    static String getIntervalPattern(Object object) {
        String string = "{0}/{1}";
        if (object instanceof ChronoFormatter) {
            Locale locale = ((ChronoFormatter)ChronoFormatter.class.cast(object)).getLocale();
            string = CalendarText.patternForInterval((Locale)locale);
        }
        return string;
    }

    abstract I getContext();

    private static <T extends Temporal<? super T>> T getClosedFiniteStart(Boundary<T> boundary, TimeLine<T> timeLine) {
        Temporal temporal = (Temporal)boundary.getTemporal();
        if (temporal != null && boundary.isOpen()) {
            return (T)((Temporal)timeLine.stepForward((Object)temporal));
        }
        return (T)temporal;
    }

    private static <T extends Temporal<? super T>> T getOpenFiniteEnd(Boundary<T> boundary, TimeLine<T> timeLine) {
        Temporal temporal = (Temporal)boundary.getTemporal();
        if (temporal != null && boundary.isClosed()) {
            return (T)((Temporal)timeLine.stepForward((Object)temporal));
        }
        return (T)temporal;
    }

    private TimeLine<T> getTimeLine() {
        return this.getFactory().getTimeLine();
    }
}

