/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.Temporal;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IsoInterval;

class IntervalParser<T extends Temporal<? super T>, I extends IsoInterval<T, I>>
implements ChronoParser<I> {
    private final IntervalFactory<T, I> factory;
    private final ChronoParser<T> startFormat;
    private final ChronoParser<T> endFormat;
    private final BracketPolicy policy;
    private final Character separator;

    IntervalParser(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, ChronoParser<T> chronoParser2, BracketPolicy bracketPolicy, Character c) {
        if (bracketPolicy == null) {
            throw new NullPointerException("Missing bracket policy.");
        }
        this.factory = intervalFactory;
        this.startFormat = chronoParser;
        this.endFormat = chronoParser2;
        this.policy = bracketPolicy;
        this.separator = c;
    }

    static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalParser<T, I> of(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, BracketPolicy bracketPolicy) {
        if (chronoParser == null) {
            throw new NullPointerException("Missing boundary parser.");
        }
        return new IntervalParser<T, I>(intervalFactory, chronoParser, chronoParser, bracketPolicy, null);
    }

    static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalParser<T, I> of(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, ChronoParser<T> chronoParser2, BracketPolicy bracketPolicy, char c) {
        if (chronoParser == null) {
            throw new NullPointerException("Missing start boundary parser.");
        }
        if (chronoParser2 == null) {
            throw new NullPointerException("Missing end boundary parser.");
        }
        return new IntervalParser<T, I>(intervalFactory, chronoParser, chronoParser2, bracketPolicy, Character.valueOf(c));
    }

    I parse(String string) throws ParseException {
        ParseLog parseLog = new ParseLog();
        Object object = this.parse(string, parseLog, IsoInterval.extractDefaultAttributes(this.startFormat));
        if (object == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return (I)object;
    }

    public I parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        int n;
        int n2;
        int n3;
        int n4 = parseLog.getPosition();
        int n5 = n4;
        if (n5 >= (n3 = charSequence.length())) {
            throw new IndexOutOfBoundsException("[" + n5 + "]: " + charSequence.toString());
        }
        AttributeQuery attributeQuery2 = IntervalParser.wrap(attributeQuery);
        IntervalEdge intervalEdge = IntervalEdge.CLOSED;
        IntervalEdge intervalEdge2 = this.factory.isCalendrical() ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
        Temporal temporal = null;
        Temporal temporal2 = null;
        Boundary<Object> boundary = null;
        Boundary<Object> boundary2 = null;
        int n6 = -1;
        int n7 = -1;
        ParseLog parseLog2 = null;
        ParseLog parseLog3 = null;
        String string = null;
        char c = charSequence.charAt(n5);
        boolean bl = c == '[' || c == '(';
        boolean bl2 = false;
        if (bl) {
            if (this.policy == BracketPolicy.SHOW_NEVER) {
                parseLog.setError(n5, "Illegal start boundary due to bracket policy: " + c);
            } else if (c == '(') {
                intervalEdge = IntervalEdge.OPEN;
            }
            ++n5;
        } else if (this.policy == BracketPolicy.SHOW_ALWAYS) {
            parseLog.setError(n5, "Missing start boundary bracket.");
        }
        if (parseLog.isError()) {
            return null;
        }
        if (n5 >= n3) {
            parseLog.setError(n5, "Missing interval start component, end of text reached.");
            return null;
        }
        c = charSequence.charAt(n5);
        if (c == 'P') {
            n6 = n5;
            n2 = n5;
            n = -1;
            while (++n2 < n3) {
                if (charSequence.charAt(n2) != '/') continue;
                n = n2;
                break;
            }
            if (n == -1) {
                parseLog.setError(n5, "Solidus char separating start and end boundaries expected.");
                return null;
            }
            string = charSequence.subSequence(n5, n).toString();
            n5 = n + 1;
        } else if (c == '-' && n5 + 1 < n3 && charSequence.charAt(n5 + 1) == '\u221e') {
            if (intervalEdge == IntervalEdge.CLOSED && bl) {
                parseLog.setError(n5 - 1, "Open boundary expected.");
                return null;
            }
            intervalEdge = IntervalEdge.OPEN;
            boundary = Boundary.infinitePast();
            this.checkSeparatorChar(charSequence, parseLog, n5 += 2, n3);
            if (parseLog.isError()) {
                return null;
            }
            ++n5;
        } else {
            parseLog2 = new ParseLog(n5);
            temporal = (Temporal)this.startFormat.parse(charSequence, parseLog2, attributeQuery2);
            if (temporal == null || parseLog2.isError()) {
                parseLog.setError(n5, parseLog2.getErrorMessage());
                return null;
            }
            boundary = Boundary.of(intervalEdge, temporal);
            n5 = parseLog2.getPosition();
            this.checkSeparatorChar(charSequence, parseLog, n5, n3);
            if (parseLog.isError()) {
                return null;
            }
            ++n5;
        }
        if (n5 >= n3) {
            parseLog.setError(n5, "Missing interval end component, end of text reached.");
            return null;
        }
        c = charSequence.charAt(n5);
        if (c == 'P') {
            if (temporal == null) {
                parseLog.setError(n5, "Cannot process end period without start time.");
                return null;
            }
            n7 = n5;
            n2 = n3;
            n = charSequence.charAt(n2 - 1);
            if (n == 93 || n == 41) {
                --n2;
            }
            string = charSequence.subSequence(n5, n2).toString();
            n5 = n2;
        } else if (c == '+' && n5 + 1 < n3 && charSequence.charAt(n5 + 1) == '\u221e') {
            if (n5 + 2 < n3 && charSequence.charAt(n5 + 2) == ']' && this.policy != BracketPolicy.SHOW_NEVER) {
                parseLog.setError(n5 + 2, "Open boundary expected.");
                return null;
            }
            intervalEdge2 = IntervalEdge.OPEN;
            boundary2 = Boundary.infiniteFuture();
            n5 += 2;
        } else {
            parseLog3 = new ParseLog(n5);
            temporal2 = this.endFormat == null ? this.parseReducedEnd(charSequence, temporal, parseLog2, parseLog3, attributeQuery2) : (Temporal)this.endFormat.parse(charSequence, parseLog3, attributeQuery2);
            if (temporal2 == null || parseLog3.isError()) {
                parseLog.setError(n5, parseLog3.getErrorMessage());
                return null;
            }
            boundary2 = Boundary.of(intervalEdge2, temporal2);
            n5 = parseLog3.getPosition();
        }
        if (n5 >= n3) {
            if (this.policy == BracketPolicy.SHOW_ALWAYS) {
                parseLog.setError(n5, "Missing end boundary bracket.");
            }
        } else {
            c = charSequence.charAt(n5);
            if (c == ']' || c == ')') {
                if (this.policy == BracketPolicy.SHOW_NEVER) {
                    parseLog.setError(n5, "Illegal end boundary due to bracket policy: " + c);
                } else {
                    bl2 = true;
                    IntervalEdge intervalEdge3 = intervalEdge2 = c == ']' ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
                    if (temporal2 != null) {
                        boundary2 = Boundary.of(intervalEdge2, temporal2);
                    }
                    ++n5;
                }
            } else if (this.policy == BracketPolicy.SHOW_ALWAYS) {
                parseLog.setError(n5, "Missing end boundary bracket.");
            }
        }
        if (parseLog.isError()) {
            return null;
        }
        if (n5 < n3 && (this.isISO() || !((Boolean)attributeQuery.get(Attributes.TRAILING_CHARACTERS, (Object)Boolean.FALSE)).booleanValue())) {
            String string2 = n3 - n5 <= 10 ? charSequence.subSequence(n5, n3).toString() : charSequence.subSequence(n5, n5 + 10).toString() + "...";
            parseLog.setError(n5, "Unparsed trailing characters: " + string2);
            return null;
        }
        if (string != null) {
            IntervalFactory<Temporal, I> intervalFactory = this.factory;
            if (boundary == null) {
                if (temporal2 == null) {
                    parseLog.setError(n6, "Cannot process start period without end time.");
                    return null;
                }
                temporal = intervalFactory.minusPeriod(temporal2, string, parseLog3, attributeQuery);
                if (temporal == null) {
                    parseLog.setError(n6, "Wrong period: " + string);
                    return null;
                }
                boundary = Boundary.of(intervalEdge, temporal);
            }
            if (boundary2 == null) {
                temporal2 = intervalFactory.plusPeriod(temporal, string, parseLog2, attributeQuery);
                if (temporal2 == null) {
                    parseLog.setError(n7, "Wrong period: " + string);
                    return null;
                }
                boundary2 = Boundary.of(intervalEdge2, temporal2);
            }
        }
        try {
            I i = this.factory.between(boundary, boundary2);
            if (this.policy == BracketPolicy.SHOW_WHEN_NON_STANDARD) {
                n = this.policy.display((ChronoInterval<?>)i) ? 1 : 0;
                if (!(n == 0 || bl && bl2)) {
                    int n8 = !bl2 ? n5 : n4;
                    parseLog.setError(n8, "Missing boundary.");
                    return null;
                }
                if (n == 0 && (bl || bl2)) {
                    int n9 = bl2 ? n5 : n4;
                    parseLog.setError(n9, "Standard boundary not allowed due to bracket policy.");
                    return null;
                }
            }
            parseLog.setPosition(n5);
            return i;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parseLog.setError(n5, illegalArgumentException.getMessage());
            return null;
        }
    }

    static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> I parseCustom(CharSequence charSequence, IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, String string, ParseLog parseLog) {
        int n = parseLog.getPosition();
        int n2 = charSequence.length();
        Temporal temporal = null;
        Temporal temporal2 = null;
        int n3 = 0;
        int n4 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        AttributeQuery attributeQuery = IsoInterval.extractDefaultAttributes(chronoParser);
        AttributeQuery attributeQuery2 = IntervalParser.wrap(attributeQuery);
        while (n3 < n4) {
            char c = string.charAt(n3);
            if (c == '{' && n3 + 2 < n4 && string.charAt(n3 + 2) == '}') {
                char c2 = string.charAt(n3 + 1);
                if (c2 == '0') {
                    if (bl) {
                        parseLog.setError(n, "Cannot parse start component more than once.");
                        return null;
                    }
                    parseLog.setPosition(n);
                    if (n + 1 < n2 && charSequence.charAt(n) == '-' && charSequence.charAt(n + 1) == '\u221e') {
                        n += 2;
                    } else {
                        temporal = (Temporal)chronoParser.parse(charSequence, parseLog, attributeQuery2);
                        if (temporal == null || parseLog.isError()) {
                            return null;
                        }
                        n = parseLog.getPosition();
                    }
                    bl = true;
                    n3 += 3;
                    continue;
                }
                if (c2 == '1') {
                    if (bl2) {
                        parseLog.setError(n, "Cannot parse end component more than once.");
                        return null;
                    }
                    parseLog.setPosition(n);
                    if (n + 1 < n2 && charSequence.charAt(n) == '+' && charSequence.charAt(n + 1) == '\u221e') {
                        n += 2;
                    } else {
                        temporal2 = (Temporal)chronoParser.parse(charSequence, parseLog, attributeQuery2);
                        if (temporal2 == null || parseLog.isError()) {
                            return null;
                        }
                        n = parseLog.getPosition();
                    }
                    bl2 = true;
                    n3 += 3;
                    continue;
                }
            } else if (c == '[' || c == ']' || c == '(' || c == ')') {
                parseLog.setError(n, "Brackets representing interval boundaries cannot be parsed: " + charSequence);
                return null;
            }
            if (n >= n2) {
                parseLog.setError(n, "End of text reached.");
                return null;
            }
            if (c != charSequence.charAt(n)) {
                parseLog.setError(n, "Literal mismatched: " + charSequence.toString() + " (expected=" + string + ")");
                return null;
            }
            ++n3;
            ++n;
        }
        if (n < n2 && !((Boolean)attributeQuery.get(Attributes.TRAILING_CHARACTERS, (Object)false)).booleanValue()) {
            parseLog.setError(n, "Trailing characters found: " + charSequence);
            return null;
        }
        Boundary<Object> boundary = Boundary.infinitePast();
        Boundary<Object> boundary2 = Boundary.infiniteFuture();
        if (temporal != null) {
            boundary = Boundary.ofClosed(temporal);
        }
        if (temporal2 != null) {
            boundary2 = intervalFactory.isCalendrical() ? Boundary.ofClosed(temporal2) : Boundary.ofOpen(temporal2);
        }
        try {
            return intervalFactory.between(boundary, boundary2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parseLog.setError(n, illegalArgumentException.getMessage());
            return null;
        }
    }

    protected T parseReducedEnd(CharSequence charSequence, T t, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
        return null;
    }

    protected boolean isISO() {
        return false;
    }

    private static AttributeQuery wrap(AttributeQuery attributeQuery) {
        AttributeQuery attributeQuery2 = attributeQuery;
        boolean bl = (Boolean)attributeQuery.get(Attributes.TRAILING_CHARACTERS, (Object)Boolean.FALSE);
        if (!bl) {
            attributeQuery2 = new Wrapper(attributeQuery);
        }
        return attributeQuery2;
    }

    private void checkSeparatorChar(CharSequence charSequence, ParseLog parseLog, int n, int n2) {
        boolean bl;
        if (n >= n2) {
            parseLog.setError(n, "Reached end of text, but not found any separation char.");
            return;
        }
        char c = charSequence.charAt(n);
        if (this.separator == null) {
            bl = c == '/' || c == '-';
        } else {
            boolean bl2 = bl = c == this.separator.charValue();
        }
        if (!bl) {
            parseLog.setError(n, "Missing separation char between start and end boundaries: " + (this.separator == null ? "/ or -" : this.separator.toString()));
        }
    }

    static class Wrapper
    implements AttributeQuery {
        private final AttributeQuery attributes;

        Wrapper(AttributeQuery attributeQuery) {
            this.attributes = attributeQuery;
        }

        public boolean contains(AttributeKey<?> attributeKey) {
            if (attributeKey == Attributes.TRAILING_CHARACTERS) {
                return true;
            }
            return this.attributes.contains(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey) {
            if (attributeKey == Attributes.TRAILING_CHARACTERS) {
                return (A)attributeKey.type().cast(Boolean.TRUE);
            }
            return (A)this.attributes.get(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey, A a) {
            if (attributeKey == Attributes.TRAILING_CHARACTERS) {
                return (A)attributeKey.type().cast(Boolean.TRUE);
            }
            return (A)this.attributes.get(attributeKey, a);
        }
    }
}

