/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;

public abstract class IsoInterval<T extends Temporal<? super T>, I extends IsoInterval<T, I>>
implements ChronoInterval<T> {
    private static final ChronoFunction<ChronoDisplay, Void> NO_RESULT = new ChronoFunction<ChronoDisplay, Void>(){

        public Void apply(ChronoDisplay chronoDisplay) {
            return null;
        }
    };
    private final Boundary<T> start;
    private final Boundary<T> end;

    IsoInterval(Boundary<T> boundary, Boundary<T> boundary2) {
        if (Boundary.isAfter(boundary, boundary2)) {
            throw new IllegalArgumentException("Start after end: " + boundary + "/" + boundary2);
        }
        if (boundary2.isOpen() && boundary.isOpen() && Boundary.isSimultaneous(boundary, boundary2)) {
            if (boundary.isInfinite()) {
                throw new IllegalArgumentException("Infinite boundaries must not be equal.");
            }
            throw new IllegalArgumentException("Open start equal to open end: " + boundary + "/" + boundary2);
        }
        this.start = boundary;
        this.end = boundary2;
    }

    @Override
    public final Boundary<T> getStart() {
        return this.start;
    }

    @Override
    public final Boundary<T> getEnd() {
        return this.end;
    }

    public I withStart(T t) {
        IntervalEdge intervalEdge = this.start.getEdge();
        Boundary<T> boundary = Boundary.of(intervalEdge, t);
        return this.getFactory().between(boundary, this.end);
    }

    public I withEnd(T t) {
        IntervalEdge intervalEdge = this.end.getEdge();
        Boundary<T> boundary = Boundary.of(intervalEdge, t);
        return this.getFactory().between(this.start, boundary);
    }

    public I withOpenEnd() {
        Boundary boundary = this.end.isInfinite() ? Boundary.infiniteFuture() : Boundary.of(IntervalEdge.OPEN, this.end.getTemporal());
        return this.getFactory().between(this.start, boundary);
    }

    public I withClosedEnd() {
        if (this.getEnd().isInfinite()) {
            throw new IllegalStateException("Infinite future cannot be included.");
        }
        Boundary<T> boundary = Boundary.of(IntervalEdge.CLOSED, this.getEnd().getTemporal());
        return this.getFactory().between(this.start, boundary);
    }

    @Override
    public boolean isFinite() {
        return !this.start.isInfinite() && !this.end.isInfinite();
    }

    @Override
    public boolean isEmpty() {
        if (!this.isFinite()) {
            return false;
        }
        Object object = this.start.getTemporal();
        T t = this.end.getTemporal();
        if (this.start.isOpen()) {
            if (this.end.isClosed()) {
                return object.isSimultaneous(t);
            }
            object = (Temporal)this.getTimeLine().stepForward(object);
            if (object == null) {
                return false;
            }
        }
        return this.end.isOpen() && object.isSimultaneous(t);
    }

    @Override
    public boolean isBefore(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.end.isInfinite()) {
            return false;
        }
        T t2 = this.end.getTemporal();
        if (this.end.isOpen()) {
            return !t2.isAfter(t);
        }
        return t2.isBefore(t);
    }

    @Override
    public boolean isBefore(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        T t = this.end.getTemporal();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (this.end.isOpen()) {
            return !t.isAfter(t2);
        }
        return t.isBefore(t2);
    }

    @Override
    public boolean isAfter(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            return false;
        }
        return this.getClosedFiniteStart().isAfter(t);
    }

    @Override
    public boolean isAfter(I i) {
        return ((IsoInterval)i).isBefore(this.getContext());
    }

    @Override
    public boolean contains(T t) {
        boolean bl;
        if (t == null) {
            throw new NullPointerException();
        }
        if (this.start.isInfinite()) {
            bl = true;
        } else if (this.start.isOpen()) {
            bl = this.start.getTemporal().isBefore(t);
        } else {
            boolean bl2 = bl = !this.start.getTemporal().isAfter(t);
        }
        if (!bl) {
            return false;
        }
        boolean bl3 = this.end.isInfinite() ? true : (this.end.isOpen() ? this.end.getTemporal().isAfter(t) : !this.end.getTemporal().isBefore(t));
        return bl3;
    }

    @Override
    public boolean contains(I i) {
        if (!((IsoInterval)i).isFinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t != null && t.isAfter(t2)) {
            return false;
        }
        Object object = this.end.getTemporal();
        Object object2 = ((IsoInterval)i).getEnd().getTemporal();
        if (object == null) {
            return true;
        }
        if (((IsoInterval)i).getEnd().isOpen() && t2.isSimultaneous(object2)) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (object == null || t2.isAfter(object)) {
                return false;
            }
        } else if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
            if (object == null || object2 == null || object.isBefore(object2)) {
                return false;
            }
        } else {
            if (this.end.isClosed() && (object = (Temporal)this.getTimeLine().stepForward(object)) == null) {
                return true;
            }
            if (((IsoInterval)i).getEnd().isClosed() && (object2 = (Temporal)this.getTimeLine().stepForward(object2)) == null) {
                return false;
            }
            return !object.isBefore(object2);
        }
        return true;
    }

    public I collapse() {
        if (this.start.isInfinite()) {
            throw new IllegalStateException("An interval with infinite past cannot be collapsed.");
        }
        T t = this.getClosedFiniteStart();
        Boundary<T> boundary = Boundary.ofClosed(t);
        Boundary<T> boundary2 = Boundary.ofOpen(t);
        return this.getFactory().between(boundary, boundary2);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IsoInterval) {
            IsoInterval isoInterval = (IsoInterval)IsoInterval.class.cast(object);
            return this.start.equals(isoInterval.start) && this.end.equals(isoInterval.end) && this.getTimeLine().equals(isoInterval.getTimeLine());
        }
        return false;
    }

    public final int hashCode() {
        return 17 * this.start.hashCode() + 37 * this.end.hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.start.isOpen() ? (char)'(' : '[');
        stringBuilder.append((Object)(this.start.isInfinite() ? "-\u221e" : this.start.getTemporal()));
        stringBuilder.append('/');
        stringBuilder.append((Object)(this.end.isInfinite() ? "+\u221e" : this.end.getTemporal()));
        stringBuilder.append(this.end.isOpen() ? (char)')' : ']');
        return stringBuilder.toString();
    }

    public String print(ChronoPrinter<T> chronoPrinter) {
        return this.print(chronoPrinter, BracketPolicy.SHOW_WHEN_NON_STANDARD);
    }

    public String print(ChronoPrinter<T> chronoPrinter, BracketPolicy bracketPolicy) {
        AttributeQuery attributeQuery = IsoInterval.extractDefaultAttributes(chronoPrinter);
        boolean bl = bracketPolicy.display(this);
        StringBuilder stringBuilder = new StringBuilder(64);
        if (bl) {
            stringBuilder.append(this.start.isOpen() ? (char)'(' : '[');
        }
        try {
            if (this.start.isInfinite()) {
                stringBuilder.append("-\u221e");
            } else {
                chronoPrinter.print(this.start.getTemporal(), (Appendable)stringBuilder, attributeQuery, NO_RESULT);
            }
            stringBuilder.append('/');
            if (this.end.isInfinite()) {
                stringBuilder.append("+\u221e");
            } else {
                chronoPrinter.print(this.end.getTemporal(), (Appendable)stringBuilder, attributeQuery, NO_RESULT);
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        if (bl) {
            stringBuilder.append(this.end.isOpen() ? (char)')' : ']');
        }
        return stringBuilder.toString();
    }

    public boolean equivalentTo(I i) {
        if (this.getContext() == i) {
            return true;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t == null) {
            if (t2 != null) {
                return false;
            }
        } else {
            if (t2 == null) {
                return false;
            }
            if (!t.isSimultaneous(t2)) {
                return false;
            }
        }
        Object object = this.end.getTemporal();
        Object object2 = ((IsoInterval)i).getEnd().getTemporal();
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
        } else {
            if (this.end.isClosed()) {
                object = (Temporal)this.getTimeLine().stepForward(object);
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                object2 = (Temporal)this.getTimeLine().stepForward(object2);
            }
        }
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.isSimultaneous(object2);
    }

    public boolean precedes(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Object object = this.end.getTemporal();
        if (this.end.isClosed() && (object = (Temporal)this.getTimeLine().stepForward(object)) == null) {
            return false;
        }
        return object.isBefore(((IsoInterval)i).getClosedFiniteStart());
    }

    public boolean precededBy(I i) {
        return ((IsoInterval)i).precedes(this.getContext());
    }

    public boolean meets(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        Object object = this.end.getTemporal();
        if (this.end.isClosed() && (object = (Temporal)this.getTimeLine().stepForward(object)) == null) {
            return false;
        }
        if (object.isSimultaneous(((IsoInterval)i).getClosedFiniteStart())) {
            T t = this.getClosedFiniteStart();
            T t2 = ((IsoInterval)i).getEnd().getTemporal();
            if (t == null || t2 == null) {
                return true;
            }
            return t.isBefore(t2);
        }
        return false;
    }

    public boolean metBy(I i) {
        return ((IsoInterval)i).meets(this.getContext());
    }

    public boolean overlaps(I i) {
        if (((IsoInterval)i).getStart().isInfinite() || this.end.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t != null && !t.isBefore(t2)) {
            return false;
        }
        Object object = this.end.getTemporal();
        Object object2 = ((IsoInterval)i).getEnd().getTemporal();
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (object == null || object.isBefore(t2)) {
                return false;
            }
            if (object2 == null) {
                return true;
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
        } else {
            if (this.end.isClosed() && (object = (Temporal)this.getTimeLine().stepForward(object)) == null) {
                return object2 == null;
            }
            if (!object.isAfter(t2)) {
                return false;
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                object2 = (Temporal)this.getTimeLine().stepForward(object2);
            }
        }
        return object2 == null || object.isBefore(object2);
    }

    public boolean overlappedBy(I i) {
        return ((IsoInterval)i).overlaps(this.getContext());
    }

    public boolean finishes(I i) {
        boolean bl;
        if (this.start.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        Object object = this.end.getTemporal();
        Object object2 = ((IsoInterval)i).getEnd().getTemporal();
        boolean bl2 = bl = this.end.isOpen() && object != null && t.isSimultaneous(object);
        if (bl || t2 != null && !t2.isBefore(t)) {
            return false;
        }
        if (object2 == null) {
            return object == null;
        }
        if (object == null) {
            return object2 == null;
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
            if (object == null || object2 == null || t.isAfter(object2)) {
                return false;
            }
        } else {
            if (this.end.isClosed()) {
                object = (Temporal)this.getTimeLine().stepForward(object);
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                object2 = (Temporal)this.getTimeLine().stepForward(object2);
            }
            if (object2 != null && !t.isBefore(object2)) {
                return false;
            }
            if (object == null) {
                return object2 == null;
            }
            if (object2 == null) {
                return false;
            }
        }
        return object.isSimultaneous(object2);
    }

    public boolean finishedBy(I i) {
        return ((IsoInterval)i).finishes(this.getContext());
    }

    public boolean starts(I i) {
        if (this.end.isInfinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t2 == null ? t != null : (t == null ? t2 != null : !t.isSimultaneous(t2))) {
            return false;
        }
        Object object = this.end.getTemporal();
        Object object2 = ((IsoInterval)i).getEnd().getTemporal();
        if (this.end.isOpen() && t != null && t.isSimultaneous(object)) {
            return true;
        }
        if (object2 == null) {
            if (this.end.isClosed()) {
                return true;
            }
            if (t2 == null) {
                return this.getTimeLine().stepBackwards(object) != null;
            }
            return object.isAfter(t2);
        }
        if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
            if (object == null || object2 == null || !object.isBefore(object2)) {
                return false;
            }
        } else {
            if (this.end.isClosed() && (object = (Temporal)this.getTimeLine().stepForward(object)) == null) {
                return false;
            }
            if (((IsoInterval)i).getEnd().isClosed()) {
                object2 = (Temporal)this.getTimeLine().stepForward(object2);
            }
            if (object2 != null && !object.isBefore(object2)) {
                return false;
            }
        }
        if (this.end.isClosed()) {
            return true;
        }
        if (t2 == null) {
            return this.getTimeLine().stepBackwards(object) != null;
        }
        return object.isAfter(t2);
    }

    public boolean startedBy(I i) {
        return ((IsoInterval)i).starts(this.getContext());
    }

    public boolean encloses(I i) {
        if (!((IsoInterval)i).isFinite()) {
            return false;
        }
        T t = this.getClosedFiniteStart();
        T t2 = ((IsoInterval)i).getClosedFiniteStart();
        if (t != null && !t.isBefore(t2)) {
            return false;
        }
        Object object = this.end.getTemporal();
        Object object2 = ((IsoInterval)i).getEnd().getTemporal();
        if (object == null) {
            return true;
        }
        if (((IsoInterval)i).getEnd().isOpen() && t2.isSimultaneous(object2)) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (object == null || t2.isAfter(object)) {
                return false;
            }
        } else if (this.getFactory().isCalendrical()) {
            if (this.end.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            if (((IsoInterval)i).getEnd().isOpen()) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
            if (object == null || object2 == null || !object.isAfter(object2)) {
                return false;
            }
        } else {
            if (this.end.isClosed()) {
                object = (Temporal)this.getTimeLine().stepForward(object);
            }
            if (((IsoInterval)i).getEnd().isClosed() && (object2 = (Temporal)this.getTimeLine().stepForward(object2)) == null) {
                return false;
            }
            if (object != null && !object.isAfter(object2)) {
                return false;
            }
        }
        return true;
    }

    public boolean enclosedBy(I i) {
        return ((IsoInterval)i).encloses(this.getContext());
    }

    abstract TimeLine<T> getTimeLine();

    abstract IntervalFactory<T, I> getFactory();

    T getTemporalOfClosedStart() {
        T t = this.start.getTemporal();
        if (t == null) {
            throw new UnsupportedOperationException("An infinite interval has no finite duration.");
        }
        if (this.start.isOpen()) {
            return (T)((Temporal)this.getTimeLine().stepForward(t));
        }
        return t;
    }

    T getClosedFiniteStart() {
        T t = this.start.getTemporal();
        if (t != null && this.start.isOpen()) {
            return (T)((Temporal)this.getTimeLine().stepForward(t));
        }
        return t;
    }

    T getTemporalOfOpenEnd() {
        T t = this.end.getTemporal();
        if (t == null) {
            throw new UnsupportedOperationException("An infinite interval has no finite duration.");
        }
        if (this.end.isClosed()) {
            return (T)((Temporal)this.getTimeLine().stepForward(t));
        }
        return t;
    }

    T getOpenFiniteEnd() {
        T t = this.end.getTemporal();
        if (t != null && this.end.isClosed()) {
            return (T)((Temporal)this.getTimeLine().stepForward(t));
        }
        return t;
    }

    static AttributeQuery extractDefaultAttributes(Object object) {
        if (object instanceof ChronoFormatter) {
            ChronoFormatter chronoFormatter = (ChronoFormatter)ChronoFormatter.class.cast(object);
            return chronoFormatter.getAttributes();
        }
        return Attributes.empty();
    }

    abstract I getContext();
}

