/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Locale;
import net.time4j.AdjustableElement;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.Iso8601Format;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.format.ChronoFormatter;
import net.time4j.format.ChronoParser;
import net.time4j.format.ChronoPrinter;
import net.time4j.format.ParseLog;
import net.time4j.format.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.FixedNumParser;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentInterval;
import net.time4j.range.NoopPrinter;
import net.time4j.range.SPX;
import net.time4j.range.TimestampIntervalFactory;
import net.time4j.range.YearParser;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class TimestampInterval
extends IsoInterval<PlainTimestamp, TimestampInterval>
implements Serializable {
    private static final long serialVersionUID = -3965530927182499606L;
    private static final ChronoFormatter<PlainTimestamp> EXT_O = TimestampInterval.ordinalFormat(true);
    private static final ChronoFormatter<PlainTimestamp> EXT_W = TimestampInterval.weekdateFormat(true);
    private static final ChronoFormatter<PlainTimestamp> BAS_O = TimestampInterval.ordinalFormat(false);
    private static final ChronoFormatter<PlainTimestamp> BAS_W = TimestampInterval.weekdateFormat(false);
    private static final Comparator<ChronoInterval<PlainTimestamp>> COMPARATOR = new IntervalComparator<PlainTimestamp>(false, (TimeLine<PlainTimestamp>)PlainTimestamp.axis());

    TimestampInterval(Boundary<PlainTimestamp> boundary, Boundary<PlainTimestamp> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<PlainTimestamp>> comparator() {
        return COMPARATOR;
    }

    public static TimestampInterval between(PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
        return new TimestampInterval(Boundary.of(IntervalEdge.CLOSED, plainTimestamp), Boundary.of(IntervalEdge.OPEN, plainTimestamp2));
    }

    public static TimestampInterval since(PlainTimestamp plainTimestamp) {
        Boundary<PlainTimestamp> boundary = Boundary.infiniteFuture();
        return new TimestampInterval(Boundary.of(IntervalEdge.CLOSED, plainTimestamp), boundary);
    }

    public static TimestampInterval until(PlainTimestamp plainTimestamp) {
        Boundary<PlainTimestamp> boundary = Boundary.infinitePast();
        return new TimestampInterval(boundary, Boundary.of(IntervalEdge.OPEN, plainTimestamp));
    }

    public MomentInterval atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    public MomentInterval at(ZonalOffset zonalOffset) {
        Boundary<Moment> boundary;
        Moment moment;
        Boundary<Moment> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            moment = ((PlainTimestamp)this.getStart().getTemporal()).at(zonalOffset);
            boundary2 = Boundary.of(this.getStart().getEdge(), moment);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            moment = ((PlainTimestamp)this.getEnd().getTemporal()).at(zonalOffset);
            boundary = Boundary.of(this.getEnd().getEdge(), moment);
        }
        return new MomentInterval(boundary2, boundary);
    }

    public MomentInterval inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    public MomentInterval inTimezone(TZID tZID) {
        return this.in(Timezone.of((TZID)tZID));
    }

    public MomentInterval in(Timezone timezone) {
        Boundary<Moment> boundary;
        Moment moment;
        Boundary<Moment> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            moment = ((PlainTimestamp)this.getStart().getTemporal()).in(timezone);
            boundary2 = Boundary.of(this.getStart().getEdge(), moment);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            moment = ((PlainTimestamp)this.getEnd().getTemporal()).in(timezone);
            boundary = Boundary.of(this.getEnd().getEdge(), moment);
        }
        return new MomentInterval(boundary2, boundary);
    }

    public <U extends IsoUnit> Duration<U> getDuration(U ... UArray) {
        boolean bl;
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainTimestamp == null;
        if (bl) {
            plainTimestamp = (PlainTimestamp)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.in(UArray).between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)plainTimestamp);
        if (bl) {
            for (U u : UArray) {
                if (!u.equals(ClockUnit.NANOS)) continue;
                return duration.plus(1L, u);
            }
        }
        return duration;
    }

    public Duration<IsoUnit> getDuration(Timezone timezone, IsoUnit ... isoUnitArray) {
        boolean bl;
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainTimestamp == null;
        if (bl) {
            plainTimestamp = (PlainTimestamp)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.in((Timezone)timezone, (IsoUnit[])isoUnitArray).between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)plainTimestamp);
        if (bl) {
            for (IsoUnit isoUnit : isoUnitArray) {
                if (!isoUnit.equals(ClockUnit.NANOS)) continue;
                return duration.plus(1L, isoUnit);
            }
        }
        return duration;
    }

    public TimestampInterval move(long l, IsoUnit isoUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), (Temporal)((PlainTimestamp)this.getStart().getTemporal()).plus(l, (Object)isoUnit));
        Boundary<Object> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), (Temporal)((PlainTimestamp)this.getEnd().getTemporal()).plus(l, (Object)isoUnit));
        return new TimestampInterval((Boundary<PlainTimestamp>)boundary, (Boundary<PlainTimestamp>)boundary2);
    }

    public static TimestampInterval parse(String string, ChronoParser<PlainTimestamp> chronoParser) throws ParseException {
        return IntervalParser.of(TimestampIntervalFactory.INSTANCE, chronoParser, BracketPolicy.SHOW_WHEN_NON_STANDARD).parse(string);
    }

    public static TimestampInterval parse(CharSequence charSequence, ChronoParser<PlainTimestamp> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (TimestampInterval)IntervalParser.of(TimestampIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static TimestampInterval parseISO(String string) throws ParseException {
        ChronoFormatter<PlainTimestamp> chronoFormatter;
        char c;
        int n;
        int n2;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n3 = 0;
        int n4 = Math.min(string.length(), 71);
        boolean bl = true;
        int n5 = 0;
        for (n2 = 1; n2 < n4; ++n2) {
            if (string.charAt(n2) != '/') continue;
            if (string.charAt(0) == 'P') {
                n3 = n2 + 1;
                n5 = n4 - n2 - 1;
                break;
            }
            if (n2 + 1 < n4 && string.charAt(n2 + 1) == 'P') {
                n5 = n2;
                break;
            }
            bl = 2 * n2 + 1 == n4;
            n5 = n2;
            break;
        }
        n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 0;
        for (n = n3; n < n4 && (c = string.charAt(n)) != '/'; ++n) {
            if (c == '-') {
                ++n2;
                continue;
            }
            if (c == 'T' || n6 > 0) {
                ++n6;
                continue;
            }
            if (c != 'W') continue;
            bl3 = true;
        }
        int n7 = n = n2 > 0 ? 1 : 0;
        if (!bl3) {
            boolean bl4 = bl2 = n2 == 1 || n2 == 0 && n5 - n6 == 7;
        }
        Object object = bl2 ? (n != 0 ? EXT_O : BAS_O) : (bl3 ? (n != 0 ? EXT_W : BAS_W) : (n != 0 ? Iso8601Format.EXTENDED_DATE_TIME : Iso8601Format.BASIC_DATE_TIME));
        if (bl) {
            chronoFormatter = object;
        } else {
            boolean bl5 = true;
            if (n4 - 1 - n5 < n6) {
                --n6;
                bl5 = false;
            }
            chronoFormatter = TimestampInterval.abbreviatedFormat(n != 0, bl3, bl2, n6, bl5);
        }
        return IntervalParser.of(TimestampIntervalFactory.INSTANCE, object, chronoFormatter, BracketPolicy.SHOW_NEVER, PlainTimestamp.axis()).parse(string);
    }

    @Override
    TimeLine<PlainTimestamp> getTimeLine() {
        return PlainTimestamp.axis();
    }

    @Override
    IntervalFactory<PlainTimestamp, TimestampInterval> getFactory() {
        return TimestampIntervalFactory.INSTANCE;
    }

    @Override
    TimestampInterval getContext() {
        return this;
    }

    private static ChronoFormatter<PlainTimestamp> ordinalFormat(boolean bl) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(PlainTimestamp.class, (Locale)Locale.ROOT);
        builder.addInteger((ChronoElement)PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3).build();
        builder.addLiteral('T');
        builder.addCustomized((ChronoElement)PlainTime.COMPONENT, bl ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
        return builder.build();
    }

    private static ChronoFormatter<PlainTimestamp> weekdateFormat(boolean bl) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(PlainTimestamp.class, (Locale)Locale.ROOT);
        builder.addInteger((ChronoElement)PlainDate.YEAR_OF_WEEKDATE, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addLiteral('W');
        builder.addFixedInteger((ChronoElement)Weekmodel.ISO.weekOfYear(), 2);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1).build();
        builder.addLiteral('T');
        builder.addCustomized((ChronoElement)PlainTime.COMPONENT, bl ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
        return builder.build();
    }

    private static ChronoFormatter<PlainTimestamp> abbreviatedFormat(boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        AdjustableElement adjustableElement;
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(PlainTimestamp.class, (Locale)Locale.ROOT);
        AdjustableElement adjustableElement2 = adjustableElement = bl2 ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
        if (bl) {
            int n2 = (bl3 ? 3 : 5) + n;
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n2);
            builder.addCustomized((ChronoElement)adjustableElement, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(bl2 ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR));
        } else {
            int n3 = (bl3 ? 3 : 4) + n;
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n3);
            builder.addInteger((ChronoElement)adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        }
        builder.endSection();
        if (bl2) {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, 1 + n);
            builder.addCustomized((ChronoElement)Weekmodel.ISO.weekOfYear(), (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(bl ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR));
            builder.endSection();
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1);
            builder.endSection();
        } else if (bl3) {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3);
            builder.endSection();
        } else {
            builder.startSection(Attributes.PROTECTED_CHARACTERS, 2 + n);
            if (bl) {
                builder.addCustomized((ChronoElement)PlainDate.MONTH_AS_NUMBER, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)FixedNumParser.CALENDAR_MONTH);
            } else {
                builder.addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2);
            }
            builder.endSection();
            builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
            builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2);
            builder.endSection();
        }
        if (bl4) {
            builder.addLiteral('T');
        }
        builder.addCustomized((ChronoElement)PlainTime.COMPONENT, bl ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
        return builder.build();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SPX(this, 52);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

