/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockWindows;
import net.time4j.range.DateWindows;
import net.time4j.range.IntervalEdge;
import net.time4j.range.MomentWindows;
import net.time4j.range.TimestampWindows;

public abstract class IntervalCollection<T extends Temporal<? super T>>
implements Serializable {
    private final transient List<ChronoInterval<T>> intervals;

    IntervalCollection() {
        this.intervals = Collections.emptyList();
    }

    IntervalCollection(List<ChronoInterval<T>> list) {
        this.intervals = Collections.unmodifiableList(list);
    }

    public static IntervalCollection<PlainDate> onDateAxis() {
        return DateWindows.EMPTY;
    }

    public static IntervalCollection<PlainTime> onClockAxis() {
        return ClockWindows.EMPTY;
    }

    public static IntervalCollection<PlainTimestamp> onTimestampAxis() {
        return TimestampWindows.EMPTY;
    }

    public static IntervalCollection<Moment> onMomentAxis() {
        return MomentWindows.EMPTY;
    }

    public List<ChronoInterval<T>> getIntervals() {
        return this.intervals;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public T getMinimum() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty time windows have no minimum.");
        }
        return this.intervals.get(0).getStart().getTemporal();
    }

    public T getMaximum() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty time windows have no maximum.");
        }
        int n = this.intervals.size();
        Boundary<T> boundary = this.intervals.get(n - 1).getEnd();
        Object object = boundary.getTemporal();
        if (boundary.isInfinite()) {
            return null;
        }
        if (this.isCalendrical()) {
            if (boundary.isOpen()) {
                object = (Temporal)this.getTimeLine().stepBackwards(object);
            }
            for (int i = n - 2; i >= 0; --i) {
                Boundary<T> boundary2 = this.intervals.get(i).getEnd();
                Object object2 = boundary2.getTemporal();
                if (boundary2.isInfinite()) {
                    return null;
                }
                if (boundary2.isOpen()) {
                    object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
                }
                if (!object2.isAfter(object)) continue;
                object = object2;
            }
        } else {
            Object var4_5 = null;
            if (boundary.isClosed()) {
                Temporal temporal = (Temporal)this.getTimeLine().stepForward(object);
                if (temporal == null) {
                    var4_5 = object;
                } else {
                    object = temporal;
                }
            }
            for (int i = n - 2; i >= 0; --i) {
                Boundary<T> boundary3 = this.intervals.get(i).getEnd();
                Object object3 = boundary3.getTemporal();
                if (boundary3.isInfinite()) {
                    return null;
                }
                if (var4_5 != null) continue;
                if (boundary3.isClosed()) {
                    Temporal temporal = (Temporal)this.getTimeLine().stepForward(object3);
                    if (temporal == null) {
                        var4_5 = object3;
                        continue;
                    }
                    object3 = temporal;
                }
                if (!object3.isAfter(object)) continue;
                object = object3;
            }
            object = var4_5 != null ? var4_5 : (Temporal)this.getTimeLine().stepBackwards(object);
        }
        return object;
    }

    public IntervalCollection<T> plus(ChronoInterval<T> chronoInterval) {
        if (chronoInterval == null) {
            throw new NullPointerException("Missing interval.");
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>(this.intervals);
        arrayList.add(chronoInterval);
        Collections.sort(arrayList, this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> plus(List<? extends ChronoInterval<T>> list) {
        if (list.isEmpty()) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>(this.intervals);
        arrayList.addAll(list);
        Collections.sort(arrayList, this.getComparator());
        return this.create(arrayList);
    }

    public IntervalCollection<T> withGaps() {
        ChronoInterval<T> chronoInterval;
        int n = this.intervals.size();
        if (n < 2) {
            return this;
        }
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        Object var3_3 = null;
        int n2 = n - 1;
        for (int i = 0; i < n2 && !(chronoInterval = this.intervals.get(i)).getEnd().isInfinite(); ++i) {
            Object object = chronoInterval.getEnd().getTemporal();
            if (chronoInterval.getEnd().isClosed() && (object = (Temporal)this.getTimeLine().stepForward(object)) == null) break;
            if (var3_3 == null || object.isAfter(var3_3)) {
                var3_3 = object;
            } else {
                object = var3_3;
            }
            Object object2 = this.intervals.get(i + 1).getStart().getTemporal();
            if (object2 == null || !object2.isAfter(object)) continue;
            IntervalEdge intervalEdge = IntervalEdge.OPEN;
            if (this.isCalendrical()) {
                intervalEdge = IntervalEdge.CLOSED;
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
                if (object2 == null) continue;
            }
            Boundary<T> boundary = Boundary.ofClosed(object);
            Boundary<T> boundary2 = Boundary.of(intervalEdge, object2);
            arrayList.add(this.newInterval(boundary, boundary2));
        }
        return this.create(arrayList);
    }

    public IntervalCollection<T> withBlocks() {
        Boundary boundary;
        Boundary<T> boundary2;
        if (this.intervals.size() < 2) {
            return this;
        }
        boolean bl = this.isCalendrical();
        IntervalEdge intervalEdge = bl ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
        List<ChronoInterval<T>> list = this.withGaps().intervals;
        ArrayList<ChronoInterval<T>> arrayList = new ArrayList<ChronoInterval<T>>();
        Object object = this.getMinimum();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object2 = list.get(i).getStart().getTemporal();
            if (bl) {
                object2 = (Temporal)this.getTimeLine().stepBackwards(object2);
            }
            boundary2 = this.createStartBoundary(object);
            boundary = Boundary.of(intervalEdge, object2);
            arrayList.add(this.newInterval(boundary2, boundary));
            Boundary<T> boundary3 = list.get(i).getEnd();
            object = boundary3.getTemporal();
            if (!boundary3.isClosed()) continue;
            object = (Temporal)this.getTimeLine().stepForward(object);
        }
        Object object3 = this.getMaximum();
        boundary2 = this.createStartBoundary(object);
        if (object3 != null && !bl) {
            object3 = (Temporal)this.getTimeLine().stepForward(object3);
        }
        boundary = object3 == null ? Boundary.infiniteFuture() : Boundary.of(intervalEdge, object3);
        arrayList.add(this.newInterval(boundary2, boundary));
        return this.create(arrayList);
    }

    /*
     * Exception decompiling
     */
    public IntervalCollection<T> withIntersection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IntervalCollection<T> union(IntervalCollection<T> intervalCollection) {
        if (this == intervalCollection) {
            return this;
        }
        return this.plus(intervalCollection.getIntervals());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IntervalCollection) {
            IntervalCollection intervalCollection = (IntervalCollection)IntervalCollection.class.cast(object);
            return this.getTimeLine().equals(intervalCollection.getTimeLine()) && this.intervals.equals(intervalCollection.intervals);
        }
        return false;
    }

    public int hashCode() {
        return this.intervals.hashCode();
    }

    public String toString() {
        int n = this.intervals.size();
        StringBuilder stringBuilder = new StringBuilder(n * 30);
        stringBuilder.append('{');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.intervals.get(i));
            if (i >= n - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.append('}').toString();
    }

    abstract Comparator<ChronoInterval<T>> getComparator();

    abstract IntervalCollection<T> create(List<ChronoInterval<T>> var1);

    abstract TimeLine<T> getTimeLine();

    abstract ChronoInterval<T> newInterval(Boundary<T> var1, Boundary<T> var2);

    boolean isCalendrical() {
        return false;
    }

    private Boundary<T> createStartBoundary(T t) {
        if (t == null) {
            return Boundary.infinitePast();
        }
        return Boundary.ofClosed(t);
    }
}

