/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.tz.TZID;

public abstract class ChronoEntity<T extends ChronoEntity<T>>
implements ChronoDisplay {
    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        return this.getChronology().isSupported(chronoElement);
    }

    @Override
    public <V> V get(ChronoElement<V> chronoElement) {
        return this.getRule(chronoElement).getValue(this.getContext());
    }

    @Override
    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return this.getRule(chronoElement).getMinimum(this.getContext());
    }

    @Override
    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        return this.getRule(chronoElement).getMaximum(this.getContext());
    }

    public final <R> R get(ChronoFunction<? super T, R> chronoFunction) {
        return chronoFunction.apply(this.getContext());
    }

    public boolean matches(ChronoCondition<? super T> chronoCondition) {
        return chronoCondition.test(this.getContext());
    }

    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        return this.contains(chronoElement) && this.getRule(chronoElement).isValid(this.getContext(), v);
    }

    public boolean isValid(ChronoElement<Integer> chronoElement, int n) {
        return this.isValid((ChronoElement)chronoElement, (Object)n);
    }

    public boolean isValid(ChronoElement<Long> chronoElement, long l) {
        return this.isValid((ChronoElement)chronoElement, (Object)l);
    }

    public <V> T with(ChronoElement<V> chronoElement, V v) {
        return (T)((ChronoEntity)this.getRule(chronoElement).withValue(this.getContext(), v, chronoElement.isLenient()));
    }

    public T with(ChronoElement<Integer> chronoElement, int n) {
        return this.with((ChronoElement)chronoElement, (Object)n);
    }

    public T with(ChronoElement<Long> chronoElement, long l) {
        return this.with((ChronoElement)chronoElement, (Object)l);
    }

    public T with(ChronoOperator<T> chronoOperator) {
        return (T)((ChronoEntity)chronoOperator.apply(this.getContext()));
    }

    @Override
    public boolean hasTimezone() {
        return false;
    }

    @Override
    public TZID getTimezone() {
        throw new ChronoException("Timezone not available: " + this);
    }

    protected abstract Chronology<T> getChronology();

    protected T getContext() {
        Chronology<T> chronology = this.getChronology();
        Class<T> clazz = chronology.getChronoType();
        if (clazz.isInstance(this)) {
            return (T)((ChronoEntity)clazz.cast(this));
        }
        for (ChronoElement<?> chronoElement : chronology.getRegisteredElements()) {
            if (clazz != chronoElement.getType()) continue;
            return (T)((ChronoEntity)clazz.cast(this.get(chronoElement)));
        }
        throw new IllegalStateException("Implementation error: Cannot find entity context.");
    }

    private <V> ElementRule<T, V> getRule(ChronoElement<V> chronoElement) {
        return this.getChronology().getRule(chronoElement);
    }
}

