/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.AdjustableElement;
import net.time4j.ElementOperator;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.TimeOperator;
import net.time4j.ZonalQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoFunction;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

abstract class AbstractTimeElement<V extends Comparable<V>>
extends BasicElement<V>
implements AdjustableElement<V, PlainTime> {
    private final transient ElementOperator<PlainTime> minimizer = new TimeOperator(this, 0);
    private final transient ElementOperator<PlainTime> maximizer = new TimeOperator(this, 1);

    AbstractTimeElement(String string) {
        super(string);
    }

    @Override
    public ElementOperator<PlainTime> newValue(V v) {
        return new TimeOperator(this, -1, v);
    }

    @Override
    public ElementOperator<PlainTime> minimized() {
        return this.minimizer;
    }

    @Override
    public ElementOperator<PlainTime> maximized() {
        return this.maximizer;
    }

    @Override
    public ElementOperator<PlainTime> decremented() {
        return new TimeOperator(this, 2);
    }

    @Override
    public ElementOperator<PlainTime> incremented() {
        return new TimeOperator(this, 3);
    }

    @Override
    public ElementOperator<PlainTime> atFloor() {
        return new TimeOperator(this, 4);
    }

    @Override
    public ElementOperator<PlainTime> atCeiling() {
        return new TimeOperator(this, 5);
    }

    public ElementOperator<PlainTime> setLenient(V v) {
        return new TimeOperator(this, 6, v);
    }

    @Override
    public ChronoFunction<Moment, V> inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    @Override
    public ChronoFunction<Moment, V> inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    @Override
    public ChronoFunction<Moment, V> in(Timezone timezone) {
        return new ZonalQuery(this, timezone);
    }

    @Override
    public ChronoFunction<Moment, V> atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    @Override
    public ChronoFunction<Moment, V> at(ZonalOffset zonalOffset) {
        return new ZonalQuery(this, zonalOffset);
    }
}

