/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.ExtZoneProvider;
import net.time4j.tz.FallbackTimezone;
import net.time4j.tz.GapResolver;
import net.time4j.tz.HistorizedTimezone;
import net.time4j.tz.NameStyle;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.PlatformTimezone;
import net.time4j.tz.TZID;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZoneProvider;

public abstract class Timezone
implements Serializable {
    private static final String NEW_LINE;
    private static final String REPOSITORY_VERSION;
    private static final Comparator<TZID> ID_COMPARATOR;
    public static final TransitionStrategy DEFAULT_CONFLICT_STRATEGY;
    public static final TransitionStrategy STRICT_MODE;
    private static final boolean ALLOW_SYSTEM_TZ_OVERRIDE;
    private static volatile ZonalKeys zonalKeys;
    private static volatile Timezone currentSystemTZ;
    private static volatile boolean cacheActive;
    private static int softLimit;
    private static final String NAME_JUT = "java.util.TimeZone";
    private static final String NAME_TZDB = "TZDB";
    private static final String NAME_ZONENAMES = "#STD_ZONE_NAMES";
    private static final String NAME_DEFAULT = "DEFAULT";
    private static final Map<String, TZID> PREDEFINED;
    private static final ZoneProvider PLATFORM_PROVIDER;
    private static final ZoneProvider DEFAULT_PROVIDER;
    private static final ConcurrentMap<String, NamedReference> CACHE;
    private static final ReferenceQueue<Timezone> QUEUE;
    private static final LinkedList<Timezone> LAST_USED;
    private static final ConcurrentMap<String, ZoneProvider> PROVIDERS;
    private static final ZoneProvider ZONENAME_PROVIDER;
    private static final Timezone SYSTEM_TZ_ORIGINAL;

    Timezone() {
    }

    public static List<TZID> getAvailableIDs() {
        return zonalKeys.availables;
    }

    public static List<TZID> getAvailableIDs(String string) {
        ZoneProvider zoneProvider = Timezone.getProvider(string);
        if (zoneProvider == null) {
            return Collections.emptyList();
        }
        ArrayList<TZID> arrayList = new ArrayList<TZID>();
        for (String string2 : zoneProvider.getAvailableIDs()) {
            arrayList.add(Timezone.resolve(string2));
        }
        Collections.sort(arrayList, ID_COMPARATOR);
        return Collections.unmodifiableList(arrayList);
    }

    public static Set<TZID> getPreferredIDs(Locale locale, boolean bl, String string) {
        ZoneProvider zoneProvider = Timezone.getProvider(string);
        if (zoneProvider == null) {
            return Collections.emptySet();
        }
        HashSet<TZID> hashSet = new HashSet<TZID>();
        for (String string2 : zoneProvider.getPreferredIDs(locale, bl)) {
            hashSet.add(Timezone.resolve(string2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static Timezone ofSystem() {
        if (ALLOW_SYSTEM_TZ_OVERRIDE && currentSystemTZ != null) {
            return currentSystemTZ;
        }
        assert (SYSTEM_TZ_ORIGINAL != null);
        return SYSTEM_TZ_ORIGINAL;
    }

    public static Timezone of(TZID tZID) {
        return Timezone.getTZ(tZID, true);
    }

    public static Timezone of(String string) {
        return Timezone.getTZ(null, string, true);
    }

    public static Timezone of(String string, TZID tZID) {
        Timezone timezone = Timezone.getTZ(null, string, false);
        if (timezone == null && (timezone = Timezone.getTZ(tZID, false)) == null) {
            timezone = Timezone.ofSystem();
        }
        return timezone;
    }

    public static Timezone of(String string, TransitionHistory transitionHistory) {
        return new HistorizedTimezone(Timezone.resolve(string), transitionHistory);
    }

    public abstract TZID getID();

    public abstract ZonalOffset getOffset(UnixTime var1);

    public abstract ZonalOffset getStandardOffset(UnixTime var1);

    public abstract ZonalOffset getDaylightSavingOffset(UnixTime var1);

    public abstract ZonalOffset getOffset(GregorianDate var1, WallTime var2);

    public abstract boolean isInvalid(GregorianDate var1, WallTime var2);

    public abstract boolean isDaylightSaving(UnixTime var1);

    public abstract boolean isFixed();

    public abstract TransitionHistory getHistory();

    public static String getProviderInfo() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(Timezone.class.getName());
        stringBuilder.append(":[default-provider=");
        stringBuilder.append(DEFAULT_PROVIDER.getName());
        stringBuilder.append(", registered={");
        for (String string : PROVIDERS.keySet()) {
            String string2;
            ZoneProvider zoneProvider = (ZoneProvider)PROVIDERS.get(string);
            if (zoneProvider == null) continue;
            stringBuilder.append("(name=");
            stringBuilder.append(zoneProvider.getName());
            String string3 = zoneProvider.getLocation();
            if (!string3.isEmpty()) {
                stringBuilder.append(",location=");
                stringBuilder.append(string3);
            }
            if (!(string2 = zoneProvider.getVersion()).isEmpty()) {
                stringBuilder.append(",version=");
                stringBuilder.append(string2);
            }
            stringBuilder.append(')');
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    public static String getVersion(String string) {
        ZoneProvider zoneProvider = Timezone.getProvider(string);
        return zoneProvider == null ? "" : zoneProvider.getVersion();
    }

    public static Set<String> getRegisteredProviders() {
        return Collections.unmodifiableSet(PROVIDERS.keySet());
    }

    public abstract TransitionStrategy getStrategy();

    public abstract Timezone with(TransitionStrategy var1);

    public String getDisplayName(NameStyle nameStyle, Locale locale) {
        String string;
        String string2 = this.getID().canonical();
        int n = string2.indexOf(126);
        ZoneProvider zoneProvider = DEFAULT_PROVIDER;
        String string3 = string2;
        if (n >= 0) {
            string = string2.substring(0, n);
            if (!string.equals(NAME_DEFAULT)) {
                zoneProvider = (ZoneProvider)PROVIDERS.get(string);
            }
            string3 = string2.substring(n + 1);
        }
        if ((string = zoneProvider.getDisplayName(string3, nameStyle, locale)).isEmpty() && zoneProvider != PLATFORM_PROVIDER) {
            return PLATFORM_PROVIDER.getDisplayName(string3, nameStyle, locale);
        }
        return string;
    }

    public static boolean registerProvider(ZoneProvider zoneProvider) {
        boolean bl;
        String string = zoneProvider.getName();
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing name of zone provider.");
        }
        if (string.equals(NAME_TZDB)) {
            throw new IllegalArgumentException("TZDB provider cannot be registered after startup.");
        }
        if (string.equals(NAME_JUT)) {
            throw new IllegalArgumentException("Platform provider cannot be replaced.");
        }
        if (string.equals(NAME_DEFAULT)) {
            throw new IllegalArgumentException("Default zone provider cannot be overridden.");
        }
        if (string.equals(NAME_ZONENAMES)) {
            throw new IllegalArgumentException("Reserved zone name provider cannot be replaced.");
        }
        boolean bl2 = bl = PROVIDERS.putIfAbsent(string, zoneProvider) == null;
        if (bl) {
            zonalKeys = new ZonalKeys();
        }
        return bl;
    }

    public void dump(Appendable appendable) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(4096);
        stringBuilder.append("Start Of Dump =>").append(NEW_LINE);
        stringBuilder.append("*** Timezone-ID:").append(NEW_LINE);
        stringBuilder.append(">>> ").append(this.getID().canonical()).append(NEW_LINE);
        if (this.isFixed()) {
            stringBuilder.append("*** Fixed offset:").append(NEW_LINE).append(">>> ");
            stringBuilder.append(this.getHistory().getInitialOffset()).append(NEW_LINE);
        } else {
            stringBuilder.append("*** Strategy:").append(NEW_LINE);
            stringBuilder.append(">>> ").append(this.getStrategy()).append(NEW_LINE);
            TransitionHistory transitionHistory = this.getHistory();
            stringBuilder.append("*** History:").append(NEW_LINE);
            if (transitionHistory == null) {
                stringBuilder.append(">>> Not public!").append(NEW_LINE);
            } else {
                transitionHistory.dump(stringBuilder);
            }
        }
        stringBuilder.append("<= End Of Dump").append(NEW_LINE);
        appendable.append(stringBuilder.toString());
    }

    private static Timezone getDefaultTZ() {
        String string = TimeZone.getDefault().getID();
        return Timezone.of(string, ZonalOffset.UTC);
    }

    private static Timezone getTZ(TZID tZID, boolean bl) {
        if (tZID instanceof ZonalOffset) {
            return ((ZonalOffset)tZID).getModel();
        }
        return Timezone.getTZ(tZID, tZID.canonical(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Timezone getTZ(TZID tZID, String string, boolean bl) {
        Object object;
        Object object2 = null;
        NamedReference namedReference = (NamedReference)CACHE.get(string);
        if (namedReference != null && (object2 = (Timezone)namedReference.get()) == null) {
            CACHE.remove(namedReference.tzid);
        }
        if (object2 != null) {
            return object2;
        }
        String string2 = "";
        String string3 = string;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '~') continue;
            string2 = string.substring(0, i);
            string3 = string.substring(i + 1);
            break;
        }
        if (string3.isEmpty()) {
            if (bl) {
                throw new IllegalArgumentException("Timezone key is empty.");
            }
            return null;
        }
        ZoneProvider zoneProvider = DEFAULT_PROVIDER;
        int n2 = n = string2.isEmpty() || string2.equals(NAME_DEFAULT) ? 1 : 0;
        if (n == 0 && (zoneProvider = (ZoneProvider)PROVIDERS.get(string2)) == null) {
            if (bl) {
                String string4 = string2.equals(NAME_TZDB) ? "TZDB provider not available: " : "Timezone provider not registered: ";
                throw new IllegalArgumentException(string4 + string);
            }
            return null;
        }
        Object object3 = tZID;
        if (object3 == null) {
            if (n != 0) {
                object = Timezone.resolve(string3);
                if (object instanceof ZonalOffset) {
                    return ((ZonalOffset)object).getModel();
                }
                object3 = object;
            } else {
                object3 = new NamedID(string);
            }
        }
        if (zoneProvider == PLATFORM_PROVIDER) {
            object = new PlatformTimezone((TZID)object3, string3);
            if (!((PlatformTimezone)object).isGMT() || string3.equals("GMT") || string3.startsWith("UT") || string3.equals("Z")) {
                object2 = object;
            }
        } else {
            object = zoneProvider.load(string3);
            object2 = object == null ? Timezone.getZoneByAlias(zoneProvider, (TZID)object3, string3) : new HistorizedTimezone((TZID)object3, (TransitionHistory)object);
        }
        if (object2 == null) {
            if (bl) {
                throw new IllegalArgumentException("Unknown timezone: " + string);
            }
            return null;
        }
        if (cacheActive) {
            object = CACHE.putIfAbsent(string, new NamedReference((Timezone)object2, QUEUE));
            if (object == null) {
                Class<Timezone> clazz = Timezone.class;
                synchronized (Timezone.class) {
                    LAST_USED.addFirst((Timezone)object2);
                    while (LAST_USED.size() >= softLimit) {
                        LAST_USED.removeLast();
                    }
                    // ** MonitorExit[var11_13] (shouldn't be in output)
                }
            } else {
                Timezone timezone = (Timezone)((SoftReference)object).get();
                if (timezone != null) {
                    object2 = timezone;
                }
            }
        }
        return object2;
    }

    private static Timezone getZoneByAlias(ZoneProvider zoneProvider, TZID tZID, String string) {
        TransitionHistory transitionHistory = null;
        String string2 = string;
        Map<String, String> map = zoneProvider.getAliases();
        while (transitionHistory == null && (string2 = map.get(string2)) != null) {
            transitionHistory = zoneProvider.load(string2);
        }
        if (transitionHistory == null) {
            String string3 = zoneProvider.getFallback();
            if (string3.isEmpty()) {
                return null;
            }
            if (string3.equals(zoneProvider.getName())) {
                throw new IllegalArgumentException("Circular zone provider fallback: " + zoneProvider.getName());
            }
            return new FallbackTimezone(tZID, Timezone.of(string3 + "~" + string));
        }
        return new HistorizedTimezone(tZID, transitionHistory);
    }

    private static TZID resolve(String string) {
        TZID tZID = PREDEFINED.get(string);
        if (tZID == null) {
            if (string.startsWith("GMT")) {
                string = "UTC" + string.substring(3);
            }
            if ((tZID = ZonalOffset.parse(string, false)) == null) {
                tZID = new NamedID(string);
            }
        }
        return tZID;
    }

    private static List<Class<? extends TZID>> loadPredefined(ClassLoader classLoader, String ... stringArray) throws ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        for (String string : stringArray) {
            Class<?> clazz = Class.forName("net.time4j.tz.olson." + string, true, classLoader);
            if (!TZID.class.isAssignableFrom(clazz)) continue;
            arrayList.add(clazz);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static ZoneProvider getProvider(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing zone provider.");
        }
        return string.equals(NAME_DEFAULT) ? DEFAULT_PROVIDER : (ZoneProvider)PROVIDERS.get(string);
    }

    private static ZoneProvider compareTZDB(ZoneProvider zoneProvider, ZoneProvider zoneProvider2) {
        String string = zoneProvider.getVersion();
        if (!string.isEmpty()) {
            if (string.equals(REPOSITORY_VERSION)) {
                zoneProvider2 = zoneProvider;
            } else if (REPOSITORY_VERSION == null) {
                if (zoneProvider2 == null || string.compareTo(zoneProvider2.getVersion()) > 0) {
                    zoneProvider2 = zoneProvider;
                } else if (string.compareTo(zoneProvider2.getVersion()) == 0 && !zoneProvider.getLocation().contains("{java.home}")) {
                    zoneProvider2 = zoneProvider;
                }
            }
        }
        return zoneProvider2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var5_10;
        Object object222;
        List<Object> list;
        NEW_LINE = System.getProperty("line.separator");
        REPOSITORY_VERSION = System.getProperty("net.time4j.tz.repository.version");
        ID_COMPARATOR = new Comparator<TZID>(){

            @Override
            public int compare(TZID tZID, TZID tZID2) {
                return tZID.canonical().compareTo(tZID2.canonical());
            }
        };
        DEFAULT_CONFLICT_STRATEGY = GapResolver.PUSH_FORWARD.and(OverlapResolver.LATER_OFFSET);
        STRICT_MODE = GapResolver.ABORT.and(OverlapResolver.LATER_OFFSET);
        ALLOW_SYSTEM_TZ_OVERRIDE = Boolean.getBoolean("net.time4j.allow.system.tz.override") || "Dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"));
        zonalKeys = null;
        currentSystemTZ = null;
        cacheActive = true;
        softLimit = 11;
        CACHE = new ConcurrentHashMap<String, NamedReference>();
        PROVIDERS = new ConcurrentHashMap<String, ZoneProvider>();
        QUEUE = new ReferenceQueue();
        LAST_USED = new LinkedList();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Timezone.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            list = Timezone.loadPredefined(classLoader, "AFRICA", "AMERICA", "AMERICA$ARGENTINA", "AMERICA$INDIANA", "AMERICA$KENTUCKY", "AMERICA$NORTH_DAKOTA", "ANTARCTICA", "ASIA", "ATLANTIC", "AUSTRALIA", "EUROPE", "INDIAN", "PACIFIC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            list = Collections.emptyList();
        }
        HashMap<String, TZID> hashMap = new HashMap<String, TZID>();
        hashMap.put("Z", ZonalOffset.UTC);
        hashMap.put("UT", ZonalOffset.UTC);
        hashMap.put("UTC", ZonalOffset.UTC);
        hashMap.put("GMT", ZonalOffset.UTC);
        hashMap.put("UTC0", ZonalOffset.UTC);
        hashMap.put("GMT0", ZonalOffset.UTC);
        for (Object object222 : list) {
            for (TZID tZID : (TZID[])((Class)object222).getEnumConstants()) {
                hashMap.put(tZID.canonical(), tZID);
            }
        }
        PREDEFINED = Collections.unmodifiableMap(hashMap);
        ServiceLoader<ZoneProvider> serviceLoader = ServiceLoader.load(ZoneProvider.class, classLoader);
        object222 = null;
        Object var5_7 = null;
        Iterator<Object> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            ZoneProvider zoneProvider = (ZoneProvider)iterator.next();
            String string = zoneProvider.getName();
            if (string.equals(NAME_TZDB)) {
                object222 = Timezone.compareTZDB(zoneProvider, (ZoneProvider)object222);
                continue;
            }
            if (string.equals(NAME_ZONENAMES)) {
                ZoneProvider zoneProvider2 = zoneProvider;
                continue;
            }
            if (string.isEmpty() || string.equals(NAME_DEFAULT)) continue;
            PROVIDERS.put(string, zoneProvider);
        }
        iterator = ServiceLoader.load(ExtZoneProvider.class, classLoader).iterator();
        while (true) {
            try {
                boolean bl = iterator.hasNext();
                if (!bl) {
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
            break;
            try {
                ZoneProvider zoneProvider = (ZoneProvider)iterator.next();
                String string = zoneProvider.getName();
                if (string.equals(NAME_TZDB)) {
                    object222 = Timezone.compareTZDB(zoneProvider, (ZoneProvider)object222);
                    continue;
                }
                if (string.equals(NAME_ZONENAMES)) {
                    ZoneProvider zoneProvider3 = zoneProvider;
                    continue;
                }
                if (string.isEmpty() || string.equals(NAME_DEFAULT)) continue;
                PROVIDERS.put(string, zoneProvider);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        ZONENAME_PROVIDER = var5_10;
        PLATFORM_PROVIDER = new PlatformTZProvider();
        PROVIDERS.put(NAME_JUT, PLATFORM_PROVIDER);
        if (object222 == null) {
            DEFAULT_PROVIDER = PLATFORM_PROVIDER;
        } else {
            PROVIDERS.put(NAME_TZDB, (ZoneProvider)object222);
            DEFAULT_PROVIDER = object222;
        }
        Timezone timezone = null;
        try {
            String string = System.getProperty("user.timezone");
            if ("Z".equals(string) || "UTC".equals(string)) {
                timezone = ZonalOffset.UTC.getModel();
            } else if (string != null) {
                timezone = Timezone.getTZ(Timezone.resolve(string), string, false);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SYSTEM_TZ_ORIGINAL = timezone == null ? Timezone.getDefaultTZ() : timezone;
        if (ALLOW_SYSTEM_TZ_OVERRIDE) {
            currentSystemTZ = SYSTEM_TZ_ORIGINAL;
        }
        zonalKeys = new ZonalKeys();
    }

    private static class PlatformTZProvider
    implements ZoneProvider {
        private PlatformTZProvider() {
        }

        @Override
        public Set<String> getAvailableIDs() {
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = TimeZone.getAvailableIDs();
            hashSet.addAll(Arrays.asList(stringArray));
            return hashSet;
        }

        @Override
        public Set<String> getPreferredIDs(Locale locale, boolean bl) {
            ZoneProvider zoneProvider = ZONENAME_PROVIDER;
            if (zoneProvider == null) {
                return Collections.emptySet();
            }
            return zoneProvider.getPreferredIDs(locale, bl);
        }

        @Override
        public Map<String, String> getAliases() {
            return Collections.emptyMap();
        }

        @Override
        public String getFallback() {
            return "";
        }

        @Override
        public String getName() {
            return Timezone.NAME_JUT;
        }

        @Override
        public String getLocation() {
            return "";
        }

        @Override
        public String getVersion() {
            return "";
        }

        @Override
        public TransitionHistory load(String string) {
            return null;
        }

        @Override
        public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
            if (locale == null) {
                throw new NullPointerException("Missing locale.");
            }
            if (string.isEmpty()) {
                return "";
            }
            TimeZone timeZone = PlatformTimezone.findZone(string);
            if (timeZone.getID().equals(string)) {
                return timeZone.getDisplayName(nameStyle.isDaylightSaving(), nameStyle.isAbbreviation() ? 0 : 1, locale);
            }
            return string;
        }
    }

    private static class ZonalKeys {
        private final List<TZID> availables;

        ZonalKeys() {
            ArrayList<TZID> arrayList = new ArrayList<TZID>(1024);
            arrayList.add(ZonalOffset.UTC);
            for (Map.Entry entry : PROVIDERS.entrySet()) {
                ZoneProvider zoneProvider = (ZoneProvider)entry.getValue();
                if (zoneProvider == PLATFORM_PROVIDER && DEFAULT_PROVIDER != PLATFORM_PROVIDER) continue;
                for (String string : zoneProvider.getAvailableIDs()) {
                    TZID tZID = Timezone.resolve(string);
                    if (arrayList.contains(tZID)) continue;
                    arrayList.add(tZID);
                }
            }
            Collections.sort(arrayList, ID_COMPARATOR);
            this.availables = Collections.unmodifiableList(arrayList);
        }
    }

    private static class NamedID
    implements TZID,
    Serializable {
        private static final long serialVersionUID = -4889632013137688471L;
        private final String tzid;

        NamedID(String string) {
            this.tzid = string;
        }

        @Override
        public String canonical() {
            return this.tzid;
        }

        public boolean equals(Object object) {
            if (object instanceof NamedID) {
                NamedID namedID = (NamedID)object;
                return this.tzid.equals(namedID.tzid);
            }
            return false;
        }

        public int hashCode() {
            return this.tzid.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + "@" + this.tzid;
        }
    }

    private static class NamedReference
    extends SoftReference<Timezone> {
        private final String tzid;

        NamedReference(Timezone timezone, ReferenceQueue<Timezone> referenceQueue) {
            super(timezone, referenceQueue);
            this.tzid = timezone.getID().canonical();
        }
    }

    public static class Cache {
        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void refresh() {
            Class<Timezone> clazz = Timezone.class;
            synchronized (Timezone.class) {
                while (QUEUE.poll() != null) {
                }
                LAST_USED.clear();
                // ** MonitorExit[var0] (shouldn't be in output)
                Timezone.zonalKeys = new ZonalKeys();
                CACHE.clear();
                if (ALLOW_SYSTEM_TZ_OVERRIDE) {
                    currentSystemTZ = Timezone.getDefaultTZ();
                }
                return;
            }
        }

        public static void setCacheActive(boolean bl) {
            cacheActive = bl;
            if (!bl) {
                CACHE.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setMinimumCacheSize(int n) {
            NamedReference namedReference;
            if (n < 0) {
                throw new IllegalArgumentException("Negative timezone cache size: " + n);
            }
            while ((namedReference = (NamedReference)QUEUE.poll()) != null) {
                CACHE.remove(namedReference.tzid);
            }
            Class<Timezone> clazz = Timezone.class;
            synchronized (Timezone.class) {
                softLimit = n + 1;
                int n2 = LAST_USED.size() - n;
                for (int i = 0; i < n2; ++i) {
                    LAST_USED.removeLast();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

