/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.SPX;
import net.time4j.tz.SingleOffsetTimezone;
import net.time4j.tz.TZID;

public final class ZonalOffset
implements Comparable<ZonalOffset>,
TZID,
Serializable {
    private static final ConcurrentMap<Integer, ZonalOffset> OFFSET_CACHE = new ConcurrentHashMap<Integer, ZonalOffset>();
    private static final ConcurrentMap<String, ZonalOffset> ID_CACHE = new ConcurrentHashMap<String, ZonalOffset>();
    private static final BigDecimal DECIMAL_60 = new BigDecimal(60);
    private static final BigDecimal DECIMAL_3600 = new BigDecimal(3600);
    private static final BigDecimal DECIMAL_NEG_180 = new BigDecimal(-180);
    private static final BigDecimal DECIMAL_POS_180 = new BigDecimal(180);
    private static final BigDecimal DECIMAL_240 = new BigDecimal(240);
    private static final BigDecimal MRD = new BigDecimal(1000000000);
    public static final ZonalOffset UTC = new ZonalOffset(0, 0);
    private static final long serialVersionUID = -1410512619471503090L;
    private final transient int total;
    private final transient int fraction;
    private final transient String name;

    private ZonalOffset(int n, int n2) {
        if (n2 == 0) {
            if (n < -64800 || n > 64800) {
                throw new IllegalArgumentException("Total seconds out of range: " + n);
            }
        } else {
            if (Math.abs(n2) > 999999999) {
                throw new IllegalArgumentException("Fraction out of range: " + n2);
            }
            if (n < -39600 || n > 39600) {
                throw new IllegalArgumentException("Total seconds out of range while fraction is non-zero: " + n);
            }
            if (n < 0 && n2 > 0 || n > 0 && n2 < 0) {
                throw new IllegalArgumentException("Different signs: offset=" + n + ", fraction=" + n2);
            }
        }
        boolean bl = n < 0 || n2 < 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(bl ? (char)'-' : '+');
        int n3 = Math.abs(n);
        int n4 = n3 / 3600;
        int n5 = n3 / 60 % 60;
        int n6 = n3 % 60;
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        stringBuilder.append(':');
        if (n5 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n5);
        if (n6 != 0 || n2 != 0) {
            stringBuilder.append(':');
            if (n6 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n6);
            if (n2 != 0) {
                stringBuilder.append('.');
                String string = String.valueOf(Math.abs(n2));
                int n7 = 9 - string.length();
                for (int i = 0; i < n7; ++i) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string);
            }
        }
        this.name = stringBuilder.toString();
        this.total = n;
        this.fraction = n2;
    }

    public static ZonalOffset atLongitude(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(DECIMAL_POS_180) > 0 || bigDecimal.compareTo(DECIMAL_NEG_180) < 0) {
            throw new IllegalArgumentException("Out of range: " + bigDecimal);
        }
        BigDecimal bigDecimal2 = bigDecimal.multiply(DECIMAL_240);
        BigDecimal bigDecimal3 = bigDecimal2.setScale(0, RoundingMode.DOWN);
        BigDecimal bigDecimal4 = bigDecimal2.subtract(bigDecimal3);
        BigDecimal bigDecimal5 = bigDecimal4.setScale(9, RoundingMode.HALF_UP).multiply(MRD);
        int n = bigDecimal3.intValueExact();
        int n2 = bigDecimal5.intValueExact();
        if (n2 == 0) {
            return ZonalOffset.ofTotalSeconds(n);
        }
        return new ZonalOffset(n, n2);
    }

    public static ZonalOffset atLongitude(OffsetSign offsetSign, int n, int n2, int n3) {
        BigDecimal bigDecimal;
        if (offsetSign == null) {
            throw new NullPointerException("Missing sign.");
        }
        if (n < 0 || n > 180) {
            throw new IllegalArgumentException("Degrees of longitude out of range (0 <= degrees <= 180).");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Arc minute out of range (0 <= arcMinutes <= 59).");
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("Arc second out of range (0 <= arcSeconds <= 59).");
        }
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n);
        if (n2 != 0) {
            bigDecimal = BigDecimal.valueOf(n2).setScale(15).divide(DECIMAL_60, RoundingMode.HALF_UP);
            bigDecimal2 = bigDecimal2.add(bigDecimal);
        }
        if (n3 != 0) {
            bigDecimal = BigDecimal.valueOf(n3).setScale(15).divide(DECIMAL_3600, RoundingMode.HALF_UP);
            bigDecimal2 = bigDecimal2.add(bigDecimal);
        }
        if (offsetSign == OffsetSign.BEHIND_UTC) {
            bigDecimal2 = bigDecimal2.negate();
        }
        return ZonalOffset.atLongitude(bigDecimal2);
    }

    public static ZonalOffset ofHours(OffsetSign offsetSign, int n) {
        return ZonalOffset.ofHoursMinutes(offsetSign, n, 0);
    }

    public static ZonalOffset ofHoursMinutes(OffsetSign offsetSign, int n, int n2) {
        if (offsetSign == null) {
            throw new NullPointerException("Missing sign.");
        }
        if (n < 0 || n > 18) {
            throw new IllegalArgumentException("Hour part out of range (0 <= hours <= 18) in: " + ZonalOffset.format(n, n2));
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Minute part out of range (0 <= minutes <= 59) in: " + ZonalOffset.format(n, n2));
        }
        if (n == 18 && n2 != 0) {
            throw new IllegalArgumentException("Time zone offset out of range (-18:00:00 <= offset <= 18:00:00) in: " + ZonalOffset.format(n, n2));
        }
        int n3 = n * 3600 + n2 * 60;
        if (offsetSign == OffsetSign.BEHIND_UTC) {
            n3 = -n3;
        }
        return ZonalOffset.ofTotalSeconds(n3);
    }

    public static ZonalOffset ofTotalSeconds(int n) {
        return ZonalOffset.ofTotalSeconds(n, 0);
    }

    public static ZonalOffset ofTotalSeconds(int n, int n2) {
        if (n2 != 0) {
            return new ZonalOffset(n, n2);
        }
        if (n == 0) {
            return UTC;
        }
        if (n % 900 == 0) {
            Integer n3 = n;
            ZonalOffset zonalOffset = (ZonalOffset)OFFSET_CACHE.get(n3);
            if (zonalOffset == null) {
                zonalOffset = new ZonalOffset(n, 0);
                OFFSET_CACHE.putIfAbsent(n3, zonalOffset);
                zonalOffset = (ZonalOffset)OFFSET_CACHE.get(n3);
                ID_CACHE.putIfAbsent(zonalOffset.name, zonalOffset);
            }
            return zonalOffset;
        }
        return new ZonalOffset(n, 0);
    }

    public OffsetSign getSign() {
        return this.total < 0 || this.fraction < 0 ? OffsetSign.BEHIND_UTC : OffsetSign.AHEAD_OF_UTC;
    }

    public int getAbsoluteHours() {
        return Math.abs(this.total) / 3600;
    }

    public int getAbsoluteMinutes() {
        return Math.abs(this.total) / 60 % 60;
    }

    public int getAbsoluteSeconds() {
        return Math.abs(this.total) % 60;
    }

    public int getIntegralAmount() {
        return this.total;
    }

    public int getFractionalAmount() {
        return this.fraction;
    }

    @Override
    public int compareTo(ZonalOffset zonalOffset) {
        if (this.total < zonalOffset.total) {
            return -1;
        }
        if (this.total > zonalOffset.total) {
            return 1;
        }
        int n = this.fraction - zonalOffset.fraction;
        return n < 0 ? -1 : (n == 0 ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonalOffset) {
            ZonalOffset zonalOffset = (ZonalOffset)object;
            return this.total == zonalOffset.total && this.fraction == zonalOffset.fraction;
        }
        return false;
    }

    public int hashCode() {
        return ~this.total + this.fraction % 64000;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String canonical() {
        if (this.total == 0 && this.fraction == 0) {
            return "Z";
        }
        return "UTC" + this.name;
    }

    public static ZonalOffset parse(String string) {
        return ZonalOffset.parse(string, true);
    }

    static ZonalOffset parse(String string, boolean bl) {
        if (string.equals("Z")) {
            return UTC;
        }
        int n = string.length();
        String string2 = string;
        if (n >= 3) {
            if (string2.startsWith("UTC")) {
                string2 = string.substring(3);
                n -= 3;
            } else if (string2.startsWith("GMT")) {
                if (bl) {
                    throw new IllegalArgumentException("Use UTC-prefix for canonical offset instead: " + string);
                }
                return null;
            }
        }
        if (n >= 6) {
            OffsetSign offsetSign = null;
            if (string2.charAt(0) == '-') {
                offsetSign = OffsetSign.BEHIND_UTC;
            } else if (string2.charAt(0) == '+') {
                offsetSign = OffsetSign.AHEAD_OF_UTC;
            }
            int n2 = ZonalOffset.parse(string2, 1, 2);
            int n3 = ZonalOffset.parse(string2, 4, 2);
            if (n2 >= 0 && string2.charAt(3) == ':' && n3 >= 0) {
                int n4;
                if (n == 6) {
                    return ZonalOffset.ofHoursMinutes(offsetSign, n2, n3);
                }
                if (n >= 9 && string2.charAt(6) == ':' && (n4 = ZonalOffset.parse(string2, 7, 2)) >= 0) {
                    int n5;
                    int n6 = n2 * 3600 + n3 * 60 + n4;
                    if (offsetSign == OffsetSign.BEHIND_UTC) {
                        n6 = -n6;
                    }
                    if (n == 9) {
                        return ZonalOffset.ofTotalSeconds(n6);
                    }
                    if (n == 19 && string2.charAt(9) == '.' && (n5 = ZonalOffset.parse(string2, 10, 9)) >= 0) {
                        if (offsetSign == OffsetSign.BEHIND_UTC) {
                            n5 = -n5;
                        }
                        return ZonalOffset.ofTotalSeconds(n6, n5);
                    }
                }
            }
        }
        if (bl) {
            throw new IllegalArgumentException("No canonical zonal offset: " + string);
        }
        return null;
    }

    SingleOffsetTimezone getModel() {
        return SingleOffsetTimezone.of(this);
    }

    private static int parse(String string, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            if (c < '0' || c > '9') {
                return -1;
            }
            n3 = n3 * 10 + (c - 48);
        }
        return n3;
    }

    private static String format(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[hours=");
        stringBuilder.append(n);
        stringBuilder.append(",minutes=");
        stringBuilder.append(n2);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SPX(this, 15);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        OFFSET_CACHE.put(0, UTC);
        ID_CACHE.put("Z", UTC);
    }
}

