/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.util.Locale;
import net.time4j.Meridiem;
import net.time4j.Moment;
import net.time4j.ZonalElement;
import net.time4j.ZonalQuery;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoFunction;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.ParseLog;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

enum AmPmElement implements ZonalElement<Meridiem>,
TextElement<Meridiem>
{
    AM_PM_OF_DAY;


    @Override
    public Class<Meridiem> getType() {
        return Meridiem.class;
    }

    @Override
    public char getSymbol() {
        return 'a';
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo((Enum)chronoDisplay2.get(this));
    }

    @Override
    public Meridiem getDefaultMinimum() {
        return Meridiem.AM;
    }

    @Override
    public Meridiem getDefaultMaximum() {
        return Meridiem.PM;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public ChronoFunction<Moment, Meridiem> inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    @Override
    public ChronoFunction<Moment, Meridiem> inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    @Override
    public ChronoFunction<Moment, Meridiem> in(Timezone timezone) {
        return new ZonalQuery<Meridiem>(this, timezone);
    }

    @Override
    public ChronoFunction<Moment, Meridiem> atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    @Override
    public ChronoFunction<Moment, Meridiem> at(ZonalOffset zonalOffset) {
        return new ZonalQuery<Meridiem>(this, zonalOffset);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        appendable.append(this.accessor(attributeQuery).print(chronoDisplay.get(this)));
    }

    @Override
    public Meridiem parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        return this.accessor(attributeQuery).parse(charSequence, parseLog, this.getType(), attributeQuery);
    }

    private TextAccessor accessor(AttributeQuery attributeQuery) {
        CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601"), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        return calendarText.getMeridiems(textWidth);
    }
}

