/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.HistorizedTimezone;
import net.time4j.tz.NameStyle;
import net.time4j.tz.PlatformTimezone;
import net.time4j.tz.TZID;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.ZoneProvider;

public abstract class Timezone
implements Serializable {
    private static final int MRD = 1000000000;
    public static final TransitionStrategy DEFAULT_CONFLICT_STRATEGY;
    public static final TransitionStrategy STRICT_MODE;
    private static final boolean ALLOW_SYSTEM_TZ_OVERRIDE;
    private static volatile NameData NAME_DATA;
    private static volatile Timezone SYSTEM_TZ_CURRENT;
    private static volatile boolean ACTIVE;
    private static int SOFT_LIMIT;
    private static final Map<String, TZID> PREDEFINED;
    private static final Map<String, Set<TZID>> TERRITORIES;
    private static final ZoneProvider PROVIDER;
    private static final ConcurrentMap<String, NamedReference> CACHE;
    private static final ReferenceQueue<Timezone> QUEUE;
    private static final LinkedList<Timezone> LAST_USED;
    private static final Timezone SYSTEM_TZ_ORIGINAL;

    Timezone() {
    }

    public static List<TZID> getAvailableIDs() {
        return NAME_DATA.availables;
    }

    public static Set<TZID> getPreferredIDs(Locale locale) {
        Set<TZID> set = TERRITORIES.get(locale.getCountry());
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public static Timezone ofSystem() {
        if (ALLOW_SYSTEM_TZ_OVERRIDE) {
            return SYSTEM_TZ_CURRENT;
        }
        return SYSTEM_TZ_ORIGINAL;
    }

    public static Timezone of(TZID tZID) {
        return Timezone.getTZ(tZID, true);
    }

    public static Timezone of(String string) {
        return Timezone.getTZ(string, true);
    }

    public static Timezone of(String string, TZID tZID) {
        Timezone timezone = Timezone.getTZ(string, false);
        if (timezone == null && (timezone = Timezone.getTZ(tZID, false)) == null) {
            timezone = Timezone.ofSystem();
        }
        return timezone;
    }

    public abstract TZID getID();

    public abstract ZonalOffset getOffset(UnixTime var1);

    public abstract ZonalOffset getOffset(GregorianDate var1, WallTime var2);

    public abstract boolean isInvalid(GregorianDate var1, WallTime var2);

    public abstract boolean isDaylightSaving(UnixTime var1);

    public abstract boolean isFixed();

    public abstract TransitionHistory getHistory();

    public static String getProviderInfo() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(Timezone.class.getName());
        stringBuilder.append("[provider=");
        stringBuilder.append(PROVIDER.getName());
        if (!(PROVIDER instanceof PlatformTZProvider)) {
            stringBuilder.append(",location=");
            stringBuilder.append(PROVIDER.getLocation());
            stringBuilder.append(",version=");
            stringBuilder.append(PROVIDER.getVersion());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public abstract TransitionStrategy getStrategy();

    public abstract Timezone with(TransitionStrategy var1);

    public String getDisplayName(NameStyle nameStyle, Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Missing locale.");
        }
        String string = this.getID().canonical();
        TimeZone timeZone = PlatformTimezone.findZone(string);
        if (timeZone.getID().equals(string)) {
            return timeZone.getDisplayName(nameStyle.isDaylightSaving(), nameStyle.isAbbreviation() ? 0 : 1, locale);
        }
        return string;
    }

    private static Timezone getDefaultTZ() {
        String string = TimeZone.getDefault().getID();
        return Timezone.of(string, ZonalOffset.UTC);
    }

    private static Timezone getTZ(TZID tZID, boolean bl) {
        if (tZID instanceof ZonalOffset) {
            return ((ZonalOffset)tZID).getModel();
        }
        return Timezone.getTZ(tZID.canonical(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Timezone getTZ(String string, boolean bl) {
        Object object;
        Object object2 = null;
        NamedReference namedReference = (NamedReference)CACHE.get(string);
        if (namedReference != null && (object2 = (Timezone)namedReference.get()) == null) {
            CACHE.remove(namedReference.tzid);
        }
        if (object2 != null) {
            return object2;
        }
        TZID tZID = PREDEFINED.get(string);
        if (tZID == null) {
            tZID = new NamedID(string);
        }
        if (PROVIDER instanceof PlatformTZProvider) {
            object = new PlatformTimezone(tZID, string);
            if (!((PlatformTimezone)object).isGMT() || string.equals("GMT") || string.startsWith("UT") || string.equals("Z")) {
                object2 = object;
            }
        } else {
            object = PROVIDER.load(string, false);
            object2 = object == null ? Timezone.getZoneByAlias(tZID, string) : new HistorizedTimezone(tZID, (TransitionHistory)object);
        }
        if (object2 == null) {
            if (bl) {
                throw new IllegalArgumentException("Unknown timezone: " + string);
            }
            return null;
        }
        if (ACTIVE) {
            object = CACHE.putIfAbsent(string, new NamedReference((Timezone)object2, QUEUE));
            if (object == null) {
                Class<Timezone> clazz = Timezone.class;
                synchronized (Timezone.class) {
                    LAST_USED.addFirst((Timezone)object2);
                    while (LAST_USED.size() >= SOFT_LIMIT) {
                        LAST_USED.removeLast();
                    }
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                }
            } else {
                Timezone timezone = (Timezone)((SoftReference)object).get();
                if (timezone != null) {
                    object2 = timezone;
                }
            }
        }
        return object2;
    }

    private static Timezone getZoneByAlias(TZID tZID, String string) {
        TransitionHistory transitionHistory = null;
        String string2 = string;
        Map map = NAME_DATA.aliases;
        while (transitionHistory == null && (string2 = (String)map.get(string2)) != null) {
            transitionHistory = PROVIDER.load(string2, false);
        }
        if (transitionHistory == null && PROVIDER.isFallbackEnabled()) {
            transitionHistory = PROVIDER.load(string, true);
        }
        if (transitionHistory == null) {
            return null;
        }
        return new HistorizedTimezone(tZID, transitionHistory);
    }

    private static List<Class<? extends TZID>> loadPredefined(String ... stringArray) throws ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        for (String string : stringArray) {
            Class<?> clazz = Class.forName("net.time4j.tz.olson." + string);
            if (!TZID.class.isAssignableFrom(clazz)) continue;
            arrayList.add(clazz);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static void addTerritory(Map<String, Set<TZID>> map, String string, TZID tZID) {
        Set<TZID> set = map.get(string);
        if (set == null) {
            set = new LinkedHashSet<TZID>();
            map.put(string, set);
        }
        set.add(tZID);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var7_21;
        Object illegalAccessException;
        List<Object> list;
        DEFAULT_CONFLICT_STRATEGY = Strategy.DEFAULT;
        STRICT_MODE = Strategy.STRICT;
        ALLOW_SYSTEM_TZ_OVERRIDE = Boolean.getBoolean("net.time4j.allow.system.tz.override");
        NAME_DATA = null;
        SYSTEM_TZ_CURRENT = null;
        ACTIVE = true;
        SOFT_LIMIT = 11;
        CACHE = new ConcurrentHashMap<String, NamedReference>();
        QUEUE = new ReferenceQueue();
        LAST_USED = new LinkedList();
        try {
            list = Timezone.loadPredefined("AFRICA", "AMERICA", "AMERICA$ARGENTINA", "AMERICA$INDIANA", "AMERICA$KENTUCKY", "AMERICA$NORTH_DAKOTA", "ANTARCTICA", "ASIA", "ATLANTIC", "AUSTRALIA", "EUROPE", "INDIAN", "PACIFIC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            list = Collections.emptyList();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Z", ZonalOffset.UTC);
        hashMap.put("UT", ZonalOffset.UTC);
        hashMap.put("UTC", ZonalOffset.UTC);
        hashMap.put("GMT", ZonalOffset.UTC);
        for (Class classArray2 : list) {
            for (TZID tZID : (TZID[])classArray2.getEnumConstants()) {
                hashMap.put(tZID.canonical(), tZID);
            }
        }
        PREDEFINED = Collections.unmodifiableMap(hashMap);
        HashMap hashMap2 = new HashMap();
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        try {
            for (Class serviceLoader : list) {
                Method method = serviceLoader.getDeclaredMethod("getCountry", classArray);
                method.setAccessible(true);
                for (TZID tZID : (TZID[])serviceLoader.getEnumConstants()) {
                    String string = (String)method.invoke((Object)tZID, objectArray);
                    Timezone.addTerritory(hashMap2, string, tZID);
                }
            }
        }
        catch (IllegalAccessException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (NoSuchMethodException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
        if (list.isEmpty()) {
            System.out.println("Warning: olson-module is not available so there are no preferred timezones for any locale.");
        } else {
            illegalAccessException = new NamedID("Arctic/Longyearbyen");
            hashMap2.put("SJ", Collections.singleton(illegalAccessException));
        }
        TERRITORIES = Collections.unmodifiableMap(hashMap2);
        illegalAccessException = Thread.currentThread().getContextClassLoader();
        if (illegalAccessException == null) {
            illegalAccessException = ZoneProvider.class.getClassLoader();
        }
        ServiceLoader<ZoneProvider> serviceLoader = ServiceLoader.load(ZoneProvider.class, (ClassLoader)illegalAccessException);
        ZoneProvider zoneProvider = null;
        for (ZoneProvider zoneProvider2 : serviceLoader) {
            if (zoneProvider != null && zoneProvider2.getVersion().compareTo(zoneProvider.getVersion()) <= 0) continue;
            ZoneProvider zoneProvider3 = zoneProvider2;
            break;
        }
        PROVIDER = var7_21 == null ? new PlatformTZProvider() : var7_21;
        Object object = null;
        try {
            String string = System.getProperty("user.timezone");
            if ("Z".equals(string) || "UTC".equals(string)) {
                object = ZonalOffset.UTC.getModel();
            } else if (string != null) {
                object = Timezone.getTZ(new NamedID(string), false);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SYSTEM_TZ_ORIGINAL = object == null ? Timezone.getDefaultTZ() : object;
        if (ALLOW_SYSTEM_TZ_OVERRIDE) {
            SYSTEM_TZ_CURRENT = SYSTEM_TZ_ORIGINAL;
        }
        NAME_DATA = new NameData(PROVIDER);
    }

    private static enum Strategy implements TransitionStrategy
    {
        DEFAULT,
        STRICT;


        @Override
        public long resolve(GregorianDate gregorianDate, WallTime wallTime, Timezone timezone) {
            int n = gregorianDate.getYear();
            int n2 = gregorianDate.getMonth();
            int n3 = gregorianDate.getDayOfMonth();
            int n4 = wallTime.getHour();
            int n5 = wallTime.getMinute();
            int n6 = wallTime.getSecond();
            TransitionHistory transitionHistory = timezone.getHistory();
            if (transitionHistory != null) {
                long l = Strategy.toLocalSeconds(n, n2, n3, n4, n5, n6);
                ZonalTransition zonalTransition = transitionHistory.getConflictTransition(gregorianDate, wallTime);
                if (zonalTransition != null && zonalTransition.isGap()) {
                    if (this == STRICT) {
                        this.throwInvalidException(gregorianDate, wallTime, timezone);
                    }
                    l += (long)zonalTransition.getSize();
                }
                return l - (long)zonalTransition.getTotalOffset();
            }
            TimeZone timeZone = TimeZone.getTimeZone(timezone.getID().canonical());
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.set(14, 0);
            gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
            int n7 = gregorianCalendar.get(1);
            int n8 = gregorianCalendar.get(2) + 1;
            int n9 = gregorianCalendar.get(5);
            int n10 = gregorianCalendar.get(11);
            int n11 = gregorianCalendar.get(12);
            int n12 = gregorianCalendar.get(13);
            if (this == STRICT && (n != n7 || n2 != n8 || n3 != n9 || n4 != n10 || n5 != n11 || n6 != n12)) {
                this.throwInvalidException(gregorianDate, wallTime, timezone);
            }
            long l = Strategy.toLocalSeconds(n7, n8, n9, n10, n11, n12);
            return l - (long)timezone.getOffset(gregorianDate, wallTime).getIntegralAmount();
        }

        @Override
        public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime, Timezone timezone) {
            if (this == STRICT && timezone.isInvalid(gregorianDate, wallTime)) {
                this.throwInvalidException(gregorianDate, wallTime, timezone);
            }
            return timezone.getOffset(gregorianDate, wallTime);
        }

        private static long toLocalSeconds(int n, int n2, int n3, int n4, int n5, int n6) {
            long l = MathUtils.safeMultiply(MathUtils.safeSubtract(GregorianMath.toMJD(n, n2, n3), 40587L), 86400L);
            return l += (long)(n4 * 3600 + n5 * 60 + n6);
        }

        private void throwInvalidException(GregorianDate gregorianDate, WallTime wallTime, Timezone timezone) {
            throw new IllegalArgumentException("Invalid local timestamp due to timezone transition: " + gregorianDate + wallTime + " [" + timezone.getID() + "]");
        }
    }

    private static class PlatformTZProvider
    implements ZoneProvider {
        private PlatformTZProvider() {
        }

        @Override
        public Set<String> getAvailableIDs() {
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = TimeZone.getAvailableIDs();
            hashSet.addAll(Arrays.asList(stringArray));
            return hashSet;
        }

        @Override
        public Map<String, String> getAliases() {
            return Collections.emptyMap();
        }

        @Override
        public boolean isFallbackEnabled() {
            return false;
        }

        @Override
        public String getName() {
            return "java.util.TimeZone";
        }

        @Override
        public String getLocation() {
            return "";
        }

        @Override
        public String getVersion() {
            return "";
        }

        @Override
        public TransitionHistory load(String string, boolean bl) {
            return null;
        }
    }

    private static class NameData {
        private final Map<String, String> aliases;
        private final List<TZID> availables;

        NameData(ZoneProvider zoneProvider) {
            Set<String> set = zoneProvider.getAvailableIDs();
            ArrayList<TZID> arrayList = new ArrayList<TZID>();
            arrayList.add(ZonalOffset.UTC);
            for (String string : set) {
                TZID tZID = (TZID)PREDEFINED.get(string);
                if (tZID == null) {
                    arrayList.add(new NamedID(string));
                    continue;
                }
                if (tZID == ZonalOffset.UTC) continue;
                arrayList.add(tZID);
            }
            Collections.sort(arrayList, new Comparator<TZID>(){

                @Override
                public int compare(TZID tZID, TZID tZID2) {
                    return tZID.canonical().compareTo(tZID2.canonical());
                }
            });
            this.availables = Collections.unmodifiableList(arrayList);
            this.aliases = Collections.unmodifiableMap(new HashMap<String, String>(zoneProvider.getAliases()));
        }
    }

    private static class NamedID
    implements TZID,
    Serializable {
        private static final long serialVersionUID = -4889632013137688471L;
        private final String tzid;

        NamedID(String string) {
            this.tzid = string;
        }

        @Override
        public String canonical() {
            return this.tzid;
        }

        public boolean equals(Object object) {
            if (object instanceof NamedID) {
                NamedID namedID = (NamedID)object;
                return this.tzid.equals(namedID.tzid);
            }
            return false;
        }

        public int hashCode() {
            return this.tzid.hashCode();
        }

        public String toString() {
            return this.getClass().getName() + "@" + this.tzid;
        }
    }

    private static class NamedReference
    extends SoftReference<Timezone> {
        private final String tzid;

        NamedReference(Timezone timezone, ReferenceQueue<Timezone> referenceQueue) {
            super(timezone, referenceQueue);
            this.tzid = timezone.getID().canonical();
        }
    }

    public static class Cache {
        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void refresh() {
            Class<Timezone> clazz = Timezone.class;
            synchronized (Timezone.class) {
                while (QUEUE.poll() != null) {
                }
                LAST_USED.clear();
                // ** MonitorExit[var0] (shouldn't be in output)
                NAME_DATA = new NameData(PROVIDER);
                CACHE.clear();
                if (ALLOW_SYSTEM_TZ_OVERRIDE) {
                    SYSTEM_TZ_CURRENT = Timezone.getDefaultTZ();
                }
                return;
            }
        }

        public static void setCacheActive(boolean bl) {
            ACTIVE = bl;
            if (!bl) {
                CACHE.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setMinimumCacheSize(int n) {
            NamedReference namedReference;
            if (n < 0) {
                throw new IllegalArgumentException("Negative timezone cache size: " + n);
            }
            while ((namedReference = (NamedReference)QUEUE.poll()) != null) {
                CACHE.remove(namedReference.tzid);
            }
            Class<Timezone> clazz = Timezone.class;
            synchronized (Timezone.class) {
                SOFT_LIMIT = n + 1;
                int n2 = LAST_USED.size() - n;
                for (int i = 0; i < n2; ++i) {
                    LAST_USED.removeLast();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

