/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.format.ChronoFormatter;
import net.time4j.format.ChronoParser;
import net.time4j.format.ChronoPrinter;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.ParseLog;

final class CustomizedProcessor<V>
implements FormatProcessor<V> {
    private static final ChronoFunction<ChronoDisplay, Void> NO_RESULT = new ChronoFunction<ChronoDisplay, Void>(){

        @Override
        public Void apply(ChronoDisplay chronoDisplay) {
            return null;
        }
    };
    private final ChronoElement<V> element;
    private final ChronoPrinter<V> printer;
    private final ChronoParser<V> parser;

    CustomizedProcessor(ChronoElement<V> chronoElement, ChronoPrinter<V> chronoPrinter, ChronoParser<V> chronoParser) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (chronoPrinter == null) {
            throw new NullPointerException("Missing printer.");
        }
        if (chronoParser == null) {
            throw new NullPointerException("Missing parser.");
        }
        this.element = chronoElement;
        this.printer = chronoPrinter;
        this.parser = chronoParser;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        V v = chronoDisplay.get(this.element);
        StringBuilder stringBuilder = new StringBuilder();
        if (appendable instanceof CharSequence && set != null) {
            int n = ((CharSequence)((Object)appendable)).length();
            if (this.printer instanceof ChronoFormatter) {
                ChronoFormatter chronoFormatter = (ChronoFormatter)ChronoFormatter.class.cast(this.printer);
                Set<ElementPosition> set2 = CustomizedProcessor.print(chronoFormatter, v, stringBuilder, attributeQuery);
                LinkedHashSet<ElementPosition> linkedHashSet = new LinkedHashSet<ElementPosition>();
                for (ElementPosition elementPosition : set2) {
                    linkedHashSet.add(new ElementPosition(elementPosition.getElement(), n + elementPosition.getStartIndex(), n + elementPosition.getEndIndex()));
                }
                set.addAll(linkedHashSet);
            } else {
                this.printer.print(v, stringBuilder, attributeQuery, NO_RESULT);
                set.add(new ElementPosition(this.element, n, n + stringBuilder.length()));
            }
        } else {
            this.printer.print(v, stringBuilder, attributeQuery, NO_RESULT);
        }
        appendable.append(stringBuilder);
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n = parseLog.getPosition();
        try {
            AttributeQuery attributeQuery2 = formatStep.getQuery(attributeQuery);
            V v = this.parser.parse(charSequence, parseLog, attributeQuery2);
            if (v == null) {
                parseLog.setError(n, parseLog.getErrorMessage());
            } else {
                map.put(this.element, v);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            parseLog.setError(n, indexOutOfBoundsException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CustomizedProcessor) {
            CustomizedProcessor customizedProcessor = (CustomizedProcessor)object;
            return this.element.equals(customizedProcessor.element) && this.printer.equals(customizedProcessor.printer) && this.parser.equals(customizedProcessor.parser);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * this.printer.hashCode() + 37 * this.parser.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", printer=");
        stringBuilder.append(this.printer);
        stringBuilder.append(", parser=");
        stringBuilder.append(this.parser);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new CustomizedProcessor<V>(chronoElement, this.printer, this.parser);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private static <T extends ChronoEntity<T>> Set<ElementPosition> print(ChronoFormatter<T> chronoFormatter, Object object, StringBuilder stringBuilder, AttributeQuery attributeQuery) throws IOException {
        return chronoFormatter.print((ChronoEntity)chronoFormatter.getChronology().getChronoType().cast(object), stringBuilder, attributeQuery);
    }
}

