/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.text.ParseException;
import net.time4j.Iso8601Format;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.ZOM;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoFunction;
import net.time4j.format.Attributes;
import net.time4j.format.ChronoFormatter;
import net.time4j.format.ChronoParser;
import net.time4j.format.ChronoPrinter;
import net.time4j.format.ParseLog;
import net.time4j.scale.TimeScale;
import net.time4j.scale.UniversalTime;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class ZonalMoment
implements ChronoDisplay,
UniversalTime {
    private static final ChronoFunction<ChronoDisplay, Void> NO_RESULT = new ChronoFunction<ChronoDisplay, Void>(){

        @Override
        public Void apply(ChronoDisplay chronoDisplay) {
            return null;
        }
    };
    private final Moment moment;
    private final Timezone zone;
    private final transient PlainTimestamp timestamp;

    private ZonalMoment(Moment moment, Timezone timezone) {
        this.zone = timezone;
        ZonalOffset zonalOffset = timezone.getOffset(moment);
        if (moment.isLeapSecond() && (zonalOffset.getFractionalAmount() != 0 || zonalOffset.getAbsoluteSeconds() % 60 != 0)) {
            throw new IllegalArgumentException("Leap second can only be represented  with timezone-offset in full minutes: " + zonalOffset);
        }
        this.moment = moment;
        this.timestamp = PlainTimestamp.from(moment, zonalOffset);
    }

    private ZonalMoment(PlainTimestamp plainTimestamp, ZonalOffset zonalOffset) {
        this.moment = plainTimestamp.at(zonalOffset);
        this.zone = Timezone.of(zonalOffset);
        this.timestamp = plainTimestamp;
    }

    static ZonalMoment of(Moment moment, Timezone timezone) {
        return new ZonalMoment(moment, timezone);
    }

    static ZonalMoment of(PlainTimestamp plainTimestamp, ZonalOffset zonalOffset) {
        return new ZonalMoment(plainTimestamp, zonalOffset);
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        return this.timestamp.contains(chronoElement) || this.moment.contains(chronoElement);
    }

    @Override
    public <V> V get(ChronoElement<V> chronoElement) {
        if (this.moment.isLeapSecond() && chronoElement == PlainTime.SECOND_OF_MINUTE) {
            return chronoElement.getType().cast(60);
        }
        if (this.timestamp.contains(chronoElement)) {
            return this.timestamp.get(chronoElement);
        }
        return this.moment.get(chronoElement);
    }

    @Override
    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        if (this.timestamp.contains(chronoElement)) {
            return this.timestamp.getMinimum(chronoElement);
        }
        return this.moment.getMinimum(chronoElement);
    }

    @Override
    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        Moment moment;
        Moment moment2;
        PlainTimestamp plainTimestamp;
        V v = this.timestamp.contains(chronoElement) ? this.timestamp.getMaximum(chronoElement) : this.moment.getMaximum(chronoElement);
        if (chronoElement == PlainTime.SECOND_OF_MINUTE && this.timestamp.getYear() >= 1972 && !this.zone.isInvalid(plainTimestamp = (PlainTimestamp)this.timestamp.with(chronoElement, v), plainTimestamp) && (moment2 = (moment = plainTimestamp.in(this.zone)).plus(1L, SI.SECONDS)).isLeapSecond()) {
            return chronoElement.getType().cast(60);
        }
        return v;
    }

    @Override
    public boolean hasTimezone() {
        return true;
    }

    @Override
    public TZID getTimezone() {
        return this.zone.getID();
    }

    public ZonalOffset getOffset() {
        return this.zone.getOffset(this.moment);
    }

    public Moment toMoment() {
        return this.moment;
    }

    public PlainTimestamp toTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getElapsedTime(TimeScale timeScale) {
        return this.moment.getElapsedTime(timeScale);
    }

    @Override
    public int getNanosecond(TimeScale timeScale) {
        return this.moment.getNanosecond(timeScale);
    }

    @Override
    public boolean isLeapSecond() {
        return this.moment.isLeapSecond();
    }

    @Override
    public long getPosixTime() {
        return this.moment.getPosixTime();
    }

    @Override
    public int getNanosecond() {
        return this.moment.getNanosecond();
    }

    public String print(ChronoPrinter<Moment> chronoPrinter) {
        ZOM zOM = new ZOM(this, ZonalMoment.getAttributes(chronoPrinter));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            chronoPrinter.print(this.moment, stringBuilder, zOM, NO_RESULT);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    public static ZonalMoment parse(String string, ChronoParser<Moment> chronoParser) throws ParseException {
        Timezone timezone;
        ParseLog parseLog = new ParseLog();
        AttributeQuery attributeQuery = ZonalMoment.getAttributes(chronoParser);
        Moment moment = chronoParser.parse(string, parseLog, attributeQuery);
        if (moment == null) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getRawValues().hasTimezone()) {
            timezone = ZonalMoment.toTimezone(parseLog.getRawValues().getTimezone(), string);
        } else if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
            timezone = ZonalMoment.toTimezone(attributeQuery.get(Attributes.TIMEZONE_ID), string);
        } else {
            throw new ParseException("Missing timezone: " + string, 0);
        }
        return ZonalMoment.of(moment, timezone);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonalMoment) {
            ZonalMoment zonalMoment = (ZonalMoment)object;
            return this.moment.equals(zonalMoment.moment) && this.zone.equals(zonalMoment.zone);
        }
        return false;
    }

    public int hashCode() {
        return this.moment.hashCode() ^ this.zone.hashCode();
    }

    public String toString() {
        return this.print(Iso8601Format.EXTENDED_DATE_TIME_OFFSET);
    }

    private static AttributeQuery getAttributes(Object object) {
        if (object instanceof ChronoFormatter) {
            return ((ChronoFormatter)ChronoFormatter.class.cast(object)).getDefaultAttributes();
        }
        return Attributes.empty();
    }

    private static Timezone toTimezone(TZID tZID, String string) throws ParseException {
        try {
            return Timezone.of(tZID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ParseException parseException = new ParseException("Timezone error: " + string, 0);
            parseException.initCause(illegalArgumentException);
            throw parseException;
        }
    }
}

