/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.tz.TZID;

public class RawValues
implements Consumer<ChronoDisplay>,
Supplier<ChronoDisplay> {
    private ChronoDisplay rawValues = new EmptyRawValues();

    @Override
    public void accept(ChronoDisplay chronoDisplay) {
        if (chronoDisplay == null) {
            throw new NullPointerException("Missing raw values.");
        }
        this.rawValues = chronoDisplay;
    }

    @Override
    public ChronoDisplay get() {
        return this.rawValues;
    }

    private static class EmptyRawValues
    implements ChronoDisplay {
        private EmptyRawValues() {
        }

        @Override
        public boolean contains(ChronoElement<?> chronoElement) {
            return false;
        }

        @Override
        public <V> V get(ChronoElement<V> chronoElement) {
            throw new ChronoException("Not supported:" + chronoElement.name());
        }

        @Override
        public int getInt(ChronoElement<Integer> chronoElement) {
            return Integer.MIN_VALUE;
        }

        @Override
        public <V> V getMinimum(ChronoElement<V> chronoElement) {
            throw new ChronoException("Not supported:" + chronoElement.name());
        }

        @Override
        public <V> V getMaximum(ChronoElement<V> chronoElement) {
            throw new ChronoException("Not supported:" + chronoElement.name());
        }

        @Override
        public boolean hasTimezone() {
            return false;
        }

        @Override
        public TZID getTimezone() {
            throw new ChronoException("Timezone does not exist.");
        }

        public String toString() {
            return "raw-values={}";
        }
    }
}

