/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.Serializable;
import net.time4j.Moment;
import net.time4j.calendar.astro.AstroUtils;
import net.time4j.calendar.astro.EquatorialCoordinates;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.calendar.astro.Zodiac;

public class MoonPosition
implements EquatorialCoordinates,
Serializable {
    private static final int[] A_D = new int[]{0, 2, 2, 0, 0, 0, 2, 2, 2, 2, 0, 1, 0, 2, 0, 0, 4, 0, 4, 2, 2, 1, 1, 2, 2, 4, 2, 0, 2, 2, 1, 2, 0, 0, 2, 2, 2, 4, 0, 3, 2, 4, 0, 2, 2, 2, 4, 0, 4, 1, 2, 0, 1, 3, 4, 2, 0, 1, 2, 2};
    private static final int[] A_M = new int[]{0, 0, 0, 0, 1, 0, 0, -1, 0, -1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, -1, 0, 0, 0, 1, 0, -1, 0, -2, 1, 2, -2, 0, 0, -1, 0, 0, 1, -1, 2, 2, 1, -1, 0, 0, -1, 0, 1, 0, 1, 0, 0, -1, 2, 1, 0, 0};
    private static final int[] A_M2 = new int[]{1, -1, 0, 2, 0, 0, -2, -1, 1, 0, -1, 0, 1, 0, 1, 1, -1, 3, -2, -1, 0, -1, 0, 1, 2, 0, -3, -2, -1, -2, 1, 0, 2, 0, -1, 1, 0, -1, 2, -1, 1, -2, -1, -1, -2, 0, 1, 4, 0, -2, 0, 2, 1, -2, -3, 2, 1, -1, 3, -1};
    private static final int[] A_F = new int[]{0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, -2, 2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, -2, 2, 0, 2, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, -2, -2, 0, 0, 0, 0, 0, 0, 0, -2};
    private static final int[] COEFF_L = new int[]{6288774, 1274027, 658314, 213618, -185116, -114332, 58793, 57066, 53322, 45758, -40923, -34720, -30383, 15327, -12528, 10980, 10675, 10034, 8548, -7888, -6766, -5163, 4987, 4036, 3994, 3861, 3665, -2689, -2602, 2390, -2348, 2236, -2120, -2069, 2048, -1773, -1595, 1215, -1110, -892, -810, 759, -713, -700, 691, 596, 549, 537, 520, -487, -399, -381, 351, -340, 330, 327, -323, 299, 294, 0};
    private static final int[] COEFF_R = new int[]{-20905355, -3699111, -2955968, -569925, 48888, -3149, 246158, -152138, -170733, -204586, -129620, 108743, 104755, 10321, 0, 79661, -34782, -23210, -21636, 24208, 30824, -8379, -16675, -12831, -10445, -11650, 14403, -7003, 0, 10056, 6322, -9884, 5751, 0, -4950, 4130, 0, -3958, 0, 3258, 2616, -1897, -2117, 2354, 0, 0, -1423, -1117, -1571, -1739, 0, -4421, 0, 0, 0, 0, 1165, 0, 0, 8752};
    private static final int[] B_D = new int[]{0, 0, 0, 2, 2, 2, 2, 0, 2, 0, 2, 2, 2, 2, 2, 2, 2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 1, 0, 4, 4, 0, 4, 2, 2, 2, 2, 0, 2, 2, 2, 2, 4, 2, 2, 0, 2, 1, 1, 0, 2, 1, 2, 0, 4, 4, 1, 4, 1, 4, 2};
    private static final int[] B_M = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, -1, -1, -1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1, 1, 0, -1, -2, 0, 1, 1, 1, 1, 1, 0, -1, 1, 0, -1, 0, 0, 0, -1, -2};
    private static final int[] B_M2 = new int[]{0, 1, 1, 0, -1, -1, 0, 2, 1, 2, 0, -2, 1, 0, -1, 0, -1, -1, -1, 0, 0, -1, 0, 1, 1, 0, 0, 3, 0, -1, 1, -2, 0, 2, 1, -2, 3, 2, -3, -1, 0, 0, 1, 0, 1, 1, 0, 0, -2, -1, 1, -2, 2, -2, -1, 1, 1, -1, 0, 0};
    private static final int[] B_F = new int[]{1, 1, -1, -1, 1, -1, 1, 1, -1, -1, -1, -1, 1, -1, 1, 1, -1, -1, -1, 1, 3, 1, 1, 1, -1, -1, -1, 1, -1, 1, -3, 1, -3, -1, -1, 1, -1, 1, -1, 1, 1, 1, 1, -1, 3, -1, -1, 1, -1, -1, 1, -1, 1, -1, -1, -1, -1, -1, -1, 1};
    private static final int[] COEFF_B = new int[]{5128122, 280602, 277693, 173237, 55413, 46271, 32573, 17198, 9266, 8822, 8216, 4324, 4200, -3359, 2463, 2211, 2065, -1870, 1828, -1794, -1749, -1565, -1491, -1475, -1410, -1344, -1335, 1107, 1021, 833, 777, 671, 607, 596, 491, -451, 439, 422, 421, -366, -351, 331, 315, 302, -283, -229, 223, 223, -220, -220, -185, 181, -177, 176, 166, -164, 132, -119, 115, 107};
    private static final int MIO = 1000000;
    private static final long serialVersionUID = 5736859564589473324L;
    private final double rightAscension;
    private final double declination;
    private final double azimuth;
    private final double elevation;
    private final double distance;

    private MoonPosition(double d, double d2, double d3, double d4, double d5) {
        this.rightAscension = d;
        this.declination = d2;
        this.azimuth = d3;
        this.elevation = d4;
        this.distance = d5;
    }

    public static MoonPosition at(Moment moment, GeoLocation geoLocation) {
        double d;
        double d2;
        double[] dArray = MoonPosition.calculateMeeus(JulianDay.ofEphemerisTime(moment).getCenturyJ2000());
        double d3 = Math.toRadians(dArray[2]);
        double d4 = Math.toRadians(dArray[3]);
        double d5 = dArray[4];
        double d6 = Math.toRadians(geoLocation.getLatitude());
        double d7 = Math.toRadians(geoLocation.getLongitude());
        double d8 = Math.cos(d6);
        double d9 = Math.sin(d6);
        int n = geoLocation.getAltitude();
        double d10 = JulianDay.ofMeanSolarTime(moment).getMJD();
        double d11 = dArray[0] * Math.cos(Math.toRadians(dArray[1]));
        double d12 = AstroUtils.gmst(d10) + Math.toRadians(d11) + d7 - d3;
        double d13 = d9 * Math.sin(d4) + d8 * Math.cos(d4) * Math.cos(d12);
        double d14 = Math.toDegrees(Math.asin(d13));
        if (d14 >= -0.5 - (d2 = StdSolarCalculator.TIME4J.getGeodeticAngle(geoLocation.getLatitude(), n))) {
            d = Math.toDegrees(Math.asin(6378.14 / d5));
            double d15 = AstroUtils.refractionFactorOfStdAtmosphere(n);
            double d16 = d15 * AstroUtils.getRefraction(d14) / 60.0;
            d14 = d14 - d + d16;
        }
        d = Math.toDegrees(Math.atan2(Math.sin(d12), Math.cos(d12) * d9 - Math.tan(d4) * d8)) + 180.0;
        return new MoonPosition(dArray[2], dArray[3], d, d14, d5);
    }

    public static Zodiac.Event inConstellationOf(Zodiac zodiac) {
        return Zodiac.Event.ofConstellation('L', zodiac);
    }

    public static Zodiac.Event inSignOf(Zodiac zodiac) {
        return Zodiac.Event.ofSign('L', zodiac);
    }

    @Override
    public double getRightAscension() {
        return this.rightAscension;
    }

    @Override
    public double getDeclination() {
        return this.declination;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MoonPosition) {
            MoonPosition moonPosition = (MoonPosition)object;
            return this.rightAscension == moonPosition.rightAscension && this.declination == moonPosition.declination && this.azimuth == moonPosition.azimuth && this.elevation == moonPosition.elevation && this.distance == moonPosition.distance;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.rightAscension) + 31 * Double.hashCode(this.declination) + 37 * Double.hashCode(this.distance);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("moon-position[ra=");
        stringBuilder.append(this.rightAscension);
        stringBuilder.append(",decl=");
        stringBuilder.append(this.declination);
        stringBuilder.append(",azimuth=");
        stringBuilder.append(this.azimuth);
        stringBuilder.append(",elevation=");
        stringBuilder.append(this.elevation);
        stringBuilder.append(",distance=");
        stringBuilder.append(this.distance);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static double[] calculateMeeus(double d) {
        double d2;
        double d3 = MoonPosition.normalize(218.3164477 + (481267.88123421 + (-0.0015786 + (1.855835023689734E-6 + -1.5338834862103876E-8 * d) * d) * d) * d);
        double d4 = MoonPosition.normalize(297.8501921 + (445267.1114034 + (-0.0018819 + (1.8319447192361523E-6 + 8.844469995135542E-9 * d) * d) * d) * d);
        double d5 = MoonPosition.normalize(357.5291092 + (35999.0502909 + (-1.536E-4 + 4.083299305839118E-8 * d) * d) * d);
        double d6 = MoonPosition.normalize(134.9633964 + (477198.8675055 + (0.0087414 + (1.4347408140719379E-5 + 6.797172376291463E-8 * d) * d) * d) * d);
        double d7 = MoonPosition.normalize(93.272095 + (483202.0175233 + (-0.0036539 + (-2.8360748723766307E-7 + 1.1583324645839848E-9 * d) * d) * d) * d);
        double d8 = 1.0 - (0.002516 + 7.4E-6 * d) * d;
        double d9 = d8 * d8;
        double d10 = 0.0;
        double d11 = 0.0;
        for (int i = A_D.length - 1; i >= 0; --i) {
            double d12;
            switch (A_M[i]) {
                case -1: 
                case 1: {
                    d12 = d8;
                    break;
                }
                case -2: 
                case 2: {
                    d12 = d9;
                    break;
                }
                default: {
                    d12 = 1.0;
                }
            }
            d2 = Math.toRadians((double)A_D[i] * d4 + (double)A_M[i] * d5 + (double)A_M2[i] * d6 + (double)A_F[i] * d7);
            d10 += (double)COEFF_L[i] * d12 * Math.sin(d2);
            d11 += (double)COEFF_R[i] * d12 * Math.cos(d2);
        }
        double d13 = 0.0;
        for (int i = B_D.length - 1; i >= 0; --i) {
            switch (B_M[i]) {
                case -1: 
                case 1: {
                    d2 = d8;
                    break;
                }
                case -2: 
                case 2: {
                    d2 = d9;
                    break;
                }
                default: {
                    d2 = 1.0;
                }
            }
            double d14 = (double)B_D[i] * d4 + (double)B_M[i] * d5 + (double)B_M2[i] * d6 + (double)B_F[i] * d7;
            d13 += (double)COEFF_B[i] * d2 * Math.sin(Math.toRadians(d14));
        }
        double d15 = 119.75 + 131.849 * d;
        double d16 = 53.09 + 479264.29 * d;
        double d17 = 313.45 + 481266.484 * d;
        d10 += 3958.0 * Math.sin(Math.toRadians(d15)) + 1962.0 * Math.sin(Math.toRadians(d3 - d7)) + 318.0 * Math.sin(Math.toRadians(d16));
        d13 += -2235.0 * Math.sin(Math.toRadians(d3)) + 382.0 * Math.sin(Math.toRadians(d17)) + 175.0 * Math.sin(Math.toRadians(d15 - d7)) + 175.0 * Math.sin(Math.toRadians(d15 + d7)) + 127.0 * Math.sin(Math.toRadians(d3 - d6)) - 115.0 * Math.sin(Math.toRadians(d3 + d6));
        double[] dArray = new double[5];
        StdSolarCalculator.nutations(d, dArray);
        double d18 = StdSolarCalculator.meanObliquity(d) + dArray[1];
        double d19 = Math.toRadians(d18);
        double d20 = Math.toRadians(d3 + d10 / 1000000.0 + dArray[0]);
        double d21 = Math.toRadians(d13 / 1000000.0);
        double d22 = 385000.56 + d11 / 1000.0;
        double d23 = Math.atan2(Math.sin(d20) * Math.cos(d19) - Math.tan(d21) * Math.sin(d19), Math.cos(d20));
        double d24 = Math.asin(Math.sin(d21) * Math.cos(d19) + Math.cos(d21) * Math.sin(d19) * Math.sin(d20));
        dArray[1] = d18;
        dArray[2] = AstroUtils.toRange_0_360(Math.toDegrees(d23));
        dArray[3] = Math.toDegrees(d24);
        dArray[4] = d22;
        return dArray;
    }

    static double lunarLongitude(double d) {
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = MoonPosition.normalize(218.3164477 + (481267.88123421 + (-0.0015786 + (1.855835023689734E-6 + -1.5338834862103876E-8 * d2) * d2) * d2) * d2);
        double d4 = MoonPosition.normalize(297.8501921 + (445267.1114034 + (-0.0018819 + (1.8319447192361523E-6 + 8.844469995135542E-9 * d2) * d2) * d2) * d2);
        double d5 = MoonPosition.normalize(357.5291092 + (35999.0502909 + (-1.536E-4 + 4.083299305839118E-8 * d2) * d2) * d2);
        double d6 = MoonPosition.normalize(134.9633964 + (477198.8675055 + (0.0087414 + (1.4347408140719379E-5 + 6.797172376291463E-8 * d2) * d2) * d2) * d2);
        double d7 = MoonPosition.normalize(93.272095 + (483202.0175233 + (-0.0036539 + (-2.8360748723766307E-7 + 1.1583324645839848E-9 * d2) * d2) * d2) * d2);
        double d8 = 1.0 - (0.002516 + 7.4E-6 * d2) * d2;
        double d9 = d8 * d8;
        double d10 = 0.0;
        for (int i = A_D.length - 1; i >= 0; --i) {
            double d11;
            switch (A_M[i]) {
                case -1: 
                case 1: {
                    d11 = d8;
                    break;
                }
                case -2: 
                case 2: {
                    d11 = d9;
                    break;
                }
                default: {
                    d11 = 1.0;
                }
            }
            double d12 = Math.toRadians((double)A_D[i] * d4 + (double)A_M[i] * d5 + (double)A_M2[i] * d6 + (double)A_F[i] * d7);
            d10 += (double)COEFF_L[i] * d11 * Math.sin(d12);
        }
        double d13 = 119.75 + 131.849 * d2;
        double d14 = 53.09 + 479264.29 * d2;
        double[] dArray = new double[5];
        StdSolarCalculator.nutations(d2, dArray);
        return AstroUtils.toRange_0_360(d3 + (d10 += 3958.0 * Math.sin(Math.toRadians(d13)) + 1962.0 * Math.sin(Math.toRadians(d3 - d7)) + 318.0 * Math.sin(Math.toRadians(d14))) / 1000000.0 + dArray[0]);
    }

    private static double normalize(double d) {
        return d - 360.0 * Math.floor(d / 360.0);
    }
}

