/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.format.Attributes;
import net.time4j.format.TextElement;
import net.time4j.format.internal.PropertyBundle;

public final class Tabot
implements Comparable<Tabot> {
    private static final String[] TRANSSCRIPTION;
    private static final String[] AMHARIC;
    private static final Tabot[] INSTANCES;
    private final int index;

    private Tabot(int n) {
        this.index = n;
    }

    public static List<Tabot> asList() {
        return Collections.unmodifiableList(Arrays.asList(INSTANCES));
    }

    public static Tabot of(int n) {
        if (n < 1 || n > 30) {
            throw new IllegalArgumentException("Out of range 1-30: " + n);
        }
        return INSTANCES[n - 1];
    }

    public int getDayOfMonth() {
        return this.index;
    }

    public String getDisplayName(Locale locale) {
        if (locale.getLanguage().equals("am")) {
            return AMHARIC[this.index - 1];
        }
        return TRANSSCRIPTION[this.index - 1];
    }

    @Override
    public int compareTo(Tabot tabot) {
        return this.index - tabot.index;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Tabot) {
            return this.index == ((Tabot)object).index;
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.index).hashCode();
    }

    public String toString() {
        return "Tabot of day-of-month " + this.index;
    }

    static {
        PropertyBundle propertyBundle = PropertyBundle.load("names/ethiopic", Locale.ROOT);
        PropertyBundle propertyBundle2 = PropertyBundle.load("names/ethiopic", new Locale("am"));
        String[] stringArray = new String[30];
        String[] stringArray2 = new String[30];
        Tabot[] tabotArray = new Tabot[30];
        for (int i = 0; i < 30; ++i) {
            String string = "T_" + String.valueOf(i + 1);
            stringArray[i] = propertyBundle.getString(string);
            stringArray2[i] = propertyBundle2.getString(string);
            tabotArray[i] = new Tabot(i + 1);
        }
        TRANSSCRIPTION = stringArray;
        AMHARIC = stringArray2;
        INSTANCES = tabotArray;
    }

    static enum Element implements TextElement<Tabot>
    {
        TABOT;


        @Override
        public Class<Tabot> getType() {
            return Tabot.class;
        }

        @Override
        public char getSymbol() {
            return '\u0000';
        }

        @Override
        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            return chronoDisplay.get(TABOT).getDayOfMonth() - chronoDisplay2.get(TABOT).getDayOfMonth();
        }

        @Override
        public Tabot getDefaultMinimum() {
            return Tabot.of(1);
        }

        @Override
        public Tabot getDefaultMaximum() {
            return Tabot.of(30);
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public boolean isLenient() {
            return false;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
            appendable.append(chronoDisplay.get(TABOT).getDisplayName(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT)));
        }

        @Override
        public Tabot parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n = parsePosition.getIndex();
            for (int i = 1; i <= 30; ++i) {
                String string = Tabot.of(i).getDisplayName(locale);
                int n2 = string.length();
                if (n + n2 > charSequence.length() || !string.equals(charSequence.subSequence(n, n + n2).toString())) continue;
                parsePosition.setIndex(n + n2);
                return Tabot.of(i);
            }
            return null;
        }
    }
}

