/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SystemClock;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="hebrew")
public final class HebrewTime
extends TimePoint<Unit, HebrewTime>
implements Temporal<HebrewTime> {
    private static final int PARTS_IN_HOUR = 1080;
    private static final int HOUR12_INDEX = 0;
    private static final int HOUR23_INDEX = 1;
    private static final int PART_INDEX = 2;
    @FormattableElement(format="c")
    public static final ChronoElement<ClockCycle> CLOCK_CYCLE = new StdEnumDateElement<ClockCycle, HebrewTime>("CLOCK_CYCLE", HebrewTime.class, ClockCycle.class, 'c');
    @FormattableElement(format="h")
    public static final StdCalendarElement<Integer, HebrewTime> CLOCK_HOUR = new StdIntegerDateElement<HebrewTime>("CLOCK_HOUR", HebrewTime.class, 1, 12, 'h', new UnitOperator(Unit.HOURS, true), new UnitOperator(Unit.HOURS, false));
    @FormattableElement(format="H")
    public static final StdCalendarElement<Integer, HebrewTime> DIGITAL_HOUR = new StdIntegerDateElement<HebrewTime>("DIGITAL_HOUR", HebrewTime.class, 0, 23, 'H', new UnitOperator(Unit.HOURS, true), new UnitOperator(Unit.HOURS, false));
    @FormattableElement(format="P")
    public static final StdCalendarElement<Integer, HebrewTime> PART_OF_HOUR = new StdIntegerDateElement<HebrewTime>("PART_OF_HOUR", HebrewTime.class, 0, 1079, 'P', new UnitOperator(Unit.HALAKIM, true), new UnitOperator(Unit.HALAKIM, false));
    private static final HebrewTime MIN = new HebrewTime(0, 0);
    private static final HebrewTime MAX = new HebrewTime(23, 1079);
    private static final TimeAxis<Unit, HebrewTime> ENGINE;
    private static final long serialVersionUID = -6206874394178665128L;
    private final transient int hour23;
    private final transient int part;

    private HebrewTime(ClockCycle clockCycle, int n, int n2) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("CLOCK_HOUR out of range: " + n);
        }
        if (n2 < 0 || n2 >= 1080) {
            throw new IllegalArgumentException("PART_OF_HOUR out of range: " + n2);
        }
        int n3 = n == 12 ? 0 : n;
        this.hour23 = clockCycle.equals((Object)ClockCycle.NIGHT) ? n3 : n3 + 12;
        this.part = n2;
    }

    private HebrewTime(int n, int n2) {
        this.hour23 = n;
        this.part = n2;
    }

    public static HebrewTime ofDigital(int n, int n2) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("DIGITAL_HOUR out of range: " + n);
        }
        if (n2 < 0 || n2 >= 1080) {
            throw new IllegalArgumentException("PART_OF_HOUR out of range: " + n2);
        }
        return new HebrewTime(n, n2);
    }

    public static HebrewTime ofNight(int n, int n2) {
        return new HebrewTime(ClockCycle.NIGHT, n, n2);
    }

    public static HebrewTime ofDay(int n, int n2) {
        return new HebrewTime(ClockCycle.DAY, n, n2);
    }

    public static Optional<HebrewTime> now(SolarTime solarTime) {
        return HebrewTime.at(solarTime).apply(SystemClock.currentMoment());
    }

    public static HebrewTime nowInSystemTime() {
        return (HebrewTime)SystemClock.inLocalView().now(HebrewTime.axis());
    }

    public static ChronoFunction<Moment, Optional<HebrewTime>> at(SolarTime solarTime) {
        return moment -> {
            ZonalOffset zonalOffset = ZonalOffset.atLongitude(new BigDecimal(solarTime.getLongitude()));
            PlainTimestamp plainTimestamp = moment.toZonalTimestamp(zonalOffset);
            Optional<Moment> optional = plainTimestamp.toDate().get(solarTime.sunset());
            if (optional.isPresent()) {
                ClockCycle clockCycle = null;
                Moment moment2 = null;
                Moment moment3 = null;
                if (moment.isBefore(optional.get())) {
                    Optional<Moment> optional2 = plainTimestamp.toDate().get(solarTime.sunrise());
                    if (optional2.isPresent()) {
                        if (moment.isBefore(optional2.get())) {
                            optional = plainTimestamp.toDate().minus(1L, CalendarUnit.DAYS).get(solarTime.sunset());
                            if (optional.isPresent()) {
                                clockCycle = ClockCycle.NIGHT;
                                moment2 = optional.get();
                                moment3 = optional2.get();
                            }
                        } else {
                            clockCycle = ClockCycle.DAY;
                            moment2 = optional2.get();
                            moment3 = optional.get();
                        }
                    }
                } else {
                    Optional<Moment> optional3 = plainTimestamp.toDate().plus(1L, CalendarUnit.DAYS).get(solarTime.sunrise());
                    if (optional3.isPresent()) {
                        clockCycle = ClockCycle.NIGHT;
                        moment2 = optional.get();
                        moment3 = optional3.get();
                    }
                }
                if (clockCycle != null && moment2 != null && moment3 != null) {
                    long l = moment2.until(moment3, TimeUnit.SECONDS) * 1000000000L + (long)moment3.getNanosecond() - (long)moment2.getNanosecond();
                    long l2 = moment2.until(moment, TimeUnit.SECONDS) * 1000000000L + (long)moment.getNanosecond() - (long)moment2.getNanosecond();
                    double d = 12960.0 * (double)l2 / (double)l;
                    int n = (int)Math.floor(d / 1080.0);
                    int n2 = (int)Math.floor(d - (double)(n * 1080));
                    return Optional.of(new HebrewTime(clockCycle, n == 0 ? 12 : n, n2));
                }
            }
            return Optional.empty();
        };
    }

    public static ChronoFunction<Moment, HebrewTime> at(TZID tZID) {
        return moment -> {
            PlainTime plainTime = moment.toZonalTimestamp(tZID).getWallTime();
            int n = (plainTime.getHour() + 6) % 24;
            int n2 = plainTime.get(PlainTime.DECIMAL_HOUR).subtract(new BigDecimal(plainTime.getHour())).multiply(new BigDecimal(1080)).intValue();
            return new HebrewTime(n, n2);
        };
    }

    public boolean isNight() {
        return this.hour23 < 12;
    }

    public boolean isDay() {
        return this.hour23 >= 12;
    }

    public int getClockHour() {
        int n = this.hour23;
        if (this.isDay()) {
            n -= 12;
        }
        if (n == 0) {
            return 12;
        }
        return n;
    }

    public int getDigitalHour() {
        return this.hour23;
    }

    public int getPart() {
        return this.part;
    }

    @Override
    public boolean isAfter(HebrewTime hebrewTime) {
        return this.getTimeOfDay() > hebrewTime.getTimeOfDay();
    }

    @Override
    public boolean isBefore(HebrewTime hebrewTime) {
        return this.getTimeOfDay() < hebrewTime.getTimeOfDay();
    }

    @Override
    public boolean isSimultaneous(HebrewTime hebrewTime) {
        return this.getTimeOfDay() == hebrewTime.getTimeOfDay();
    }

    @Override
    public int compareTo(HebrewTime hebrewTime) {
        return this.getTimeOfDay() - hebrewTime.getTimeOfDay();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HebrewTime) {
            HebrewTime hebrewTime = (HebrewTime)object;
            return this.getTimeOfDay() == hebrewTime.getTimeOfDay();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getTimeOfDay();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.hour23);
        stringBuilder.append('H');
        stringBuilder.append(this.part);
        stringBuilder.append('P');
        return stringBuilder.toString();
    }

    public Optional<Moment> on(HebrewCalendar hebrewCalendar, SolarTime solarTime) {
        Optional<Moment> optional;
        Optional<Moment> optional2;
        HebrewTime hebrewTime;
        PlainDate plainDate = (PlainDate)hebrewCalendar.transform(PlainDate.axis());
        if (this.isNight()) {
            hebrewTime = this;
            optional2 = solarTime.sunset().apply((CalendarDate)plainDate.minus(CalendarDays.ONE));
            optional = solarTime.sunrise().apply(plainDate);
        } else {
            hebrewTime = (HebrewTime)this.minus(12L, Unit.HOURS);
            optional2 = solarTime.sunrise().apply(plainDate);
            optional = solarTime.sunset().apply(plainDate);
        }
        if (optional2.isPresent() && optional.isPresent()) {
            int n = (int)optional2.get().until((TimePoint)optional.get(), TimeUnit.SECONDS);
            if (optional2.get().getNanosecond() > optional.get().getNanosecond()) {
                --n;
            }
            Moment moment = (Moment)optional2.get().plus((long)Math.floor((double)(hebrewTime.getTimeOfDay() * n) / 12960.0), TimeUnit.SECONDS);
            return Optional.of(moment);
        }
        return Optional.empty();
    }

    public Moment on(HebrewCalendar hebrewCalendar, Timezone timezone) {
        int n = (this.hour23 + 18) % 24;
        BigDecimal bigDecimal = new BigDecimal(this.part);
        BigDecimal bigDecimal2 = bigDecimal.setScale(15, RoundingMode.UNNECESSARY).divide(new BigDecimal(1080), RoundingMode.FLOOR).add(new BigDecimal(n));
        PlainTime plainTime = (PlainTime)PlainTime.of(18).with(PlainTime.DECIMAL_HOUR, bigDecimal2);
        return hebrewCalendar.at(plainTime).in(timezone, StartOfDay.EVENING);
    }

    public static TimeAxis<Unit, HebrewTime> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, HebrewTime> getChronology() {
        return ENGINE;
    }

    @Override
    protected HebrewTime getContext() {
        return this;
    }

    private int getTimeOfDay() {
        return this.part + this.hour23 * 1080;
    }

    private static void registerUnits(TimeAxis.Builder<Unit, HebrewTime> builder) {
        EnumSet<Unit> enumSet = EnumSet.allOf(Unit.class);
        for (Unit unit : Unit.values()) {
            builder.appendUnit(unit, new ClockUnitRule(unit), unit.getLength(), enumSet);
        }
    }

    private Object writeReplace() {
        return new SPX(this, 13);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        TimeAxis.Builder<Unit, HebrewTime> builder = ((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, HebrewTime.class, new Merger(), MIN, MAX).appendElement((ChronoElement)CLOCK_CYCLE, (ElementRule)new CycleRule())).appendElement(CLOCK_HOUR, new IntegerElementRule(0), Unit.HOURS).appendElement(DIGITAL_HOUR, new IntegerElementRule(1), Unit.HOURS).appendElement(PART_OF_HOUR, new IntegerElementRule(2), Unit.HALAKIM);
        HebrewTime.registerUnits(builder);
        ENGINE = builder.build();
    }

    private static class Merger
    implements ChronoMerger<HebrewTime> {
        private Merger() {
        }

        @Override
        public HebrewTime createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            return HebrewTime.at(tZID).apply(Moment.from(timeSource.currentTime()));
        }

        @Override
        public HebrewTime createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = 0;
            if (chronoEntity.contains(PART_OF_HOUR) && ((n = chronoEntity.getInt(PART_OF_HOUR)) < 0 || n >= 1080)) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "PART_OF_HOUR out of range: " + n);
                return null;
            }
            if (chronoEntity.contains(CLOCK_CYCLE) && chronoEntity.contains(CLOCK_HOUR)) {
                ClockCycle clockCycle = chronoEntity.get(CLOCK_CYCLE);
                int n2 = chronoEntity.getInt(CLOCK_HOUR);
                if (n2 < 1 || n2 > 12) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "CLOCK_HOUR out of range: " + n2);
                    return null;
                }
                return new HebrewTime(clockCycle, n2, n);
            }
            if (chronoEntity.contains(DIGITAL_HOUR)) {
                int n3 = chronoEntity.getInt(DIGITAL_HOUR);
                if (n3 < 0 || n3 > 23) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "DIGITAL_HOUR out of range: " + n3);
                    return null;
                }
                return new HebrewTime(n3, n);
            }
            chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing cycle or hour of cycle.");
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.EVENING;
        }

        @Override
        public int getDefaultPivotYear() {
            return 100;
        }
    }

    private static class IntegerElementRule
    implements ElementRule<HebrewTime, Integer> {
        private final int index;

        IntegerElementRule(int n) {
            this.index = n;
        }

        @Override
        public Integer getValue(HebrewTime hebrewTime) {
            switch (this.index) {
                case 0: {
                    return hebrewTime.getClockHour();
                }
                case 1: {
                    return hebrewTime.hour23;
                }
                case 2: {
                    return hebrewTime.part;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMinimum(HebrewTime hebrewTime) {
            switch (this.index) {
                case 0: {
                    return 1;
                }
                case 1: 
                case 2: {
                    return 0;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMaximum(HebrewTime hebrewTime) {
            switch (this.index) {
                case 0: {
                    return 12;
                }
                case 1: {
                    return 23;
                }
                case 2: {
                    return 1079;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(HebrewTime hebrewTime, Integer n) {
            if (n == null) {
                return false;
            }
            return this.getMinimum(hebrewTime).compareTo(n) <= 0 && this.getMaximum(hebrewTime).compareTo(n) >= 0;
        }

        @Override
        public HebrewTime withValue(HebrewTime hebrewTime, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            int n2 = n;
            switch (this.index) {
                case 0: {
                    if (bl) {
                        return (HebrewTime)hebrewTime.plus(MathUtils.safeSubtract(n2, hebrewTime.getClockHour()), Unit.HOURS);
                    }
                    if (hebrewTime.isDay()) {
                        return HebrewTime.ofDay(n2, hebrewTime.part);
                    }
                    return HebrewTime.ofNight(n2, hebrewTime.part);
                }
                case 1: {
                    if (bl) {
                        return (HebrewTime)hebrewTime.plus(MathUtils.safeSubtract(n2, hebrewTime.hour23), Unit.HOURS);
                    }
                    return HebrewTime.ofDigital(n2, hebrewTime.part);
                }
                case 2: {
                    if (bl) {
                        return (HebrewTime)hebrewTime.plus(MathUtils.safeSubtract(n2, hebrewTime.part), Unit.HALAKIM);
                    }
                    return HebrewTime.ofDigital(hebrewTime.hour23, n2);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HebrewTime hebrewTime) {
            return this.index == 0 || this.index == 1 ? PART_OF_HOUR : null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HebrewTime hebrewTime) {
            return this.getChildAtFloor(hebrewTime);
        }
    }

    private static class CycleRule
    implements ElementRule<HebrewTime, ClockCycle> {
        private CycleRule() {
        }

        @Override
        public ClockCycle getValue(HebrewTime hebrewTime) {
            return hebrewTime.hour23 < 12 ? ClockCycle.NIGHT : ClockCycle.DAY;
        }

        @Override
        public HebrewTime withValue(HebrewTime hebrewTime, ClockCycle clockCycle, boolean bl) {
            if (clockCycle == null) {
                throw new IllegalArgumentException("Missing Hebrew cycle.");
            }
            return new HebrewTime(clockCycle, hebrewTime.getClockHour(), hebrewTime.getPart());
        }

        @Override
        public boolean isValid(HebrewTime hebrewTime, ClockCycle clockCycle) {
            return clockCycle != null;
        }

        @Override
        public ClockCycle getMinimum(HebrewTime hebrewTime) {
            return ClockCycle.NIGHT;
        }

        @Override
        public ClockCycle getMaximum(HebrewTime hebrewTime) {
            return ClockCycle.DAY;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HebrewTime hebrewTime) {
            return CLOCK_HOUR;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HebrewTime hebrewTime) {
            return CLOCK_HOUR;
        }
    }

    private static class UnitOperator
    implements ChronoOperator<HebrewTime> {
        private final Unit unit;
        private final boolean decrementing;

        private UnitOperator(Unit unit, boolean bl) {
            this.unit = unit;
            this.decrementing = bl;
        }

        @Override
        public HebrewTime apply(HebrewTime hebrewTime) {
            return (HebrewTime)hebrewTime.plus(this.decrementing ? -1L : 1L, this.unit);
        }
    }

    private static class ClockUnitRule
    implements UnitRule<HebrewTime> {
        private final Unit unit;

        private ClockUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public HebrewTime addTo(HebrewTime hebrewTime, long l) {
            int n;
            int n2;
            if (l == 0L) {
                return hebrewTime;
            }
            switch (this.unit) {
                case HOURS: {
                    n2 = MathUtils.floorModulo(MathUtils.safeAdd((long)hebrewTime.hour23, l), 24);
                    n = hebrewTime.part;
                    break;
                }
                case HALAKIM: {
                    long l2 = MathUtils.safeAdd((long)hebrewTime.part, l);
                    n = MathUtils.floorModulo(l2, 1080);
                    long l3 = MathUtils.floorDivide(l2, 1080);
                    n2 = MathUtils.floorModulo(MathUtils.safeAdd((long)hebrewTime.hour23, l3), 24);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            return new HebrewTime(n2, n);
        }

        @Override
        public long between(HebrewTime hebrewTime, HebrewTime hebrewTime2) {
            long l = hebrewTime2.getTimeOfDay() - hebrewTime.getTimeOfDay();
            switch (this.unit) {
                case HOURS: {
                    return l / 1080L;
                }
                case HALAKIM: {
                    return l;
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }
    }

    public static enum Unit implements ChronoUnit
    {
        HOURS(3600.0),
        HALAKIM(3.3333333333333335);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        public int between(HebrewTime hebrewTime, HebrewTime hebrewTime2) {
            return (int)hebrewTime.until(hebrewTime2, this);
        }
    }

    public static enum ClockCycle {
        NIGHT,
        DAY;

    }
}

