/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.ArrayList;
import java.util.Comparator;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Normalizer;
import net.time4j.engine.TimeSpan;

class StdNormalizer<U extends IsoUnit>
implements Normalizer<U>,
Comparator<TimeSpan.Item<? extends ChronoUnit>> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private final boolean mixed;

    private StdNormalizer(boolean bl) {
        this.mixed = bl;
    }

    static StdNormalizer<IsoUnit> ofMixedUnits() {
        return new StdNormalizer<IsoUnit>(true);
    }

    static StdNormalizer<CalendarUnit> ofCalendarUnits() {
        return new StdNormalizer<CalendarUnit>(false);
    }

    static StdNormalizer<ClockUnit> ofClockUnits() {
        return new StdNormalizer<ClockUnit>(false);
    }

    static Comparator<TimeSpan.Item<? extends ChronoUnit>> comparator() {
        return new StdNormalizer(false);
    }

    @Override
    public int compare(TimeSpan.Item<? extends ChronoUnit> item, TimeSpan.Item<? extends ChronoUnit> item2) {
        return StdNormalizer.compare(item.getUnit(), item2.getUnit());
    }

    @Override
    public Duration<U> normalize(TimeSpan<? extends U> timeSpan) {
        Enum enum_;
        long l;
        int n = timeSpan.getTotalLength().size();
        ArrayList arrayList = new ArrayList(n);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        block18: for (int i = 0; i < n; ++i) {
            TimeSpan.Item<U> item = timeSpan.getTotalLength().get(i);
            l = item.getAmount();
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            if (isoUnit instanceof CalendarUnit) {
                switch ((CalendarUnit)CalendarUnit.class.cast(isoUnit)) {
                    case MILLENNIA: {
                        l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), l2);
                        continue block18;
                    }
                    case CENTURIES: {
                        l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 100L), l2);
                        continue block18;
                    }
                    case DECADES: {
                        l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 10L), l2);
                        continue block18;
                    }
                    case YEARS: {
                        l2 = MathUtils.safeAdd(l, l2);
                        continue block18;
                    }
                    case QUARTERS: {
                        l3 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 3L), l3);
                        continue block18;
                    }
                    case MONTHS: {
                        l3 = MathUtils.safeAdd(l, l3);
                        continue block18;
                    }
                    case WEEKS: {
                        l4 = l;
                        continue block18;
                    }
                    case DAYS: {
                        l5 = l;
                        continue block18;
                    }
                    default: {
                        throw new UnsupportedOperationException(isoUnit.toString());
                    }
                }
            }
            if (isoUnit instanceof ClockUnit) {
                switch ((ClockUnit)ClockUnit.class.cast(isoUnit)) {
                    case HOURS: {
                        l6 = l;
                        continue block18;
                    }
                    case MINUTES: {
                        l7 = l;
                        continue block18;
                    }
                    case SECONDS: {
                        l8 = l;
                        continue block18;
                    }
                    case MILLIS: {
                        l9 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000000L), l9);
                        continue block18;
                    }
                    case MICROS: {
                        l9 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), l9);
                        continue block18;
                    }
                    case NANOS: {
                        l9 = MathUtils.safeAdd(l, l9);
                        continue block18;
                    }
                    default: {
                        throw new UnsupportedOperationException(isoUnit.toString());
                    }
                }
            }
            arrayList.add(TimeSpan.Item.of(l, isoUnit));
        }
        long l10 = 0L;
        l = 0L;
        long l11 = 0L;
        long l12 = 0L;
        if ((l6 | l7 | l8 | l9) != 0L) {
            l10 = l9 % 1000000000L;
            l8 = MathUtils.safeAdd(l8, l9 / 1000000000L);
            l = l8 % 60L;
            l7 = MathUtils.safeAdd(l7, l8 / 60L);
            l11 = l7 % 60L;
            l6 = MathUtils.safeAdd(l6, l7 / 60L);
            if (this.mixed) {
                l12 = l6 % 24L;
                l5 = MathUtils.safeAdd(l5, l6 / 24L);
            } else {
                l12 = l6;
            }
        }
        if ((l2 | l3 | l5) != 0L) {
            long l13 = MathUtils.safeAdd(l2, l3 / 12L);
            long l14 = l3 % 12L;
            long l15 = MathUtils.safeAdd(MathUtils.safeMultiply(l4, 7L), l5);
            if (l13 != 0L) {
                enum_ = CalendarUnit.YEARS;
                arrayList.add(TimeSpan.Item.of(l13, enum_));
            }
            if (l14 != 0L) {
                enum_ = CalendarUnit.MONTHS;
                arrayList.add(TimeSpan.Item.of(l14, enum_));
            }
            if (l15 != 0L) {
                enum_ = CalendarUnit.DAYS;
                arrayList.add(TimeSpan.Item.of(l15, enum_));
            }
        } else if (l4 != 0L) {
            enum_ = CalendarUnit.WEEKS;
            arrayList.add(TimeSpan.Item.of(l4, enum_));
        }
        if (l12 != 0L) {
            enum_ = ClockUnit.HOURS;
            arrayList.add(TimeSpan.Item.of(l12, enum_));
        }
        if (l11 != 0L) {
            enum_ = ClockUnit.MINUTES;
            arrayList.add(TimeSpan.Item.of(l11, enum_));
        }
        if (l != 0L) {
            enum_ = ClockUnit.SECONDS;
            arrayList.add(TimeSpan.Item.of(l, enum_));
        }
        if (l10 != 0L) {
            enum_ = ClockUnit.NANOS;
            arrayList.add(TimeSpan.Item.of(l10, enum_));
        }
        return new Duration(arrayList, timeSpan.isNegative());
    }

    static int compare(ChronoUnit chronoUnit, ChronoUnit chronoUnit2) {
        int n = Double.compare(chronoUnit2.getLength(), chronoUnit.getLength());
        if (n == 0 && !chronoUnit.equals(chronoUnit2)) {
            throw new IllegalArgumentException("Mixing different units of same length not allowed.");
        }
        return n;
    }
}

